package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.util.CollectionHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 17/1/6.
 */
@Service
@Slf4j
public class CourseApiServiceImpl implements CourseApiService{

    @Autowired
    private OrgCourseDao courseDao;
    @Autowired
    private OrgCourseConsumeRuleDao ruleDao;

    @Override
    public Map<Long, Long> mapClassIdToCourseId(Collection<Long> classIds) {
        Map<Long, Long> retMap = new HashMap<>();
        List<OrgCourse> courses = courseDao.getByIds(classIds, "id", "parentId", "isCourse", "isClass", "courseType");
        for (OrgCourse course:courses){
            if(course.getIsClass()== CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getIsCourse()==CourseTypeEnum.IS_COURSE_FALSE.getCode()){
                retMap.put(course.getId(),course.getParentId());
            }else {
                retMap.put(course.getId(), course.getId());
            }
        }
        return retMap;
    }

    @Override
    public Map<Long, Long> mapCourseIdToClassId(Collection<Long> classIds) {
        Map<Long, Long> retMap = new HashMap<>();
        List<OrgCourse> courses = courseDao.getByIds(classIds, "id", "parentId", "isCourse", "isClass", "courseType");
        for (OrgCourse course:courses){
            long courseId;
            if(course.getIsClass()== CourseTypeEnum.IS_CLASS_TRUE.getCode() && course.getIsCourse()==CourseTypeEnum.IS_COURSE_FALSE.getCode()){
                courseId = course.getParentId();
            }else {
                courseId = course.getId();
            }
            if(retMap.get(courseId)!=null && retMap.get(courseId)!=course.getId()){//同一课程对应了多个班级，证明业务存在问题，不能用这个方法
                throw new RuntimeException("同一课程下有多个班级");
            }
            retMap.put(courseId, course.getId());
        }
        return retMap;
    }

    @Override
    public Map<Long, OrgCourseConsumeRule> getClassRule(Collection<Long> classIds) {
        Map<Long, OrgCourseConsumeRule> ret = new HashMap<>();
        if(classIds!=null && !classIds.isEmpty()){
            Map<Long, Long> classIdToCourseIdMap = mapClassIdToCourseId(classIds);
            if(classIdToCourseIdMap!=null && !classIdToCourseIdMap.isEmpty()){
                List<OrgCourseConsumeRule> rules = ruleDao.queryConsumRuleListByCourseIds(null, classIdToCourseIdMap.values());
                Map<Long,OrgCourseConsumeRule> ruleMap = CollectionHelper.toKeyMap(rules,"courseId");
                for (Long classId:classIds){
                    ret.put(classId,ruleMap.get(classIdToCourseIdMap.get(classId)));
                }
            }
        }
        return ret;
    }
}
