package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.util.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by liuxp on 16/11/15.
 */
@Service
public class AccountApiServiceImpl implements AccountApiService {

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao subAccountDao;
    @Autowired
    private TXCascadeCredentialDao credentialDao;

    @Override
    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "未知";
        if (cascadeId > 0) {// 子账号
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            TXCascadeCredential credential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
            shortName = credential.getName();
        } else {// 主账号
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }

    @Override
    public Map<Long,String> getAccountNameMap(Long orgId, Collection<Integer> cascadeIds){
        Map<Long, String> map = credentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        if(cascadeIds.contains(0)){
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            map.put(0L,orgInfo.getContacts());
        }
        return map;
    }

    @Override
    public List<Integer> getAllTxOrgIds() {
        List<OrgSubAccount> accounts = this.subAccountDao.getAll(new String[]{"orgId"});
        List<Integer> list = ListUtil.toKeyList(accounts, "orgId", OrgSubAccount.class);
        return list;
    }
}
