/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.callservice.constant.OrgCallStatus;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.todo.po.TxbacklogParticipant;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class TXStudentCommentAPIServiceImpl implements TXStudentCommentAPIService{

	@Autowired
	private TxStudentCommentDao txStudentCommentDao;
	@Autowired
	private TxConsultUserDao consultUserDao;
	@Autowired
	private AccountApiService accountApiService;
	
	@Override
	public TxStudentComment saveTxStudentComment(TxStudentComment comment) {
		txStudentCommentDao.save(comment,false);
		return comment;
	}

	
	TxStudentComment buildTxStudentComment(TxConsultUser consultUser){
		TxStudentComment comment = new TxStudentComment();
		comment.setConsultUserId(consultUser.getId());
		comment.setUserId(consultUser.getUserId());
		comment.setOrgId(consultUser.getOrgId());
		comment.setOrigin(consultUser.getConsultSource());
		comment.setIsSystem(AddType.SYSTEM.getCode());
		return comment;
		
	}
	
	
	@Override
	public TxStudentComment saveByOrgActivitySignUp(TxConsultUser consultUser, String activityName, String userName, String mobile, String award) {
		TxStudentComment comment = buildTxStudentComment(consultUser);
		
		StringBuffer content = new StringBuffer("活动名称：");
		content.append(activityName).append("\n");
		content.append("姓名：").append(userName).append("\n");
		content.append("电话号码：").append(mobile);
		if(StringUtils.isNotBlank(award)){//存在award 说明来自抽奖活动
		    
			content.append("\n").append("中奖信息：").append(award);
        }
		
		comment.setContent(content.toString());
		txStudentCommentDao.save(comment, false);
		return comment;
	}



	@Override
	public TxStudentComment saveByOrgCall400(TxConsultUser consultUser, OrgPushCallInfo callInfo, boolean isNewConsultUser) {
		TxStudentComment comment = buildTxStudentComment(consultUser);

		if (isNewConsultUser) {
            comment.setContent("系统添加了客户: " + (StringUtils.isNotBlank(consultUser.getName()) ? consultUser.getName()
                    : TianXiaoConstant.ANONYMOUS_CONSULT_USER) + "\n");
        } else {
            comment.setContent("");
        }
		
        if (callInfo.getStatus().intValue() == OrgCallStatus.CONNECTED.getCode()) {
            if (null != callInfo.getStorageId() && callInfo.getStorageId() > 0) {
                comment.setSoundId(callInfo.getStorageId());
                comment.setDownStatus(DownLoadStatus.FINISH.getCode());
            } else {
                comment.setSoundId(callInfo.getId());
                comment.setDownStatus(DownLoadStatus.UNFINISH.getCode());
            }
            comment.setSeconds(callInfo.getDuringTime());
        }
        comment.setCallStatus(callInfo.getStatus());
        comment.setIsMobile(MobileStatus.IS_400_CALL.getCode());
        
        
        txStudentCommentDao.save(comment,false);
		return comment;
	}

	

	@Override
	public TxStudentComment saveByAdvisory(TxConsultUser consultUser, Long userId, String advisoryWords, boolean isNewConsultUser) {
		TxStudentComment comment = buildTxStudentComment(consultUser);

		StringBuffer content = new StringBuffer();
		if(isNewConsultUser) {
			content.append("系统添加了客户: " + (StringUtils.isNotBlank(consultUser.getName()) ? consultUser.getName() : TianXiaoConstant.APPOINTMENT_STUDENT_NAME) + "\n");
		}
		content.append("留单内容: " + (StringUtils.isNotBlank(advisoryWords) ? advisoryWords : "无"));
		comment.setContent(content.toString());
		comment.setUserId(userId);

		txStudentCommentDao.save(comment,false);
		return comment;
	}

	

	@Override
	public TxStudentComment saveByConsultUserManualAdd(TxConsultUser consultUser) {
		TxStudentComment comment = buildTxStudentComment(consultUser);
		
		String contentFmt = "添加了线索 %s";
        contentFmt = String.format(contentFmt, consultUser.getName());
        comment.setContent(contentFmt);
        
        txStudentCommentDao.save(comment,false);
		return comment;
	}


	
	@Override
	public TxStudentComment saveByConsultUserAssign(TxConsultUser consultUser, String ownerName) {
		TxStudentComment comment = buildTxStudentComment(consultUser);
		
		String contentFmt = "%s 被分配了 %s 这条线索.";
        contentFmt = String.format(contentFmt, ownerName, consultUser.getName());
        comment.setContent(contentFmt);
        
        txStudentCommentDao.save(comment,false);
		return comment;
	}


	
	@Override
	public TxStudentComment saveByConsultUserPull(TxConsultUser consultUser, String operatorName) {
		TxStudentComment comment = buildTxStudentComment(consultUser);
		
		String contentFmt = "%s 领取了 %s 这条线索.";
        contentFmt = String.format(contentFmt, operatorName, consultUser.getName());
        comment.setContent(contentFmt);
        
        txStudentCommentDao.save(comment,false);
		return comment;
	}


	
	@Override
	public TxStudentComment saveByConsultUserPush(TxConsultUser consultUser, String operatorName) {
		TxStudentComment comment = buildTxStudentComment(consultUser);
		
		String contentFmt = "%s 把线索释放回公海.";
        contentFmt = String.format(contentFmt, operatorName, consultUser.getName());
        comment.setContent(contentFmt);
        
        txStudentCommentDao.save(comment,false);
		return comment;
	}
	
	
	
	@Override
	public void batchSaveByRelease(List<Long> consulterIds) {
		
		List<TxStudentComment> list = new ArrayList<TxStudentComment>();
		String content = "线索到期 自动释放回公海.";
		
		for(int i=0; i<consulterIds.size(); i++){
			TxConsultUser consultUser = consultUserDao.getById( consulterIds.get(i) );
			TxStudentComment comment = buildTxStudentComment(consultUser);
			comment.setContent(content);
			list.add(comment);
			
			//每100批量插入
			if( (i != 0 && i % 100 == 0) || i == consulterIds.size() - 1 ){
				txStudentCommentDao.saveAll(list, false);
				list = new ArrayList<TxStudentComment>();
			}
		}
	}
	
	
	
	@Override
	public TxStudentComment saveByConsultUserChangeStatus(TxConsultUser consultUser, String operatorName, String reason) {
		TxStudentComment comment = buildTxStudentComment(consultUser);
		
		String contentFmt = "";
		if (consultUser.getIsInvalid().intValue() == Flag.FALSE.getInt()){
			contentFmt = "%s 将线索 %s 的状态修改为有效.";
            contentFmt = String.format(contentFmt, operatorName, consultUser.getName());
		}else{
			contentFmt= "%s 将线索 %s 的状态修改为无效.\n标记原因:%s";
            contentFmt = String.format(contentFmt, operatorName, consultUser.getName(), reason);
		}
		comment.setContent(contentFmt);
		
        txStudentCommentDao.save(comment,false);
		return comment;
	}


	@Override
	public TxStudentComment saveByConsultUserPassTo(TxConsultUser consultUser, String from, String to) {
		TxStudentComment comment = buildTxStudentComment(consultUser);
		
		String contentFmt = "%s 把线索转交给 %s";
        contentFmt = String.format(contentFmt, from, to);
        comment.setContent(contentFmt);
		
        txStudentCommentDao.save(comment,false);
		return comment;
	}


	
	@Override
	public TxStudentComment saveByMobileChange(TxConsultUser consultUser, String oldMobile, String newMobile) {
		if( !oldMobile.equals(newMobile) ){
			TxStudentComment comment = buildTxStudentComment(consultUser);
			
			String contentFmt = " 将手机号【%s】修改为【%s】";
	        contentFmt = String.format(contentFmt, oldMobile, newMobile);
	        comment.setContent(contentFmt);
	        txStudentCommentDao.save(comment,false);
			return comment;
		}
		return null;
	}


	@Override
	public TxStudentComment saveByNameChange(TxConsultUser consultUser, String oldName, String newName) {
		if( !oldName.equals(newName) ){
			TxStudentComment comment = buildTxStudentComment(consultUser);
			
			String contentFmt = " 将姓名【%s】修改为【%s】";
	        contentFmt = String.format(contentFmt, oldName, newName);
	        comment.setContent(contentFmt);
	        txStudentCommentDao.save(comment,false);
			return comment;
		}
		return null;
	}
	
	
	
	@Override
	public TxStudentComment saveByStudentMerge(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
		List<TxStudentComment> comments = txStudentCommentDao.getComments(sourceConsultUser.getId(), orgId, StudentType.CONSULT_USER.getCode());
		
		//修改源跟进记录所属人
        if (comments != null && !comments.isEmpty()) {
            for (TxStudentComment comment : comments) {
                comment.setConsultUserId(destConsultUser.getId());
                comment.setUserId(destConsultUser.getUserId());
                comment.setUpdateTime(new Date());
                this.txStudentCommentDao.update(comment, new String[] { "consultUserId", "userId", "updateTime" });
            }
        }

        //添加合并跟进记录
        String sourceName = sourceConsultUser.getName();
        String sourceNickName = sourceConsultUser.getNickName();
        String destName = destConsultUser.getName();
        String destNickName = destConsultUser.getNickName();

        String sourceMobile = sourceConsultUser.getMobile();
        String destMobile = destConsultUser.getMobile();
        StringBuffer sb = new StringBuffer();
        sb.append("您将学生【" + getConsulterName(sourceName, sourceNickName) + "】");
        if (StringUtils.isNotBlank(sourceMobile)) {
            sb.append("【" + sourceMobile + "】");
        }
        sb.append("和学生【" + getConsulterName(destName, destNickName) + "】");
        if (StringUtils.isNotBlank(destMobile)) {
            sb.append("【" + destMobile + "】");
        }
        sb.append("合并了");
        
        TxStudentComment addComment = new TxStudentComment();
        addComment.setCallStatus(0);
        addComment.setConsultUserId(destConsultUser.getId());
        addComment.setUserId(destConsultUser.getUserId());
        addComment.setOrgId(orgId);
        addComment.setCreateTime(new Date());
        addComment.setIsSystem(AddType.SYSTEM.getCode());
        addComment.setContent( sb.toString() );
        
        this.txStudentCommentDao.save(addComment);
        log.info("orgId:{}, addComment:{}", orgId, addComment);
        
        return addComment;
	}
	private String getConsulterName(String source, String dest) {
        return StringUtils.isNotBlank(source) ? source : StringUtils.isNotBlank(dest) ? dest : "匿名用户";
    }

	
	@Override
	public TxStudentComment saveBySignUpPurchase(OrgSignupInfo orgSignupInfo, String courseNames) {
		StringBuffer sb = new StringBuffer();
        sb.append("报班:[").append(courseNames).append("]总价:¥");
        if(orgSignupInfo.getTotalPrices().equals(0)){
        	sb.append( "0.00" ).append("元");
        }else{
        	sb.append( new BigDecimal(orgSignupInfo.getTotalPrices().doubleValue() / 100).setScale(2,   BigDecimal.ROUND_HALF_UP) ).append("元");
        }
        
		
		TxStudentComment comment = new TxStudentComment();
		comment.setOrgId(orgSignupInfo.getOrgId());
        comment.setUserId(orgSignupInfo.getUserId());
        comment.setCreateTime(orgSignupInfo.getUpdateTime());
        comment.setUpdateTime(orgSignupInfo.getUpdateTime());
        comment.setContent(sb.toString());
        comment.setIsSystem(AddType.SYSTEM.getCode());
        
        this.txStudentCommentDao.save(comment);
        return comment;
	}


	@Override
	public TxStudentComment saveByCoursePurchase(Long orgId, Long userId, Date createTime, String courseName, Double price) {
		String content = "报班:[%s]总价:¥%s元";
		content = String.format(content, courseName, price);
		
		TxStudentComment comment = new TxStudentComment();
        comment.setOrgId(orgId);
        comment.setUserId(userId);
        comment.setCreateTime(createTime);
        comment.setUpdateTime(createTime);
        comment.setContent(content);
        comment.setIsSystem(AddType.SYSTEM.getCode());
        
        this.txStudentCommentDao.save(comment);
        return comment;
	}


	@Override
	public TxStudentComment saveByAddStudent(OrgStudent student) {
		TxStudentComment comment = new TxStudentComment();
        if (StringUtils.isNotEmpty(student.getName())) {
            comment.setContent("添加学员 " + student.getName());
        } else {
            comment.setContent("添加学员 " + student.getNickName());
        }
        comment.setOrgId(student.getOrgId());
        comment.setUserId(student.getUserId());
        comment.setCreateTime(student.getCreateTime());
        comment.setIsSystem(AddType.SYSTEM.getCode());
        
        this.txStudentCommentDao.save(comment);
        return comment;
	}

	@Override
	public TxStudentComment saveByStudentPassTo(OrgStudent student, String from, String to) {
		TxStudentComment comment = new TxStudentComment();
		String contentFmt = "%s 把学员转交给 %s";
		contentFmt = String.format(contentFmt, from, to);
		comment.setContent(contentFmt);
		comment.setOrgId(student.getOrgId());
		comment.setUserId(student.getUserId());
		comment.setCreateTime(new Date());
		comment.setIsSystem(AddType.SYSTEM.getCode());
		txStudentCommentDao.save(comment,false);
		return comment;
	}


	
	String getParticipantsNameStr(List<TxbacklogParticipant> list){
		StringBuilder builder = new StringBuilder();
		String accountName = "";
		TxbacklogParticipant obj;
		
		if(CollectionUtils.isNotEmpty(list)){
			for(int i=0; i<list.size(); i++){
				obj = list.get(i);
				accountName = accountApiService.getAccountName(obj.getOrgId(), obj.getCascadeId());
				builder.append(accountName);
				if(i!=list.size()-1){
					builder.append(", ");
				}
			}
		}
		
		return builder.toString();
	}
	
	@Override
	public TxStudentComment saveByBacklogAdd(Long userId, TxBacklog txBacklog, List<TxbacklogParticipant> participants) {
		
		Long cascadeId = (txBacklog.getCascadeId()!=null ? txBacklog.getCascadeId().longValue() : 0L);
		String accountName = accountApiService.getAccountName(txBacklog.getOrgId(), cascadeId);
		String participantsNameStr = getParticipantsNameStr(participants);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm");
		
		StringBuilder builder = new StringBuilder();
		builder.append(accountName).append(" 创建了学员跟进计划").append("\n");
		builder.append("跟进时间: ").append( sdf.format(txBacklog.getEndTime()) ).append("\n");
		builder.append("参与人 : ").append( participantsNameStr ).append("\n");
		builder.append("待办事项: ").append( txBacklog.getContent() );
		
		TxStudentComment comment = new TxStudentComment();
		comment.setUserId(userId);
		comment.setConsultUserId( txBacklog.getConsultUserId() );
		comment.setOrgId( txBacklog.getOrgId() );
		comment.setCreateTime(new Date());
		comment.setIsSystem(AddType.SYSTEM.getCode());
		comment.setContent(builder.toString());
		
		txStudentCommentDao.save(comment,false);
		return comment;
	}


	@Override
	public TxStudentComment saveByBacklogDel(Long userId, TxBacklog txBacklog, List<TxbacklogParticipant> participants) {
		
		Long cascadeId = (txBacklog.getCascadeId()!=null ? txBacklog.getCascadeId().longValue() : 0L);
		String accountName = accountApiService.getAccountName(txBacklog.getOrgId(), cascadeId);
		String participantsNameStr = getParticipantsNameStr(participants);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm");
		
		StringBuilder builder = new StringBuilder();
		builder.append(accountName).append(" 删除了学员跟进计划").append("\n");
		builder.append("跟进时间: ").append( sdf.format(txBacklog.getEndTime()) ).append("\n");
		builder.append("参与人 : ").append( participantsNameStr ).append("\n");
		builder.append("待办事项: ").append( txBacklog.getContent() );
		
		TxStudentComment comment = new TxStudentComment();
		comment.setUserId(userId);
		comment.setConsultUserId( txBacklog.getConsultUserId() );
		comment.setOrgId( txBacklog.getOrgId() );
		comment.setCreateTime(new Date());
		comment.setIsSystem(AddType.SYSTEM.getCode());
		comment.setContent(builder.toString());
		txStudentCommentDao.save(comment,false);
		
		return comment;
	}


	@Override
	public TxStudentComment saveByBacklogUpdate(Long userId,
												TxBacklog txBacklogOld, TxBacklog txBacklogNew,
												List<TxbacklogParticipant> participantsOld, 
												List<TxbacklogParticipant> participantsNew) {
		
		Long cascadeId = (txBacklogNew.getCascadeId()!=null ? txBacklogNew.getCascadeId().longValue() : 0L);
		String accountName = accountApiService.getAccountName(txBacklogNew.getOrgId(), cascadeId);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm");
		
		boolean dataChange = true;
		StringBuilder builder = new StringBuilder();
		builder.append(accountName).append(" 修改了学员跟进计划").append("\n");
		
		if( !txBacklogOld.getEndTime().equals(txBacklogNew.getEndTime()) ){
			dataChange = true;
			builder.append("原跟进时间: ").append( sdf.format(txBacklogOld.getEndTime()) ).append("\n");
			builder.append("现跟进时间: ").append( sdf.format(txBacklogNew.getEndTime()) ).append("\n");
		}
		
		if(participantsOld!=null && participantsNew!=null){
			boolean participantsChange = false;
			if(participantsOld.size() != participantsNew.size()){
				participantsChange = true;
			}else{
				HashSet<Long> set = new HashSet<Long>();
				for(TxbacklogParticipant obj:participantsOld){
					set.add(obj.getCascadeId());
				}
				for(TxbacklogParticipant obj:participantsNew){
					set.add(obj.getCascadeId());
				}
				if(participantsOld.size()!=set.size()){
					participantsChange = true;
				}
			}
			
			if(participantsChange){
				dataChange = true;
				builder.append("原参与人 : ").append( getParticipantsNameStr(participantsOld) ).append("\n");
				builder.append("现参与人 : ").append( getParticipantsNameStr(participantsNew) ).append("\n");
			}
		}
		
		if( !txBacklogOld.getEndTime().equals(txBacklogNew.getEndTime()) ){
			dataChange = true;
			builder.append("原待办事项: ").append( txBacklogOld.getContent() );
			builder.append("现待办事项: ").append( txBacklogNew.getContent() );
		}
		
		
		if(dataChange){
			TxStudentComment comment = new TxStudentComment();
			comment.setUserId(userId);
			comment.setConsultUserId( txBacklogNew.getConsultUserId() );
			comment.setOrgId( txBacklogNew.getOrgId() );
			comment.setCreateTime(new Date());
			comment.setIsSystem(AddType.SYSTEM.getCode());
			
			comment.setContent(builder.toString());
			txStudentCommentDao.save(comment,false);
			return comment;
		}else{
			return null;
		}
	}


	

}

