package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

/**
 * Created by liuxp on 16/10/26.
 */
@Slf4j
@Service
public class RedisDefaultServiceImpl extends AbstractBaseRedisDao<String, String> implements RedisDefaultService {

    public String hGet(final String key, final String field) {
        return execute(new RedisCallback<String>() {
            @Override
            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(TianXiaoConstant.TX_PV_REDIS_DB);
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize(key);
                byte[] byteFiled = serializer.serialize(field);
                byte[] value = connection.hGet(byteKey, byteFiled);
                if (value != null) {
                    return serializer.deserialize(value);
                } else {
                    return null;
                }
            }
        });
    }

    public void hSet(final String key, final String field, final String value) {
        execute(new RedisCallback<Object>() {
            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                RedisSerializer<String> serializer = redisTemplate.getStringSerializer();
                byte[] byteKey = serializer.serialize(key);
                byte[] byteFiled = serializer.serialize(field);
                byte[] byteValue = serializer.serialize(value);
                connection.hSet(byteKey, byteFiled, byteValue);
                return null;
            }
        });
    }

    private <T> T execute(RedisCallback<T> callback){
        Exception ex = null;
        for (int i = 0; i < 3; i++) {// 如果出现异常重试三次
            try {
                return redisTemplate.execute(callback);
            } catch (Exception e) {
                ex = e;
                try {
                    if (i < 2) {
                        Thread.sleep((i + 1) * 500);
                    }
                    log.warn("[Redis] try connect to redis.count={}",i+1);
                } catch (InterruptedException e1) {
                    log.error("[Redis] InterruptedException ", e1);
                }
            }
        }
        log.error("[Redis] Query data exception.", ex);
        return null;
    }

}
