package com.baijia.tianxiao.sal.common.impl;

import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by liuxp on 16/11/15.
 */
@Service
public class AccountApiServiceImpl implements AccountApiService {

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Resource
    private OrgInfoDao orgInfoDao;

    @Override
    public String getAccountName(Long orgId, Long cascadeId) {
        String shortName = "未知";
        if (cascadeId > 0) {// 子账号
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            TXCascadeCredential credential = txCascadeCredentialDao.getById(txCascadeAccount.getCredentialId());
            shortName = credential.getName();
        } else {// 主账号
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            shortName = orgInfo.getContacts();
        }
        return shortName;
    }
}
