package com.baijia.tianxiao.sal.comment.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.comment.dao.OrgCommentAuditDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.comment.po.OrgCommentAudit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dto.MultiStatusValue;
import com.baijia.tianxiao.sal.comment.dto.response.AmountTendencyDto;
import com.baijia.tianxiao.sal.comment.dto.response.CommentStatisticData;
import com.baijia.tianxiao.sal.comment.dto.response.ScoreTendencyDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentStatisticService;
import com.baijia.tianxiao.sal.elastic.dto.LessonCommentStatistic;
import com.baijia.tianxiao.sal.elastic.service.LessonCommentStatisticEsQueryer;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.util.ThreeTuple;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 18/10/2017 2:34 PM
 * @see LessonCommentStatistic
 */
@Slf4j
@Service
public class LessonCommentStatisticServiceImpl implements LessonCommentStatisticService {

    @Autowired
    private OrgCommentAuditDao orgCommentAuditDao;

    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;

    @Autowired
    private OrgClassLessonDao orgClassLessonDao;

    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Autowired
    private LessonCommentStatisticEsQueryer lessonCommentStatisticEsQueryer;

    public List<ScoreTendencyDto> scoreTendency(Long orgId, Long txCascadeIdLongZeroFill, Integer type) {
        LinkedList<ScoreTendencyDto> result = Lists.newLinkedList();
        if (type == 0) {// 天
            Date end = DateUtil.getDiffDateTime(DateUtil.getStartOfDay(new Date()), 1);
            for (int i = 0; i < 7; i++) {
                Date start = DateUtil.getDiffDateTime(end, -1);
                result.addFirst(new ScoreTendencyDto(start, end));
                end = start;
            }
        } else { // 周
            Date end = DateUtil.getDiffDateTime(DateUtil.getStartOfDay(DateUtil.getEndOfWeek()), 1);
            for (int i = 0; i < 5; i++) {
                Date start = DateUtil.getDiffDateTime(end, -7);
                result.addFirst(new ScoreTendencyDto(start, DateUtil.getDiffMinute(end, -1)));
                end = start;
            }
        }
        Set<Long> lessonIds = Sets.newHashSet();
        if (txCascadeIdLongZeroFill > 0) {
            RoleType roleType = RoleType.getRoleType(txCascadeAccountDao.getAccountTypeById(txCascadeIdLongZeroFill));
            if (roleType == RoleType.EMPLOYEE) {
                List<Long> classIds = orgCourseDao.getCourseIdsByCascadeId(txCascadeIdLongZeroFill.intValue(), null,
                    CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                OrgTeacher orgTeacher =
                    txCascadeCredentialService.getTeacherByAccount(orgId, txCascadeIdLongZeroFill.intValue());
                log.info("statistic find teacher:{} ", orgTeacher);
                lessonIds.addAll(orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, classIds,
                    result.getFirst().getStartTime(), result.getLast().getEndTime()));
                if (null != orgTeacher) {
                    lessonIds.addAll(orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
                }
                if (CollectionUtils.isEmpty(lessonIds)) {
                    log.info("statistic find no lessonIds. orgID:{}, cascadeId:{}, type:{} ", orgId,
                        txCascadeIdLongZeroFill, type);
                    return result;
                }
            }
        }

        for (ScoreTendencyDto dto : result) {
            dto.setScore(lessonCommentStatisticEsQueryer.avgScoreTimeRange(orgId, lessonIds, dto));
        }
        return result;
    }

    public List<AmountTendencyDto> amountTendency(Long orgId, Long txCascadeIdLongZeroFill, Integer type) {
        LinkedList<AmountTendencyDto> result = Lists.newLinkedList();
        if (type == 0) {// 天
            Date end = DateUtil.getDiffDateTime(DateUtil.getStartOfDay(new Date()), 1);
            for (int i = 0; i < 7; i++) {
                Date start = DateUtil.getDiffDateTime(end, -1);
                result.addFirst(new AmountTendencyDto(start, end));
                end = start;
            }
        } else { // 周
            Date end = DateUtil.getDiffDateTime(DateUtil.getStartOfDay(DateUtil.getEndOfWeek()), 1);
            for (int i = 0; i < 5; i++) {
                Date start = DateUtil.getDiffDateTime(end, -7);
                result.addFirst(new AmountTendencyDto(start, DateUtil.getDiffMinute(end, -1)));
                end = start;
            }
        }
        Set<Long> lessonIds = Sets.newHashSet();
        if (txCascadeIdLongZeroFill > 0) {
            RoleType roleType = RoleType.getRoleType(txCascadeAccountDao.getAccountTypeById(txCascadeIdLongZeroFill));
            if (roleType == RoleType.EMPLOYEE) {
                List<Long> classIds = orgCourseDao.getCourseIdsByCascadeId(txCascadeIdLongZeroFill.intValue(), null,
                    CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                OrgTeacher orgTeacher =
                    txCascadeCredentialService.getTeacherByAccount(orgId, txCascadeIdLongZeroFill.intValue());
                log.info("statistic find teacher:{} ", orgTeacher);
                lessonIds.addAll(orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, classIds,
                    result.getFirst().getStartTime(), result.getLast().getEndTime()));
                if (null != orgTeacher) {
                    lessonIds.addAll(orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
                }
                if (CollectionUtils.isEmpty(lessonIds)) {
                    log.info("statistic find no lessonIds. orgID:{}, cascadeId:{}, type:{} ", orgId,
                        txCascadeIdLongZeroFill, type);
                    return result;
                }
            }
        }

        for (AmountTendencyDto dto : result) {
            dto.setCount(lessonCommentStatisticEsQueryer.commentCountTimeRange(orgId, lessonIds, dto));
        }
        return result;
    }

    /**
     * 傻逼需求 逻辑真鸡儿恶心
     * 
     * @param orgId
     * @param cascadeId
     * @param type
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public CommentStatisticData commentStatistic(Long orgId, Long cascadeId, Integer type) {
        if (cascadeId > 0) { // cascade
            RoleType roleType = RoleType.getRoleType(txCascadeAccountDao.getAccountTypeById(cascadeId));
            if (roleType == RoleType.EMPLOYEE) {
                return statisticByCascade(orgId, cascadeId, type);
            }
        }
        return statisticByOrg(orgId, type);
    }

    private CommentStatisticData statisticByCascade(Long orgId, Long cascadeId, Integer type) {
        CommentStatisticData result = new CommentStatisticData();
        result.setIsShowComparison(1);

        List<Long> classIds = orgCourseDao.getCourseIdsByCascadeId(cascadeId.intValue(), null,
            CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        OrgTeacher orgTeacher = txCascadeCredentialService.getTeacherByAccount(orgId, cascadeId.intValue());
        log.info("statistic find teacher:{} ", orgTeacher);
        Set<Long> lessonIds = Sets.newHashSet();
        Date end = DateUtil.getEndOfDay(new Date());
        if (null == type || type == Flag.NULL.getInt()) {// 所有时间的lessonIds
            lessonIds.addAll(orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, classIds, null, end));
            if (null != orgTeacher) {
                lessonIds.addAll(orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
            }
        } else {// 最近七天的lessonIds
            Date start = DateUtil.getDiffDateTime(end, -7);
            lessonIds.addAll(orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, classIds, start, end));
            if (null != orgTeacher) {
                lessonIds
                    .addAll(orgTeacherLessonDao.getTeacherLessonIdsByStartTime(start, end, orgTeacher.getUserId()));
            }
        }

        if (CollectionUtils.isEmpty(lessonIds)) {
            log.info("statistic find no lessonIds. orgID:{}, cascadeId:{}, type:{} ", orgId, cascadeId, type);
            return result;
        }
        log.info("statistic find lessonIds size:{} ", lessonIds.size());

        // studentComment
        TwoTuple<Long, Long> studenComment =
            orgLessonCommentDao.getCommentStatistic(orgId, lessonIds, UserRole.STUDENT.getRole());
        result.setScore(new MultiStatusValue(
            studenComment.getFirst() > 0 ? studenComment.getSecond() / studenComment.getFirst() : 0, 0));
        Integer studentLessonCount = orgStudentLessonDao.countLessonStudent(lessonIds);
        result.setStudentCommentCount(new MultiStatusValue(studenComment.getFirst(), 0));
        result.setStudentCommentRatio(
            new MultiStatusValue(studentLessonCount > 0 ? studenComment.getFirst() * 100 / studentLessonCount : 0, 0));
        // teacherComment
        Integer teacherCommentCount =
            orgLessonCommentDao.getCommentCount(orgId, lessonIds, UserRole.TEACHER.getRole(), null, null, null, false);
        result.setTeacherCommentCount(new MultiStatusValue(teacherCommentCount, 0));
        result.setTeacherCommentRatio(
            new MultiStatusValue(studentLessonCount > 0 ? teacherCommentCount * 100 / studentLessonCount : 0, 0));

        log.info("statistic result:{} ", result);
        return result;
    }

    private CommentStatisticData statisticByOrg(Long orgId, Integer type) {
        CommentStatisticData result = new CommentStatisticData();
        result.setIsShowComparison(0);
        OrgCommentAudit audit = orgCommentAuditDao.getCommentAuditByOrgId(orgId);
        if (null == type || type == Flag.NULL.getInt()) {
            if (null != audit) {
                result.setScore(new MultiStatusValue(audit.getScore(), 0));
                // studentComment
                Integer studenCommentCount = orgLessonCommentDao.getCommentCount(orgId, null,
                    UserRole.STUDENT.getRole(), null, null, null, false);
                Integer studentLessonCount = orgStudentLessonDao.getFinishLessonStudentCount(orgId);
                log.debug("studentLessonCount:{} ", studentLessonCount);
                result.setStudentCommentCount(new MultiStatusValue(studenCommentCount, 0));
                result.setStudentCommentRatio(new MultiStatusValue(
                    studentLessonCount > 0 ? studenCommentCount * 100 / studentLessonCount : 0, 0));
                // teacherComment
                Integer teacherCommentCount = orgLessonCommentDao.getCommentCount(orgId, null,
                    UserRole.TEACHER.getRole(), null, null, null, false);
                result.setTeacherCommentCount(new MultiStatusValue(teacherCommentCount, 0));
                result.setTeacherCommentRatio(new MultiStatusValue(
                    studentLessonCount > 0 ? teacherCommentCount * 100 / studentLessonCount : 0, 0));
                // avg
                ThreeTuple<Integer, Integer, Integer> score = orgCommentAuditDao.getAvgScoreByAreaId(audit.getAreaId());
                Integer compare = 0;
                Integer status = 0;
                if (audit.getScore() == 0){
                    status = -1;
                } else if (audit.getScore() > score.getSecond()) {
                    Integer diff = score.getThree() - score.getSecond();
                    compare = diff != 0 ? (audit.getScore() - score.getSecond()) * 100 / diff : 0;
                } else if (audit.getScore() < score.getSecond()) {
                    Integer diff = score.getSecond() - score.getFirst();
                    compare = diff != 0 ? (audit.getScore() - score.getSecond()) * 100 / diff : 0;
                }
                result.setComparison(new MultiStatusValue(compare, status));
            }
        } else {
            if (null != audit) {
                // recent lessons
                Date end = DateUtil.getEndOfDay(new Date());
                Date start = DateUtil.getDiffDateTime(end, -7);
                List<Long> lessonIds = orgClassLessonDao.queryLessonByStartTime(orgId, start, end, null);
                result.setScore(new MultiStatusValue(audit.getRecentScore(), 0));
                // studentComment
                Integer studenCommentCount = orgLessonCommentDao.getCommentCount(orgId, lessonIds,
                    UserRole.STUDENT.getRole(), null, null, null, false);
                Integer studentLessonCount = orgStudentLessonDao.countLessonStudent(lessonIds);
                result.setStudentCommentCount(new MultiStatusValue(studenCommentCount, 0));
                result.setStudentCommentRatio(new MultiStatusValue(
                    studentLessonCount > 0 ? studenCommentCount * 100 / studentLessonCount : 0, 0));
                // teacherComment
                Integer teacherCommentCount = orgLessonCommentDao.getCommentCount(orgId, lessonIds,
                    UserRole.TEACHER.getRole(), null, null, null, false);
                result.setTeacherCommentCount(new MultiStatusValue(teacherCommentCount, 0));
                result.setTeacherCommentRatio(new MultiStatusValue(
                    studentLessonCount > 0 ? teacherCommentCount * 100 / studentLessonCount : 0, 0));
                // avg
                ThreeTuple<Integer, Integer, Integer> score =
                    orgCommentAuditDao.getAvgRecentScoreByAreaId(audit.getAreaId());
                log.debug("score:{}", score);
                log.debug("audit:{}", audit);
                Integer compare = 0;
                Integer status = 0;
                if (audit.getRecentScore() == 0){
                    status = -1;
                } else if (audit.getRecentScore() > score.getSecond()) {
                    Integer diff = score.getThree() - score.getSecond();
                    compare = diff != 0 ? (audit.getRecentScore() - score.getSecond()) * 100 / diff : 0;
                } else if (audit.getRecentScore() < score.getSecond()) {
                    Integer diff = score.getSecond() - score.getFirst();
                    compare = diff != 0 ? (audit.getRecentScore() - score.getSecond()) * 100 / diff : 0;
                }
                result.setComparison(new MultiStatusValue(compare, status));
            }
        }
        return result;
    }
}
