package com.baijia.tianxiao.sal.comment.service.impl;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.sal.comment.dto.ClassBasicDto;
import com.baijia.tianxiao.sal.comment.dto.LessonBasicDto;
import com.baijia.tianxiao.sal.comment.dto.response.CommentCourseStatisticData;
import com.baijia.tianxiao.sal.comment.dto.response.CommentUserDto;
import com.baijia.tianxiao.sal.comment.service.CourseCommentStatisticService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.sal.elastic.dto.CourseCommentStatistic;
import com.baijia.tianxiao.sal.elastic.service.CourseCommentStatisticEsQueryer;
import com.baijia.tianxiao.sal.elastic.service.OrgTeacherDocumentQueryService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 23/10/2017 4:33 PM
 */
@Slf4j
@Service
public class CourseCommentStatisticServiceImpl implements CourseCommentStatisticService {

    @Autowired
    private CourseCommentStatisticEsQueryer courseCommentStatisticEsQueryer;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgTeacherDocumentQueryService orgTeacherDocumentQueryService;

    @Autowired
    private OrgTeacherApiService orgTeacherApiService;

    @Autowired
    private OrgClassLessonDao orgClassLessonDao;

    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;

    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Override
    public List<LessonBasicDto> listUncommentedLessonsByClass(Long orgId, Long cascadeId, Long classId) {
        List<LessonBasicDto> result = Lists.newArrayList();
        Set<Long> lessonIds = Sets.newHashSet();
        if (cascadeId > 0) {
            RoleType roleType = RoleType.getRoleType(txCascadeAccountDao.getAccountTypeById(cascadeId));
            if (roleType == RoleType.EMPLOYEE) {
                List<Long> classIds = orgCourseDao.getCourseIdsByCascadeId(cascadeId.intValue(), null,
                    CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                OrgTeacher orgTeacher = txCascadeCredentialService.getTeacherByAccount(orgId, cascadeId.intValue());
                log.info("statistic find teacher:{} ", orgTeacher);
                lessonIds.addAll(orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, classIds, null, null));
                if (null != orgTeacher) {
                    lessonIds.addAll(orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
                }
                if (CollectionUtils.isEmpty(lessonIds)) {
                    return result;
                }
            }
        }
        List<OrgClassLesson> lessons =
            orgClassLessonDao.getUncommentedLessons(orgId, lessonIds, Lists.newArrayList(classId));
        for (OrgClassLesson lesson : lessons) {
            LessonBasicDto dto = new LessonBasicDto();
            dto.setClassId(lesson.getCourseId());
            dto.setLessonId(lesson.getId());
            dto.setIndex(lesson.getNumber());
            dto.setStartTime(lesson.getStartTime());
            dto.setEndTime(lesson.getEndTime());
            dto.setLeftCount(lesson.getStudentCount() - lesson.getTeacherCommentCount());
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<ClassBasicDto> listUncommentedClasses(Long orgId, Long cascadeId, String searchKey, PageDto pageDto) {
        Set<Long> lessonIds = Sets.newHashSet();
        Set<Long> classIds = Sets.newHashSet();
        Set<Long> notInClassIds = Sets.newHashSet();
        List<ClassBasicDto> result = Lists.newArrayList();

        Long orgNumber = orgAccountDao.getById(orgId, "number").getNumber().longValue();
        if (StringUtils.isNotBlank(searchKey)) {
            List<Long> teacherUserIds = orgTeacherDocumentQueryService.quertTeacherUserIds(orgId, searchKey);
            classIds.addAll(orgCourseTeacherDao.getCourseIdsByteacherIds(teacherUserIds));
            classIds.addAll(orgCourseDao.getCourseIdsByOrgNumberAndCourseName(orgNumber.longValue(), searchKey, null,
                null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null));
            if (CollectionUtils.isEmpty(classIds)) {
                return Lists.newArrayList();
            }
        }

        if (cascadeId > 0) {
            RoleType roleType = RoleType.getRoleType(txCascadeAccountDao.getAccountTypeById(cascadeId));
            if (roleType == RoleType.EMPLOYEE) {
                List<Long> classIdsCascade = orgCourseDao.getCourseIdsByCascadeId(cascadeId.intValue(), null,
                    CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                lessonIds.addAll(orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, classIdsCascade, null, null));
                OrgTeacher orgTeacher = txCascadeCredentialService.getTeacherByAccount(orgId, cascadeId.intValue());
                log.info("statistic find teacher:{} ", orgTeacher);
                if (null != orgTeacher) {
                    lessonIds.addAll(orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
                }
                if (CollectionUtils.isEmpty(lessonIds)) {
                    return result;
                }
            }
        }
        notInClassIds.addAll(orgCourseDao.getDeletedOrFinishedCourseIdsByOrgNumber(orgNumber));

        List<Long> resultClassIds = orgClassLessonDao.groupCourseIdByParams(orgId, lessonIds, notInClassIds, classIds,
            null, new Date(), pageDto);
        log.info("resultClassIds:{} ", resultClassIds);
        // 数据
        Map<Long, List<Long>> courseIdTeacherListMap = orgCourseTeacherDao.getTeacherMap(resultClassIds);
        Map<Long, TwoTuple<String, String>> teacherMap =
            orgTeacherApiService.getNameAndAvatarByUserIds(orgId, courseIdTeacherListMap.values().stream()
                .reduce((longs, longs2) -> ListUtils.union(longs, longs2)).orElse(Lists.newArrayList()));
        Map<Long, String> courseNameMap = orgCourseDao.getCourseNameMap(resultClassIds);
        Map<Long, Integer> lessonCountMap =
            orgClassLessonDao.getLessonCount(orgId, resultClassIds, DeleteStatus.NORMAL.getValue());
        Map<Long, Integer> studentCountMap = orgStudentCourseDao.mapStudentCount(resultClassIds);
        for (Long classId : resultClassIds) {
            ClassBasicDto dto = new ClassBasicDto();
            dto.setClassId(classId);
            dto.setClassName(courseNameMap.get(classId));
            List<CommentUserDto> teachers = Lists.newArrayList();
            for (Long teacherUserId : courseIdTeacherListMap.getOrDefault(classId, Lists.newArrayList())) {
                CommentUserDto teacher = new CommentUserDto();
                TwoTuple<String, String> tuple = teacherMap.getOrDefault(teacherUserId, new TwoTuple<>("", ""));
                teacher.setId(teacherUserId);
                teacher.setName(tuple.getFirst());
                teacher.setAvatarUrl(tuple.getSecond());
                teachers.add(teacher);
            }
            dto.setTeachers(teachers);
            dto.setLessonCount(lessonCountMap.getOrDefault(classId, 0));
            dto.setStudentCount(studentCountMap.getOrDefault(classId, 0));
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<CommentCourseStatisticData> getByParams(Long orgId, Long cascadeId, TimeRange timeRange, Integer order,
        String searchKey, PageDto pageDto) {
        List<CommentCourseStatisticData> result = Lists.newArrayList();
        Set<Long> courseIds = Sets.newHashSet();
        Long orgNumber = orgAccountDao.getById(orgId, "number").getNumber().longValue();
        List<Long> notInCourseIds = orgCourseDao.getDeletedOrFinishedCourseIdsByOrgNumber(orgNumber);
        if (cascadeId > 0) {
            RoleType roleType = RoleType.getRoleType(txCascadeAccountDao.getAccountTypeById(cascadeId));
            if (roleType == RoleType.EMPLOYEE) {
                courseIds.addAll(orgCourseDao.getCourseIdsByCascadeId(cascadeId.intValue(), null,
                    CourseTypeEnum.IS_CLASS_TRUE.getCode(), null));
                OrgTeacher orgTeacher = txCascadeCredentialService.getTeacherByAccount(orgId, cascadeId.intValue());
                if (null != orgTeacher) {
                    courseIds.addAll(
                        orgCourseTeacherDao.getCourseIdsByteacherIds(Lists.newArrayList(orgTeacher.getUserId())));
                }
                courseIds.removeAll(notInCourseIds);
                if (CollectionUtils.isEmpty(courseIds)) {
                    return result;
                }
            }
        }

        
        if (StringUtils.isNotBlank(searchKey)) {
            Set<Long> courseIdsSearch = Sets.newHashSet();
            List<Long> teacherUserIds = orgTeacherDocumentQueryService.quertTeacherUserIds(orgId, searchKey);
            courseIdsSearch.addAll(orgCourseTeacherDao.getCourseIdsByteacherIds(teacherUserIds));
            courseIdsSearch.addAll(orgCourseDao.getCourseIdsByOrgNumberAndCourseName(orgNumber, searchKey,
                null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null));
            courseIdsSearch.removeAll(notInCourseIds);
            if (CollectionUtils.isEmpty(courseIdsSearch)) {
                return Lists.newArrayList();
            } else if (CollectionUtils.isNotEmpty(courseIds)) {
                courseIds = SetUtils.intersection(courseIds, courseIdsSearch);
                if (CollectionUtils.isEmpty(courseIds)) {
                    return result;
                }
            } else {
                courseIds.addAll(courseIdsSearch);
            }
        }

        Date weekEnd = DateUtil.getEndOfWeek(timeRange.getEndTime());
        Date weekStart = DateUtil.getDiffDateTime(weekEnd, -7);
        String weekEndStr = DateUtil.getStrByDate(weekEnd);
        String lastWeekEndStr = DateUtil.getStrByDate(weekStart);
        log.debug("weekEndStr:{} ", weekEndStr);
        List<CourseCommentStatistic> commentStatistics =
            courseCommentStatisticEsQueryer.getCourseCommentStatistic(orgId, courseIds, notInCourseIds, weekEndStr, order, pageDto);

        // 上周数据
        List<Long> selectedCourseIds = commentStatistics.stream()
            .map(courseCommentStatistic -> courseCommentStatistic.getCourseId()).collect(Collectors.toList());
        List<CourseCommentStatistic> lastWeekCommentStatistics = courseCommentStatisticEsQueryer
            .getCourseCommentStatistic(orgId, selectedCourseIds, notInCourseIds, lastWeekEndStr, order, pageDto);
        Map<Long, CourseCommentStatistic> lastWeekCommentStatisticMap = Maps.newHashMap();
        lastWeekCommentStatistics.stream().forEach(courseCommentStatistic -> lastWeekCommentStatisticMap
            .put(courseCommentStatistic.getCourseId(), courseCommentStatistic));
        // 组装数据
        // 老师
        Map<Long, List<Long>> courseIdTeacherListMap = orgCourseTeacherDao.getTeacherMap(selectedCourseIds);
        Map<Long, TwoTuple<String, String>> teacherMap =
            orgTeacherApiService.getNameAndAvatarByUserIds(orgId, courseIdTeacherListMap.values().stream()
                .reduce((longs, longs2) -> ListUtils.union(longs, longs2)).orElse(Lists.newArrayList()));
        // 课程
        Map<Long, String> courseNameMap = orgCourseDao.getCourseNameMap(selectedCourseIds);

        for (CourseCommentStatistic statistic : commentStatistics) {
            CommentCourseStatisticData data = new CommentCourseStatisticData();
            data.setClassId(statistic.getCourseId());
            data.setClassName(courseNameMap.get(statistic.getCourseId()));
            List<CommentUserDto> teachers = Lists.newArrayList();
            for (Long teacherUserId : courseIdTeacherListMap.get(statistic.getCourseId())) {
                CommentUserDto dto = new CommentUserDto();
                TwoTuple<String, String> tuple = teacherMap.get(teacherUserId);
                dto.setId(teacherUserId);
                dto.setName(tuple.getFirst());
                dto.setAvatarUrl(tuple.getSecond());
                teachers.add(dto);
            }
            data.setTeachers(teachers);
            data.setStudentCommentRatio(statistic.getStudentCountSum() > 0
                ? statistic.getStudentCommentCountSum() * 100 / statistic.getStudentCountSum() : 0);
            data.setTeacherCommentRatio(statistic.getStudentCountSum() > 0
                ? statistic.getTeacherCommentCountSum() * 100 / statistic.getStudentCountSum() : 0);
            data.setScore(statistic.getAvgScore());
            CourseCommentStatistic lastWeek = lastWeekCommentStatisticMap.get(statistic.getCourseId());
            if (null != lastWeek) {
                data.setScoreChange(statistic.getAvgScore() - lastWeek.getAvgScore());
            }
            data.setRecentLessonId(orgClassLessonDao.getLatestEndLessonId(orgId, statistic.getCourseId()));
            result.add(data);
        }
        return result;
    }
}
