
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.comment.constant;

import org.apache.commons.lang3.StringUtils;

/**
 * @title OrgScoreDesc
 * @desc TODO
 * @author bjhl
 * @date 2016年1月28日
 * @version 1.0
 */

public enum OrgScoreDesc {
    terrible_bad(1, "口碑极差", 0, 1),

    bad(2, "口碑差", 1, 3),

    common(3, "一般", 3, 4),

    good(4, "口碑好", 4, 5),

    very_good(5, "口碑极好", 5, 6.1),

    ;

    public int getCode() {

        return code;
    }

    public String getMessage() {

        return message;
    }

    public double getLeft() {

        return left;
    }

    public double getRight() {

        return right;
    }

    private int code;

    private String message;

    private double left;

    private double right;

    private OrgScoreDesc(int code, String message, double left, double right) {
        this.code = code;
        this.message = message;
        this.left = left;
        this.right = right;
    }

    public static String getorgDescByScore(Double score) {
        if (score == null) {
            return StringUtils.EMPTY;
        }
        for (OrgScoreDesc desc : OrgScoreDesc.values()) {
            if (score.doubleValue() >= desc.getLeft() && score.doubleValue() < desc.getRight()) {
                return desc.getMessage();
            }
        }
        return StringUtils.EMPTY;
    }
}
