/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.comment.service.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.comment.dao.TxCustomFastCommentDao;
import com.baijia.tianxiao.dal.comment.po.TxCustomFastComment;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.dto.TxCustomFastCommentDto;
import com.baijia.tianxiao.sal.comment.service.TxCustomFastCommentService;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountModuleAuthService;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TxCustomFastCommentServiceImpl
implements TxCustomFastCommentService {
    private static final Logger log = LoggerFactory.getLogger(TxCustomFastCommentServiceImpl.class);
    @Autowired
    private TxCustomFastCommentDao txCustomFastCommentDao;
    @Autowired
    private TxAccountModuleAuthService txAccountModuleAuthService;

    @Override
    public List<TxCustomFastCommentDto> listComments(Long orgId, Integer disable) {
        ArrayList result = Lists.newArrayList();
        if (!this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_COMMENT)) {
            return result;
        }
        List comments = this.txCustomFastCommentDao.getCommentsByOrgId(orgId, disable);
        for (TxCustomFastComment comment : comments) {
            result.add(this.transform(comment));
        }
        return result;
    }

    private TxCustomFastCommentDto transform(TxCustomFastComment comment) {
        TxCustomFastCommentDto dto = new TxCustomFastCommentDto();
        dto.setId(comment.getId());
        dto.setComment(comment.getComment());
        dto.setDisable(comment.getDisable());
        dto.setSort(comment.getSort());
        return dto;
    }

    @Override
    public TxCustomFastCommentDto addComment(Long orgId, String comment) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_COMMENT), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u9879\u6743\u9650");
        BussinessPreconditions.checkArgument((StringUtils.isNotBlank((CharSequence)comment) && comment.length() <= 10 ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc710\u4e2a\u5b57\u7b26");
        BussinessPreconditions.checkArgument((this.txCustomFastCommentDao.countByOrgId(orgId) < 50 ? 1 : 0) != 0, (Object)"\u8bc4\u4ef7\u9879\u4e0d\u80fd\u8d85\u8fc750\u4e2a, \u8bf7\u5220\u9664\u4e00\u4e9b\u8bc4\u4ef7\u9879\u540e\u518d\u6dfb\u52a0");
        BussinessPreconditions.checkArgument((this.txCustomFastCommentDao.getByOrgIdAndComment(orgId, comment) == null ? 1 : 0) != 0, (Object)"\u8be5\u8bc4\u4ef7\u5df2\u7ecf\u5b58\u5728, \u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
        TxCustomFastComment fastComment = new TxCustomFastComment();
        fastComment.setComment(comment);
        fastComment.setOrgId(orgId);
        fastComment.setSort(Integer.valueOf(this.txCustomFastCommentDao.getMaxSortByOrgId(orgId) + 1));
        fastComment.setDisable(Integer.valueOf(Flag.FALSE.getInt()));
        fastComment.setCreateTime(new Date());
        fastComment.setUpdateTime(fastComment.getCreateTime());
        try {
            this.txCustomFastCommentDao.save((Object)fastComment, new String[0]);
        }
        catch (DuplicateKeyException exception) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u8bc4\u4ef7\u5df2\u7ecf\u5b58\u5728, \u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
        }
        return this.transform(fastComment);
    }

    @Override
    public TxCustomFastCommentDto editComment(Long orgId, Long id, String comment, Integer disable) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_COMMENT), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u9879\u6743\u9650");
        TxCustomFastComment fastComment = (TxCustomFastComment)this.txCustomFastCommentDao.getById((Serializable)id, new String[0]);
        BussinessPreconditions.checkArgument((null != fastComment && orgId.longValue() == fastComment.getOrgId().longValue() ? 1 : 0) != 0, (Object)"can not find comment!");
        if (null != comment) {
            BussinessPreconditions.checkArgument((StringUtils.isNotBlank((CharSequence)comment) && comment.length() <= 10 ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc710\u4e2a\u5b57\u7b26");
            BussinessPreconditions.checkArgument((this.txCustomFastCommentDao.getByOrgIdAndComment(orgId, comment) == null ? 1 : 0) != 0, (Object)"\u8be5\u8bc4\u4ef7\u5df2\u7ecf\u5b58\u5728, \u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
            fastComment.setComment(comment);
        }
        if (null != disable) {
            BussinessPreconditions.checkArgument((disable.intValue() == Flag.FALSE.getInt() || disable.intValue() == Flag.TRUE.getInt() ? 1 : 0) != 0, (Object)"disable value error!");
            fastComment.setDisable(disable);
            fastComment.setSort(Integer.valueOf(this.txCustomFastCommentDao.getMaxSortByOrgId(orgId) + 1));
        }
        fastComment.setUpdateTime(new Date());
        try {
            this.txCustomFastCommentDao.update((Object)fastComment, new String[]{"comment", "updateTime", "disable", "sort"});
        }
        catch (DuplicateKeyException e) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u8bc4\u4ef7\u5df2\u7ecf\u5b58\u5728, \u8bf7\u52ff\u91cd\u590d\u521b\u5efa");
        }
        return this.transform(fastComment);
    }

    @Override
    public int deleteByCommentId(Long orgId, Long id) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_COMMENT), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u9879\u6743\u9650");
        TxCustomFastComment fastComment = (TxCustomFastComment)this.txCustomFastCommentDao.getById((Serializable)id, new String[0]);
        BussinessPreconditions.checkArgument((null != fastComment && orgId.longValue() == fastComment.getOrgId().longValue() ? 1 : 0) != 0, (Object)"can not find comment!");
        return this.txCustomFastCommentDao.delById((Serializable)fastComment.getId());
    }

    @Override
    public TwoTuple<TxCustomFastCommentDto, TxCustomFastCommentDto> exchangeSort(Long orgId, Long id1, Long id2) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_COMMENT), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u9879\u6743\u9650");
        BussinessPreconditions.checkArgument((id1.longValue() != id2.longValue() ? 1 : 0) != 0, (Object)"can not be equal");
        TxCustomFastComment a = (TxCustomFastComment)this.txCustomFastCommentDao.getById((Serializable)id1, new String[0]);
        BussinessPreconditions.checkArgument((null != a && orgId.longValue() == a.getOrgId().longValue() ? 1 : 0) != 0, (Object)"can not find comment by id1!");
        TxCustomFastComment b = (TxCustomFastComment)this.txCustomFastCommentDao.getById((Serializable)id2, new String[0]);
        BussinessPreconditions.checkArgument((null != b && orgId.longValue() == b.getOrgId().longValue() ? 1 : 0) != 0, (Object)"can not find comment by id2!");
        Integer sort = a.getSort();
        a.setSort(b.getSort());
        a.setUpdateTime(new Date());
        b.setSort(sort);
        b.setUpdateTime(a.getUpdateTime());
        this.txCustomFastCommentDao.update((Object)a, new String[]{"sort", "updateTime"});
        this.txCustomFastCommentDao.update((Object)b, new String[]{"sort", "updateTime"});
        return new TwoTuple((Object)this.transform(a), (Object)this.transform(b));
    }

    @Override
    public void batchSetSort(Long orgId, Map<Long, Integer> map) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_COMMENT), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bc4\u4ef7\u9879\u6743\u9650");
        if (MapUtils.isEmpty(map)) {
            return;
        }
        BussinessPreconditions.checkArgument((map.size() == Sets.newHashSet(map.values()).size() ? 1 : 0) != 0, (Object)"map contains duplicated values!");
        List list = this.txCustomFastCommentDao.getByIds(map.keySet(), new String[]{"id", "sort"});
        Date updateTime = new Date();
        for (TxCustomFastComment comment : list) {
            Integer sort = map.get(comment.getId());
            BussinessPreconditions.checkArgument((null != sort ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"sort value can not be null!");
            if (sort.intValue() == comment.getSort().intValue()) continue;
            comment.setSort(sort);
            comment.setUpdateTime(updateTime);
            this.txCustomFastCommentDao.update((Object)comment, new String[]{"sort", "updateTime"});
        }
    }
}

