/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.comment.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.comment.dao.OrgCommentAuditDao;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.comment.po.OrgCommentAudit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dto.MultiStatusValue;
import com.baijia.tianxiao.sal.comment.dto.response.AmountTendencyDto;
import com.baijia.tianxiao.sal.comment.dto.response.CommentStatisticData;
import com.baijia.tianxiao.sal.comment.dto.response.ScoreTendencyDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentStatisticService;
import com.baijia.tianxiao.sal.elastic.service.LessonCommentStatisticEsQueryer;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.util.ThreeTuple;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LessonCommentStatisticServiceImpl
implements LessonCommentStatisticService {
    private static final Logger log = LoggerFactory.getLogger(LessonCommentStatisticServiceImpl.class);
    @Autowired
    private OrgCommentAuditDao orgCommentAuditDao;
    @Autowired
    private OrgLessonCommentDao orgLessonCommentDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private LessonCommentStatisticEsQueryer lessonCommentStatisticEsQueryer;

    @Override
    public List<ScoreTendencyDto> scoreTendency(Long orgId, Long txCascadeIdLongZeroFill, Integer type) {
        RoleType roleType;
        Date start;
        int i;
        Date end;
        LinkedList result = Lists.newLinkedList();
        if (type == 0) {
            end = DateUtil.getDiffDateTime((Date)DateUtil.getStartOfDay((Date)new Date()), (int)1);
            for (i = 0; i < 7; ++i) {
                start = DateUtil.getDiffDateTime((Date)end, (int)-1);
                result.addFirst(new ScoreTendencyDto(start, end));
                end = start;
            }
        } else {
            end = DateUtil.getDiffDateTime((Date)DateUtil.getStartOfDay((Date)DateUtil.getEndOfWeek()), (int)1);
            for (i = 0; i < 5; ++i) {
                start = DateUtil.getDiffDateTime((Date)end, (int)-7);
                result.addFirst(new ScoreTendencyDto(start, DateUtil.getDiffMinute((Date)end, (int)-1)));
                end = start;
            }
        }
        HashSet lessonIds = Sets.newHashSet();
        if (txCascadeIdLongZeroFill > 0L && (roleType = RoleType.getRoleType((Integer)this.txCascadeAccountDao.getAccountTypeById(txCascadeIdLongZeroFill))) == RoleType.EMPLOYEE) {
            List classIds = this.orgCourseDao.getCourseIdsByCascadeId(Integer.valueOf(txCascadeIdLongZeroFill.intValue()), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            OrgTeacher orgTeacher = this.txCascadeCredentialService.getTeacherByAccount(orgId, Integer.valueOf(txCascadeIdLongZeroFill.intValue()));
            log.info("statistic find teacher:{} ", (Object)orgTeacher);
            lessonIds.addAll(this.orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, (Collection)classIds, ((ScoreTendencyDto)((Object)result.getFirst())).getStartTime(), ((ScoreTendencyDto)((Object)result.getLast())).getEndTime()));
            if (null != orgTeacher) {
                lessonIds.addAll(this.orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
            }
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                log.info("statistic find no lessonIds. orgID:{}, cascadeId:{}, type:{} ", new Object[]{orgId, txCascadeIdLongZeroFill, type});
                return result;
            }
        }
        for (ScoreTendencyDto dto : result) {
            dto.setScore(this.lessonCommentStatisticEsQueryer.avgScoreTimeRange(orgId, (Collection)lessonIds, (TimeRange)dto));
        }
        return result;
    }

    @Override
    public List<AmountTendencyDto> amountTendency(Long orgId, Long txCascadeIdLongZeroFill, Integer type) {
        RoleType roleType;
        Date start;
        int i;
        Date end;
        LinkedList result = Lists.newLinkedList();
        if (type == 0) {
            end = DateUtil.getDiffDateTime((Date)DateUtil.getStartOfDay((Date)new Date()), (int)1);
            for (i = 0; i < 7; ++i) {
                start = DateUtil.getDiffDateTime((Date)end, (int)-1);
                result.addFirst(new AmountTendencyDto(start, end));
                end = start;
            }
        } else {
            end = DateUtil.getDiffDateTime((Date)DateUtil.getStartOfDay((Date)DateUtil.getEndOfWeek()), (int)1);
            for (i = 0; i < 5; ++i) {
                start = DateUtil.getDiffDateTime((Date)end, (int)-7);
                result.addFirst(new AmountTendencyDto(start, DateUtil.getDiffMinute((Date)end, (int)-1)));
                end = start;
            }
        }
        HashSet lessonIds = Sets.newHashSet();
        if (txCascadeIdLongZeroFill > 0L && (roleType = RoleType.getRoleType((Integer)this.txCascadeAccountDao.getAccountTypeById(txCascadeIdLongZeroFill))) == RoleType.EMPLOYEE) {
            List classIds = this.orgCourseDao.getCourseIdsByCascadeId(Integer.valueOf(txCascadeIdLongZeroFill.intValue()), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            OrgTeacher orgTeacher = this.txCascadeCredentialService.getTeacherByAccount(orgId, Integer.valueOf(txCascadeIdLongZeroFill.intValue()));
            log.info("statistic find teacher:{} ", (Object)orgTeacher);
            lessonIds.addAll(this.orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, (Collection)classIds, ((AmountTendencyDto)((Object)result.getFirst())).getStartTime(), ((AmountTendencyDto)((Object)result.getLast())).getEndTime()));
            if (null != orgTeacher) {
                lessonIds.addAll(this.orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
            }
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                log.info("statistic find no lessonIds. orgID:{}, cascadeId:{}, type:{} ", new Object[]{orgId, txCascadeIdLongZeroFill, type});
                return result;
            }
        }
        for (AmountTendencyDto dto : result) {
            dto.setCount(this.lessonCommentStatisticEsQueryer.commentCountTimeRange(orgId, (Collection)lessonIds, (TimeRange)dto));
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public CommentStatisticData commentStatistic(Long orgId, Long cascadeId, Integer type) {
        RoleType roleType;
        if (cascadeId > 0L && (roleType = RoleType.getRoleType((Integer)this.txCascadeAccountDao.getAccountTypeById(cascadeId))) == RoleType.EMPLOYEE) {
            return this.statisticByCascade(orgId, cascadeId, type);
        }
        return this.statisticByOrg(orgId, type);
    }

    private CommentStatisticData statisticByCascade(Long orgId, Long cascadeId, Integer type) {
        CommentStatisticData result = new CommentStatisticData();
        result.setIsShowComparison(1);
        List classIds = this.orgCourseDao.getCourseIdsByCascadeId(Integer.valueOf(cascadeId.intValue()), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        OrgTeacher orgTeacher = this.txCascadeCredentialService.getTeacherByAccount(orgId, Integer.valueOf(cascadeId.intValue()));
        log.info("statistic find teacher:{} ", (Object)orgTeacher);
        HashSet lessonIds = Sets.newHashSet();
        Date end = DateUtil.getEndOfDay((Date)new Date());
        if (null == type || type.intValue() == Flag.NULL.getInt()) {
            lessonIds.addAll(this.orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, (Collection)classIds, null, end));
            if (null != orgTeacher) {
                lessonIds.addAll(this.orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
            }
        } else {
            Date start = DateUtil.getDiffDateTime((Date)end, (int)-7);
            lessonIds.addAll(this.orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, (Collection)classIds, start, end));
            if (null != orgTeacher) {
                lessonIds.addAll(this.orgTeacherLessonDao.getTeacherLessonIdsByStartTime(start, end, orgTeacher.getUserId()));
            }
        }
        if (CollectionUtils.isEmpty((Collection)lessonIds)) {
            log.info("statistic find no lessonIds. orgID:{}, cascadeId:{}, type:{} ", new Object[]{orgId, cascadeId, type});
            return result;
        }
        log.info("statistic find lessonIds size:{} ", (Object)lessonIds.size());
        TwoTuple studenComment = this.orgLessonCommentDao.getCommentStatistic(orgId, (Collection)lessonIds, Integer.valueOf(UserRole.STUDENT.getRole()));
        result.setScore(new MultiStatusValue((Number)((Long)studenComment.getFirst() > 0L ? (Long)studenComment.getSecond() / (Long)studenComment.getFirst() : 0L), Integer.valueOf(0)));
        Integer studentLessonCount = this.orgStudentLessonDao.countLessonStudent((Collection)lessonIds);
        result.setStudentCommentCount(new MultiStatusValue((Number)studenComment.getFirst(), Integer.valueOf(0)));
        result.setStudentCommentRatio(new MultiStatusValue((Number)(studentLessonCount > 0 ? (Long)studenComment.getFirst() * 100L / (long)studentLessonCount.intValue() : 0L), Integer.valueOf(0)));
        Integer teacherCommentCount = this.orgLessonCommentDao.getCommentCount(orgId, (Collection)lessonIds, Integer.valueOf(UserRole.TEACHER.getRole()), null, null, null, Boolean.valueOf(false));
        result.setTeacherCommentCount(new MultiStatusValue((Number)teacherCommentCount, Integer.valueOf(0)));
        result.setTeacherCommentRatio(new MultiStatusValue((Number)(studentLessonCount > 0 ? teacherCommentCount * 100 / studentLessonCount : 0), Integer.valueOf(0)));
        log.info("statistic result:{} ", (Object)result);
        return result;
    }

    private CommentStatisticData statisticByOrg(Long orgId, Integer type) {
        CommentStatisticData result = new CommentStatisticData();
        result.setIsShowComparison(0);
        OrgCommentAudit audit = this.orgCommentAuditDao.getCommentAuditByOrgId(orgId, new String[0]);
        if (null == type || type.intValue() == Flag.NULL.getInt()) {
            if (null != audit) {
                result.setScore(new MultiStatusValue((Number)audit.getScore(), Integer.valueOf(0)));
                Integer studenCommentCount = this.orgLessonCommentDao.getCommentCount(orgId, null, Integer.valueOf(UserRole.STUDENT.getRole()), null, null, null, Boolean.valueOf(false));
                Integer studentLessonCount = this.orgStudentLessonDao.getFinishLessonStudentCount(orgId);
                log.debug("studentLessonCount:{} ", (Object)studentLessonCount);
                result.setStudentCommentCount(new MultiStatusValue((Number)studenCommentCount, Integer.valueOf(0)));
                result.setStudentCommentRatio(new MultiStatusValue((Number)(studentLessonCount > 0 ? studenCommentCount * 100 / studentLessonCount : 0), Integer.valueOf(0)));
                Integer teacherCommentCount = this.orgLessonCommentDao.getCommentCount(orgId, null, Integer.valueOf(UserRole.TEACHER.getRole()), null, null, null, Boolean.valueOf(false));
                result.setTeacherCommentCount(new MultiStatusValue((Number)teacherCommentCount, Integer.valueOf(0)));
                result.setTeacherCommentRatio(new MultiStatusValue((Number)(studentLessonCount > 0 ? teacherCommentCount * 100 / studentLessonCount : 0), Integer.valueOf(0)));
                ThreeTuple score = this.orgCommentAuditDao.getAvgScoreByAreaId(audit.getAreaId());
                Integer compare = 0;
                Integer status = 0;
                if (audit.getScore() == 0) {
                    status = -1;
                } else if (audit.getScore() > (Integer)score.getSecond()) {
                    Integer diff = (Integer)score.getThree() - (Integer)score.getSecond();
                    compare = diff != 0 ? (audit.getScore() - (Integer)score.getSecond()) * 100 / diff : 0;
                } else if (audit.getScore() < (Integer)score.getSecond()) {
                    Integer diff = (Integer)score.getSecond() - (Integer)score.getFirst();
                    compare = diff != 0 ? (audit.getScore() - (Integer)score.getSecond()) * 100 / diff : 0;
                }
                result.setComparison(new MultiStatusValue((Number)compare, status));
            }
        } else if (null != audit) {
            Date end = DateUtil.getEndOfDay((Date)new Date());
            Date start = DateUtil.getDiffDateTime((Date)end, (int)-7);
            List lessonIds = this.orgClassLessonDao.queryLessonByStartTime(orgId, start, end, null);
            result.setScore(new MultiStatusValue((Number)audit.getRecentScore(), Integer.valueOf(0)));
            Integer studenCommentCount = this.orgLessonCommentDao.getCommentCount(orgId, (Collection)lessonIds, Integer.valueOf(UserRole.STUDENT.getRole()), null, null, null, Boolean.valueOf(false));
            Integer studentLessonCount = this.orgStudentLessonDao.countLessonStudent((Collection)lessonIds);
            result.setStudentCommentCount(new MultiStatusValue((Number)studenCommentCount, Integer.valueOf(0)));
            result.setStudentCommentRatio(new MultiStatusValue((Number)(studentLessonCount > 0 ? studenCommentCount * 100 / studentLessonCount : 0), Integer.valueOf(0)));
            Integer teacherCommentCount = this.orgLessonCommentDao.getCommentCount(orgId, (Collection)lessonIds, Integer.valueOf(UserRole.TEACHER.getRole()), null, null, null, Boolean.valueOf(false));
            result.setTeacherCommentCount(new MultiStatusValue((Number)teacherCommentCount, Integer.valueOf(0)));
            result.setTeacherCommentRatio(new MultiStatusValue((Number)(studentLessonCount > 0 ? teacherCommentCount * 100 / studentLessonCount : 0), Integer.valueOf(0)));
            ThreeTuple score = this.orgCommentAuditDao.getAvgRecentScoreByAreaId(audit.getAreaId());
            log.debug("score:{}", (Object)score);
            log.debug("audit:{}", (Object)audit);
            Integer compare = 0;
            Integer status = 0;
            if (audit.getRecentScore() == 0) {
                status = -1;
            } else if (audit.getRecentScore() > (Integer)score.getSecond()) {
                Integer diff = (Integer)score.getThree() - (Integer)score.getSecond();
                compare = diff != 0 ? (audit.getRecentScore() - (Integer)score.getSecond()) * 100 / diff : 0;
            } else if (audit.getRecentScore() < (Integer)score.getSecond()) {
                Integer diff = (Integer)score.getSecond() - (Integer)score.getFirst();
                compare = diff != 0 ? (audit.getRecentScore() - (Integer)score.getSecond()) * 100 / diff : 0;
            }
            result.setComparison(new MultiStatusValue((Number)compare, status));
        }
        return result;
    }
}

