/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.comment.service.impl;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dto.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.sal.comment.dto.ClassBasicDto;
import com.baijia.tianxiao.sal.comment.dto.LessonBasicDto;
import com.baijia.tianxiao.sal.comment.dto.response.CommentCourseStatisticData;
import com.baijia.tianxiao.sal.comment.dto.response.CommentUserDto;
import com.baijia.tianxiao.sal.comment.service.CourseCommentStatisticService;
import com.baijia.tianxiao.sal.common.api.OrgTeacherApiService;
import com.baijia.tianxiao.sal.elastic.dto.CourseCommentStatistic;
import com.baijia.tianxiao.sal.elastic.service.CourseCommentStatisticEsQueryer;
import com.baijia.tianxiao.sal.elastic.service.OrgTeacherDocumentQueryService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.TwoTuple;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CourseCommentStatisticServiceImpl
implements CourseCommentStatisticService {
    private static final Logger log = LoggerFactory.getLogger(CourseCommentStatisticServiceImpl.class);
    @Autowired
    private CourseCommentStatisticEsQueryer courseCommentStatisticEsQueryer;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTeacherDocumentQueryService orgTeacherDocumentQueryService;
    @Autowired
    private OrgTeacherApiService orgTeacherApiService;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Override
    public List<LessonBasicDto> listUncommentedLessonsByClass(Long orgId, Long cascadeId, Long classId) {
        RoleType roleType;
        ArrayList result = Lists.newArrayList();
        HashSet lessonIds = Sets.newHashSet();
        if (cascadeId > 0L && (roleType = RoleType.getRoleType((Integer)this.txCascadeAccountDao.getAccountTypeById(cascadeId))) == RoleType.EMPLOYEE) {
            List classIds = this.orgCourseDao.getCourseIdsByCascadeId(Integer.valueOf(cascadeId.intValue()), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            OrgTeacher orgTeacher = this.txCascadeCredentialService.getTeacherByAccount(orgId, Integer.valueOf(cascadeId.intValue()));
            log.info("statistic find teacher:{} ", (Object)orgTeacher);
            lessonIds.addAll(this.orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, (Collection)classIds, null, null));
            if (null != orgTeacher) {
                lessonIds.addAll(this.orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
            }
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return result;
            }
        }
        List lessons = this.orgClassLessonDao.getUncommentedLessons(orgId, (Collection)lessonIds, (Collection)Lists.newArrayList((Object[])new Long[]{classId}));
        for (OrgClassLesson lesson : lessons) {
            LessonBasicDto dto = new LessonBasicDto();
            dto.setClassId(lesson.getCourseId());
            dto.setLessonId(lesson.getId());
            dto.setIndex(lesson.getNumber());
            dto.setStartTime(lesson.getStartTime());
            dto.setEndTime(lesson.getEndTime());
            dto.setLeftCount(lesson.getStudentCount() - lesson.getTeacherCommentCount());
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<ClassBasicDto> listUncommentedClasses(Long orgId, Long cascadeId, String searchKey, PageDto pageDto) {
        RoleType roleType;
        HashSet lessonIds = Sets.newHashSet();
        HashSet classIds = Sets.newHashSet();
        HashSet notInClassIds = Sets.newHashSet();
        ArrayList result = Lists.newArrayList();
        Long orgNumber = ((OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"})).getNumber().longValue();
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            List teacherUserIds = this.orgTeacherDocumentQueryService.quertTeacherUserIds(orgId, searchKey);
            classIds.addAll(this.orgCourseTeacherDao.getCourseIdsByteacherIds((Collection)teacherUserIds));
            classIds.addAll(this.orgCourseDao.getCourseIdsByOrgNumberAndCourseName(Long.valueOf(orgNumber), searchKey, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null));
            if (CollectionUtils.isEmpty((Collection)classIds)) {
                return Lists.newArrayList();
            }
        }
        if (cascadeId > 0L && (roleType = RoleType.getRoleType((Integer)this.txCascadeAccountDao.getAccountTypeById(cascadeId))) == RoleType.EMPLOYEE) {
            List classIdsCascade = this.orgCourseDao.getCourseIdsByCascadeId(Integer.valueOf(cascadeId.intValue()), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            lessonIds.addAll(this.orgClassLessonDao.getLessonIdsByClassIdsAndTime(orgId, (Collection)classIdsCascade, null, null));
            OrgTeacher orgTeacher = this.txCascadeCredentialService.getTeacherByAccount(orgId, Integer.valueOf(cascadeId.intValue()));
            log.info("statistic find teacher:{} ", (Object)orgTeacher);
            if (null != orgTeacher) {
                lessonIds.addAll(this.orgTeacherLessonDao.listLessonIdByTeacher(orgId, orgTeacher.getUserId()));
            }
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return result;
            }
        }
        notInClassIds.addAll(this.orgCourseDao.getDeletedOrFinishedCourseIdsByOrgNumber(orgNumber));
        List resultClassIds = this.orgClassLessonDao.groupCourseIdByParams(orgId, (Collection)lessonIds, (Collection)notInClassIds, (Collection)classIds, null, new Date(), pageDto);
        log.info("resultClassIds:{} ", (Object)resultClassIds);
        Map courseIdTeacherListMap = this.orgCourseTeacherDao.getTeacherMap((Collection)resultClassIds);
        Map teacherMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, (Collection)courseIdTeacherListMap.values().stream().reduce((longs, longs2) -> ListUtils.union((List)longs, (List)longs2)).orElse(Lists.newArrayList()));
        Map courseNameMap = this.orgCourseDao.getCourseNameMap((Collection)resultClassIds);
        Map lessonCountMap = this.orgClassLessonDao.getLessonCount(orgId, (Collection)resultClassIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map studentCountMap = this.orgStudentCourseDao.mapStudentCount((Collection)resultClassIds);
        for (Long classId : resultClassIds) {
            ClassBasicDto dto = new ClassBasicDto();
            dto.setClassId(classId);
            dto.setClassName((String)courseNameMap.get(classId));
            ArrayList teachers = Lists.newArrayList();
            for (Long teacherUserId : (List)courseIdTeacherListMap.getOrDefault(classId, Lists.newArrayList())) {
                CommentUserDto teacher = new CommentUserDto();
                TwoTuple tuple = teacherMap.getOrDefault(teacherUserId, new TwoTuple((Object)"", (Object)""));
                teacher.setId(teacherUserId);
                teacher.setName((String)tuple.getFirst());
                teacher.setAvatarUrl((String)tuple.getSecond());
                teachers.add(teacher);
            }
            dto.setTeachers(teachers);
            dto.setLessonCount(lessonCountMap.getOrDefault(classId, 0));
            dto.setStudentCount(studentCountMap.getOrDefault(classId, 0));
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<CommentCourseStatisticData> getByParams(Long orgId, Long cascadeId, TimeRange timeRange, Integer order, String searchKey, PageDto pageDto) {
        RoleType roleType;
        ArrayList result = Lists.newArrayList();
        HashSet courseIds = Sets.newHashSet();
        Long orgNumber = ((OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"})).getNumber().longValue();
        List notInCourseIds = this.orgCourseDao.getDeletedOrFinishedCourseIdsByOrgNumber(orgNumber);
        if (cascadeId > 0L && (roleType = RoleType.getRoleType((Integer)this.txCascadeAccountDao.getAccountTypeById(cascadeId))) == RoleType.EMPLOYEE) {
            courseIds.addAll(this.orgCourseDao.getCourseIdsByCascadeId(Integer.valueOf(cascadeId.intValue()), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null));
            OrgTeacher orgTeacher = this.txCascadeCredentialService.getTeacherByAccount(orgId, Integer.valueOf(cascadeId.intValue()));
            if (null != orgTeacher) {
                courseIds.addAll(this.orgCourseTeacherDao.getCourseIdsByteacherIds((Collection)Lists.newArrayList((Object[])new Long[]{orgTeacher.getUserId()})));
            }
            courseIds.removeAll(notInCourseIds);
            if (CollectionUtils.isEmpty((Collection)courseIds)) {
                return result;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            HashSet courseIdsSearch = Sets.newHashSet();
            List teacherUserIds = this.orgTeacherDocumentQueryService.quertTeacherUserIds(orgId, searchKey);
            courseIdsSearch.addAll(this.orgCourseTeacherDao.getCourseIdsByteacherIds((Collection)teacherUserIds));
            courseIdsSearch.addAll(this.orgCourseDao.getCourseIdsByOrgNumberAndCourseName(orgNumber, searchKey, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null));
            courseIdsSearch.removeAll(notInCourseIds);
            if (CollectionUtils.isEmpty((Collection)courseIdsSearch)) {
                return Lists.newArrayList();
            }
            if (CollectionUtils.isNotEmpty((Collection)courseIds)) {
                if (CollectionUtils.isEmpty((Collection)(courseIds = SetUtils.intersection((Set)courseIds, (Set)courseIdsSearch)))) {
                    return result;
                }
            } else {
                courseIds.addAll(courseIdsSearch);
            }
        }
        Date weekEnd = DateUtil.getEndOfWeek((Date)timeRange.getEndTime());
        Date weekStart = DateUtil.getDiffDateTime((Date)weekEnd, (int)-7);
        String weekEndStr = DateUtil.getStrByDate((Date)weekEnd);
        String lastWeekEndStr = DateUtil.getStrByDate((Date)weekStart);
        log.debug("weekEndStr:{} ", (Object)weekEndStr);
        List commentStatistics = this.courseCommentStatisticEsQueryer.getCourseCommentStatistic(orgId, (Collection)courseIds, (Collection)notInCourseIds, weekEndStr, order, pageDto);
        List selectedCourseIds = commentStatistics.stream().map(courseCommentStatistic -> courseCommentStatistic.getCourseId()).collect(Collectors.toList());
        List lastWeekCommentStatistics = this.courseCommentStatisticEsQueryer.getCourseCommentStatistic(orgId, selectedCourseIds, (Collection)notInCourseIds, lastWeekEndStr, order, pageDto);
        HashMap lastWeekCommentStatisticMap = Maps.newHashMap();
        lastWeekCommentStatistics.stream().forEach(courseCommentStatistic -> lastWeekCommentStatisticMap.put(courseCommentStatistic.getCourseId(), courseCommentStatistic));
        Map courseIdTeacherListMap = this.orgCourseTeacherDao.getTeacherMap(selectedCourseIds);
        Map teacherMap = this.orgTeacherApiService.getNameAndAvatarByUserIds(orgId, (Collection)courseIdTeacherListMap.values().stream().reduce((longs, longs2) -> ListUtils.union((List)longs, (List)longs2)).orElse(Lists.newArrayList()));
        Map courseNameMap = this.orgCourseDao.getCourseNameMap(selectedCourseIds);
        for (CourseCommentStatistic statistic : commentStatistics) {
            CommentCourseStatisticData data = new CommentCourseStatisticData();
            data.setClassId(statistic.getCourseId());
            data.setClassName((String)courseNameMap.get(statistic.getCourseId()));
            ArrayList teachers = Lists.newArrayList();
            for (Long teacherUserId : (List)courseIdTeacherListMap.getOrDefault(statistic.getCourseId(), Lists.newArrayList())) {
                CommentUserDto dto = new CommentUserDto();
                TwoTuple tuple = (TwoTuple)teacherMap.get(teacherUserId);
                dto.setId(teacherUserId);
                dto.setName((String)tuple.getFirst());
                dto.setAvatarUrl((String)tuple.getSecond());
                teachers.add(dto);
            }
            data.setTeachers(teachers);
            data.setStudentCommentRatio(statistic.getStudentCountSum() > 0L ? statistic.getStudentCommentCountSum() * 100L / statistic.getStudentCountSum() : 0L);
            data.setTeacherCommentRatio(statistic.getStudentCountSum() > 0L ? statistic.getTeacherCommentCountSum() * 100L / statistic.getStudentCountSum() : 0L);
            data.setScore(statistic.getAvgScore());
            CourseCommentStatistic lastWeek = (CourseCommentStatistic)lastWeekCommentStatisticMap.get(statistic.getCourseId());
            if (null != lastWeek) {
                data.setScoreChange(statistic.getAvgScore() - lastWeek.getAvgScore());
            }
            data.setRecentLessonId(this.orgClassLessonDao.getLatestEndLessonId(orgId, statistic.getCourseId()));
            result.add(data);
        }
        return result;
    }
}

