/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.comment.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.comment.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.comment.po.OrgLessonComment;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.comment.constant.CommentReqType;
import com.baijia.tianxiao.sal.comment.dto.AddCommentReponse;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.dto.request.CommentAddRequestDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.AfterCourseCommentNotifyMsg;
import com.baijia.tianxiao.sal.common.utils.WechatTemplateMsgHelper;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LessonCommentServiceImpl
implements LessonCommentService {
    private static final Logger log = LoggerFactory.getLogger(LessonCommentServiceImpl.class);
    private static String content = "%s,\u4f60\u597d\uff1a%s\u70b9\u8bc4\u4e86\u4f60\u5728%s%s\u7684\u8868\u73b0\uff0c\u5feb\u53bb\u770b\u770b\u5427\u3002";
    private static String url = "\u5730\u5740\uff1a%s";
    private static String defaultName = "-";
    private static String remark = "\u70b9\u51fb\u67e5\u770b\u5b8c\u6574\u7684\u8bc4\u8bed\u5185\u5bb9";
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStorageDao orgStorageDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private Environment environment;
    @Autowired(required=false)
    private CommonMsgService commonMsgService;
    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;
    @Autowired
    private OrgAccountDao orgAccountDao;

    private boolean checkOrgPermissionEvaluateMsg(Long orgId) {
        if (orgId == null) {
            return false;
        }
        TXSaleClueRule tXSaleClueRule = this.tXSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        return tXSaleClueRule != null && tXSaleClueRule.getEvaluateMsg() == 0;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentInfoDto> getLessonComments(Long lessonId, Long orgId, Integer userRole) {
        List comments = null;
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            log.info("get lesson student comments, lessonId={}, orgId={}", (Object)lessonId, (Object)orgId);
            comments = this.orgLessonCommentDao.getLessonStudentComments(lessonId, Boolean.valueOf(false), new String[0]);
        } else {
            log.info("get lesson teacher comments, lessonId={}, orgId={}", (Object)lessonId, (Object)orgId);
            comments = this.orgLessonCommentDao.getLessonTeacherComments(lessonId, Boolean.valueOf(false), new String[0]);
        }
        ArrayList responseDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)comments)) {
            Map<Integer, String> urlMap = this.getUrlMap(comments);
            for (OrgLessonComment comment : comments) {
                CommentInfoDto dto = this.buildCommentInfoDto(comment, urlMap);
                responseDtos.add(dto);
            }
        }
        return responseDtos;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentInfoDto> getStudentComments(Integer userRole, Long userId, Long orgId, Collection<Long> lessonIds, PageDto pageDto) {
        List comments = null;
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            log.info("get student comments,  userId={},orgId={}", (Object)orgId);
            comments = this.orgLessonCommentDao.getStudentComments(orgId, userId, userRole, Boolean.valueOf(true), Boolean.valueOf(false), lessonIds, pageDto, new String[0]);
        } else {
            log.info("get teacher comments of student, userId={}, orgId={}", (Object)userId, (Object)orgId);
            comments = this.orgLessonCommentDao.getStudentComments(orgId, userId, userRole, Boolean.valueOf(false), Boolean.valueOf(false), lessonIds, pageDto, new String[0]);
        }
        return this.buildCommentInfoDtos(comments);
    }

    private List<CommentInfoDto> buildCommentInfoDtos(List<OrgLessonComment> comments) {
        ArrayList responseDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(comments)) {
            Map<Integer, String> urlMap = this.getUrlMap(comments);
            for (OrgLessonComment comment : comments) {
                CommentInfoDto dto = this.buildCommentInfoDto(comment, urlMap);
                responseDtos.add(dto);
            }
        }
        return responseDtos;
    }

    @Override
    @Transactional
    public void updateComment(Long orgId, Long commentId, Long fromId, Integer userRole, Integer starScore, String content, String storageIds, String customFastComment, String shareUrl, Integer soundId, Integer soundLength) {
        if (StringUtils.isNotBlank((CharSequence)content) && content.length() > 2000) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.CONTENT_TOO_LONG);
        }
        OrgLessonComment orgLessonComment = (OrgLessonComment)this.orgLessonCommentDao.getById((Serializable)commentId, new String[0]);
        BussinessPreconditions.checkArgument((null != orgLessonComment ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8bc4\u4ef7");
        BussinessPreconditions.checkArgument((orgLessonComment.getOrgId().longValue() == orgId.longValue() ? 1 : 0) != 0, (Object)"\u627e\u4e0d\u5230\u8bc4\u4ef7");
        BussinessPreconditions.checkArgument((orgLessonComment.getFromId().longValue() == fromId.longValue() ? 1 : 0) != 0, (Object)"\u8bc4\u4ef7\u4e0d\u5c5e\u4e8e\u60a8");
        BussinessPreconditions.checkArgument((orgLessonComment.getUserRole().intValue() == userRole.intValue() ? 1 : 0) != 0, (Object)"\u8bc4\u4ef7\u4e0d\u5c5e\u4e8e\u60a8");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)orgLessonComment.getLessonId(), new String[0]);
        if (lesson.getStartTime().after(new Date())) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_NOT_END);
        }
        orgLessonComment.setContent(content);
        orgLessonComment.setScore(starScore);
        orgLessonComment.setStarScore(starScore);
        if (StringUtils.isNotBlank((CharSequence)storageIds)) {
            orgLessonComment.setStorageIds(storageIds);
        }
        if (StringUtils.isNotBlank((CharSequence)customFastComment)) {
            orgLessonComment.setCustomFastComment(customFastComment);
        }
        orgLessonComment.setSoundId(soundId);
        orgLessonComment.setSoundLength(soundLength);
        orgLessonComment.setUpdateTime(new Date());
        this.orgLessonCommentDao.update((Object)orgLessonComment, new String[]{"content", "customFastComment", "score", "storageIds", "starScore", "updateTime", "soundId", "soundLength"});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public AddCommentReponse addComment(CommentAddRequestDto dto, Long orgId, String studentCommentDetailUrl) {
        OrgStudent student;
        Preconditions.checkArgument((dto.getScore() != null ? 1 : 0) != 0, (Object)"score is not null!");
        if (StringUtils.isNotBlank((CharSequence)dto.getContent()) && dto.getContent().length() > 2000) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.CONTENT_TOO_LONG);
        }
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)dto.getLessonId(), new String[0]);
        if (lesson.getStartTime().after(new Date())) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_NOT_END);
        }
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[0]);
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lesson.getId());
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        Teacher teacher = null;
        if (teacherLesson != null) {
            teacher = this.teacherDao.getByUserId(teacherLesson.getTeacherId(), new String[0]);
        }
        OrgLessonComment orgLessonComment = new OrgLessonComment();
        orgLessonComment.setLessonId(dto.getLessonId());
        orgLessonComment.setCourseId(lesson.getCourseId());
        orgLessonComment.setUserRole(dto.getUserRole());
        orgLessonComment.setContent(dto.getContent());
        orgLessonComment.setCustomFastComment(dto.getCustomFastComment());
        orgLessonComment.setOrgId(orgId);
        orgLessonComment.setStorageIds(dto.getStorageIds());
        orgLessonComment.setSoundId(dto.getSoundId());
        orgLessonComment.setSoundLength(dto.getSoundLength());
        orgLessonComment.setCreateTime(new Date());
        orgLessonComment.setUpdateTime(orgLessonComment.getCreateTime());
        if (null == dto.getStarScore()) {
            orgLessonComment.setScore(Integer.valueOf((int)(dto.getScore() * 100.0)));
            orgLessonComment.setStarScore(orgLessonComment.getStarScore());
        } else {
            orgLessonComment.setScore(dto.getStarScore());
            orgLessonComment.setStarScore(dto.getStarScore());
        }
        if (dto.getUserRole().intValue() == UserRole.STUDENT.getRole()) {
            student = (OrgStudent)this.orgStudentDao.getById((Serializable)dto.getFromId(), new String[0]);
            orgLessonComment.setFromId(student.getUserId());
            orgLessonComment.setToId(dto.getToId());
            if (!this.check(student.getUserId(), UserRole.STUDENT.getRole(), dto.getLessonId()).booleanValue() || !this.check(dto.getToId(), UserRole.TEACHER.getRole(), dto.getLessonId()).booleanValue()) {
                throw new BussinessException((UniverseErrorCode)CommentErrorCode.NOT_IN_LESSON);
            }
            OrgLessonComment oldCommont = this.orgLessonCommentDao.getLessonCommentDetail(dto.getLessonId(), student.getUserId(), Integer.valueOf(UserRole.STUDENT.getRole()), null, new String[0]);
            if (oldCommont != null) {
                if (!oldCommont.getIsSystem().booleanValue()) {
                    throw new BussinessException((UniverseErrorCode)CommentErrorCode.COMMENT_REPEAT);
                }
                this.orgLessonCommentDao.delById((Serializable)oldCommont.getId());
            }
        } else {
            if (dto.getUserRole().intValue() != UserRole.TEACHER.getRole()) {
                throw new BussinessException((UniverseErrorCode)CommentErrorCode.USER_ROLE_ERRER);
            }
            student = (OrgStudent)this.orgStudentDao.getById((Serializable)dto.getToId(), new String[0]);
            orgLessonComment.setFromId(dto.getFromId());
            orgLessonComment.setToId(student.getUserId());
            if (!this.check(student.getUserId(), UserRole.STUDENT.getRole(), dto.getLessonId()).booleanValue() || !this.check(dto.getFromId(), UserRole.TEACHER.getRole(), dto.getLessonId()).booleanValue()) {
                throw new BussinessException((UniverseErrorCode)CommentErrorCode.NOT_IN_LESSON);
            }
            if (this.orgLessonCommentDao.getLessonCommentByFromAndTo(dto.getLessonId(), dto.getFromId(), student.getUserId(), Integer.valueOf(UserRole.TEACHER.getRole()), Boolean.valueOf(false), new String[0]) != null) {
                throw new BussinessException((UniverseErrorCode)CommentErrorCode.COMMENT_REPEAT);
            }
            try {
                if (this.checkOrgPermissionEvaluateMsg(orgId)) {
                    OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
                    String url = this.getStudentCommentDetailUrl(student.getId(), orgAccount.getNumber().longValue(), lesson.getId(), studentCommentDetailUrl);
                    String teacherName = teacher == null ? null : teacher.getRealName();
                    String smsContent = SmsContentHelper.createCommentNotifySmsMsg((String)teacherName, (long)lesson.getStartTime().getTime(), (String)orgInfo.getShortName(), (String)url);
                    AfterCourseCommentNotifyMsg msg = AfterCourseCommentNotifyMsg.newInstance((String)student.getName(), (String)teacherName, (String)course.getName(), (long)lesson.getStartTime().getTime(), (String)url);
                    SendMsgRequest createSendMsgRequestToStu = WechatTemplateMsgHelper.createSendMsgRequestToStu((Long)orgId, (String)student.getMobile(), (Long)student.getId(), (String)student.getWeixin(), (String)smsContent, (WechateTemplateMsgType)WechateTemplateMsgType.TEACHER_EVALUATION_TO_STU, (WechatMsgTypeSuper)msg);
                    createSendMsgRequestToStu.setSmsCodeType(TxSmsCodeType.COMMENT_NOTIFY);
                    this.commonMsgService.sendMsg(createSendMsgRequestToStu);
                }
            }
            catch (Exception e) {
                log.error("error={}", (Throwable)e);
            }
        }
        try {
            this.orgLessonCommentDao.save((Object)orgLessonComment, new String[0]);
        }
        catch (Exception e) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.COMMENT_REPEAT);
        }
        AddCommentReponse response = new AddCommentReponse();
        response.setCommentId(orgLessonComment.getId());
        return response;
    }

    private SendMsgRequest getStudentCommentDetail(String teacherName, OrgClassLesson lesson, OrgCourse course, OrgInfo orgInfo, OrgStudent student, String studentCommentDetailUrl) {
        SendMsgRequest request = new SendMsgRequest();
        request.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setMobile(student.getMobile());
        request.setCountSms(false);
        request.setReceiverId(student.getId());
        request.setReceiverRole(UserRoleEnum.STUDENT);
        request.setSenderId(Long.valueOf(orgInfo.getOrgId().longValue()));
        request.setSenderRole(UserRoleEnum.ORG);
        request.setWechatTemplateId(Integer.valueOf(WechateTemplateMsgType.TEACHER_EVALUATION_TO_STU.getValue()));
        request.setWeixinOpenId(student.getWeixin());
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgInfo.getOrgId(), new String[0]);
        String url = this.getStudentCommentDetailUrl(student.getId(), orgAccount.getNumber().longValue(), lesson.getId(), studentCommentDetailUrl);
        AfterCourseCommentNotifyMsg msg = AfterCourseCommentNotifyMsg.newInstance((String)student.getName(), (String)teacherName, (String)course.getName(), (long)lesson.getStartTime().getTime(), (String)url);
        Map createAfterCourseNotifyWechatMsg = WechatTemplateMsgHelper.createAfterCourseNotifyWechatMsg((AfterCourseCommentNotifyMsg)msg);
        request.setWechatParams(createAfterCourseNotifyWechatMsg);
        request.setSmsContent(SmsContentHelper.createCommentNotifySmsMsg((String)teacherName, (long)lesson.getStartTime().getTime(), (String)orgInfo.getShortName(), (String)url));
        return request;
    }

    private String getStringValue(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return defaultName;
        }
        return message;
    }

    private String getStudentCommentDetailUrl(Long studentId, Long orgNumber, Long lessonId, String studentCommentDetailUrl) {
        try {
            String detailUrl = String.format(studentCommentDetailUrl, orgNumber, lessonId, studentId);
            return ShortUrlUtil.getShortUrl((String)detailUrl);
        }
        catch (Exception e) {
            log.warn("get lesson student comment error", (Throwable)e);
            return null;
        }
    }

    private Boolean check(Long userId, Integer userRole, Long lessonId) {
        if (userRole.intValue() == UserRole.STUDENT.getRole()) {
            return this.orgStudentLessonDao.isStudentInlesson(lessonId, userId);
        }
        return this.orgTeacherLessonDao.isTeacherInLesson(lessonId, userId);
    }

    private Map<Integer, String> getUrlMap(List<OrgLessonComment> comments) {
        HashSet storageIds = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(comments)) {
            for (OrgLessonComment comment : comments) {
                String[] storageArr;
                if (!StringUtils.isNotBlank((CharSequence)comment.getStorageIds())) continue;
                for (String str : storageArr = StringUtils.split((String)comment.getStorageIds(), (String)",")) {
                    Integer storageId = Integer.parseInt(str);
                    storageIds.add(storageId);
                }
            }
        }
        return this.getUrlMap(storageIds);
    }

    private Map<Integer, String> getUrlMap(Set<Integer> storageIds) {
        if (CollectionUtils.isNotEmpty(storageIds)) {
            List storages = this.orgStorageDao.getByIds(storageIds, new String[0]);
            return CollectorUtil.collectMap((Collection)storages, (Function)new Function<OrgStorage, Integer>(){

                public Integer apply(OrgStorage arg0) {
                    return arg0.getId();
                }
            }, (Function)new Function<OrgStorage, String>(){

                public String apply(OrgStorage arg0) {
                    return StorageUtil.constructUrl((String)arg0.getFid(), (String)arg0.getSn(), (Integer)arg0.getMimeType());
                }
            });
        }
        return Maps.newHashMap();
    }

    private CommentInfoDto buildCommentInfoDto(OrgLessonComment comment, Map<Integer, String> urlMap) {
        CommentInfoDto dto = new CommentInfoDto();
        dto.setCommentId(comment.getId());
        dto.setContent(comment.getContent());
        dto.setCustomFastComment(comment.getCustomFastComment());
        dto.setScore(ArithUtil.round((double)((double)comment.getScore().intValue() / 100.0), (int)1));
        dto.setStarScore(comment.getStarScore());
        dto.setLessonId(comment.getLessonId());
        dto.setCourseId(comment.getCourseId());
        if (StringUtils.isNotBlank((CharSequence)comment.getStorageIds())) {
            String[] storageArr = StringUtils.split((String)comment.getStorageIds(), (String)",");
            ArrayList urlList = Lists.newArrayList();
            for (String str : storageArr) {
                String url;
                Integer storageId = Integer.parseInt(str);
                if (storageId == null || (url = urlMap.get(storageId)) == null) continue;
                urlList.add(url);
            }
            if (CollectionUtils.isNotEmpty((Collection)urlList)) {
                dto.setUrls(StringUtils.join((Object[])urlList.toArray(), (String)","));
            }
        }
        dto.setSoundLength(comment.getSoundLength());
        if (null != comment.getSoundId() && comment.getSoundId() > 0) {
            OrgStorage orgStorage = this.orgStorageDao.getById(comment.getSoundId().intValue());
            dto.setSoundLink(StorageUtil.constructUrl((String)orgStorage.getFid(), (String)orgStorage.getSn(), (Integer)orgStorage.getMimeType()));
        }
        dto.setStorageIds(comment.getStorageIds());
        dto.setUserRole(comment.getUserRole());
        dto.setFromId(comment.getFromId());
        dto.setToId(comment.getToId());
        dto.setCreateTime(comment.getCreateTime());
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public CommentInfoDto getCommentDetail(Long commentId, Long orgId, Integer userRole) {
        OrgLessonComment comment = (OrgLessonComment)this.orgLessonCommentDao.getById((Serializable)commentId, new String[0]);
        if (comment == null || comment.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.COMMENT_NOT_EXSIST);
        }
        Map<Integer, String> urlMap = this.getUrlMap(Lists.newArrayList((Object[])new OrgLessonComment[]{comment}));
        return this.buildCommentInfoDto(comment, urlMap);
    }

    @Override
    @Transactional(readOnly=true)
    public CommentInfoDto getCommentDetail(Long lessonId, Long userId, Long orgId, Integer userRole) {
        OrgLessonComment comment = this.orgLessonCommentDao.getLessonCommentDetail(lessonId, userId, userRole, null, new String[0]);
        log.debug("comment = {}", (Object)comment);
        if (comment == null || comment.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.COMMENT_NOT_EXSIST);
        }
        Map<Integer, String> urlMap = this.getUrlMap(Lists.newArrayList((Object[])new OrgLessonComment[]{comment}));
        OrgClassLesson orgClassLesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Preconditions.checkArgument((orgClassLesson != null ? 1 : 0) != 0, (Object)"lesson not exist!");
        CommentInfoDto dto = this.buildCommentInfoDto(comment, urlMap);
        dto.setStartTime(orgClassLesson.getStartTime());
        dto.setEndTime(orgClassLesson.getEndTime());
        dto.setIndex(orgClassLesson.getNumber());
        OrgCourse course = this.orgCourseDao.getByCourseId(orgClassLesson.getCourseId(), new String[]{"name"});
        if (course != null) {
            dto.setCourseName(course.getName());
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentInfoDto> getLessonCommentsWithLessonInfo(@NonNull Long orgId, @NonNull Long studentId, @NonNull Integer userRole, PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        if (userRole == null) {
            throw new NullPointerException("userRole");
        }
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exits!");
        List orgLessonIds = this.orgClassLessonDao.getOrgLessonIds(orgId);
        List<CommentInfoDto> commentInfoDtoList = this.getStudentComments(userRole, userId, orgId, orgLessonIds, pageDto);
        log.debug("commentInfoDtoList = {}", commentInfoDtoList);
        this.getAndSetCourseAndLesson(orgId, commentInfoDtoList);
        return commentInfoDtoList;
    }

    private void getAndSetCourseAndLesson(Long orgId, List<CommentInfoDto> commentInfoDtoList) {
        ArrayList courseIds = Lists.newArrayList();
        ArrayList lessonIds = Lists.newArrayList();
        for (CommentInfoDto commentInfoDto : commentInfoDtoList) {
            courseIds.add(commentInfoDto.getCourseId());
            lessonIds.add(commentInfoDto.getLessonId());
        }
        log.debug("courseIds = {}", (Object)courseIds);
        log.debug("lessonIds = {}", (Object)lessonIds);
        Map userLessonMap = this.orgClassLessonDao.getClassLessonMap(orgId, (Collection)lessonIds, Integer.valueOf(0), new String[0]);
        Map courseIdCourseMap = this.orgCourseDao.getOrgCourseMap((Collection)courseIds, new String[0]);
        log.debug("userLessonMap = {}", (Object)userLessonMap);
        log.debug("courseIdCourseMap = {}", (Object)courseIdCourseMap);
        for (CommentInfoDto commentInfoDto : commentInfoDtoList) {
            OrgClassLesson lesson = (OrgClassLesson)userLessonMap.get(commentInfoDto.getLessonId());
            OrgCourse course = (OrgCourse)courseIdCourseMap.get(commentInfoDto.getCourseId());
            if (lesson != null) {
                commentInfoDto.setIndex(lesson.getNumber());
                commentInfoDto.setStartTime(lesson.getStartTime());
                commentInfoDto.setEndTime(lesson.getEndTime());
            }
            if (course == null) continue;
            commentInfoDto.setCourseName(course.getName());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Long, Boolean> getStudentLessonCommentMap(Long userId, Collection<Long> lessonIds) {
        List list = this.orgLessonCommentDao.getCommentLessonIdsOfStudent(userId);
        log.debug("list = {}", (Object)list);
        HashSet set = new HashSet(list);
        HashMap map = Maps.newHashMap();
        for (Long lessonId : lessonIds) {
            if (set.contains(lessonId)) {
                map.put(lessonId, true);
                continue;
            }
            map.put(lessonId, false);
        }
        log.debug("lessonIds = {}", lessonIds);
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public CommentInfoDto getCommentDetail(Long commentId, Long orgId) {
        Preconditions.checkArgument((commentId != null ? 1 : 0) != 0, (Object)"commentId is null!");
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        OrgLessonComment comment = (OrgLessonComment)this.orgLessonCommentDao.getById((Serializable)commentId, new String[0]);
        if (comment == null || comment.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.COMMENT_NOT_EXSIST);
        }
        Map<Integer, String> urlMap = this.getUrlMap(Lists.newArrayList((Object[])new OrgLessonComment[]{comment}));
        return this.buildCommentInfoDto(comment, urlMap);
    }

    @Override
    public void addLessonDefaultComment() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.LESSON_STUDENT_DEFAULT_COMMENT.getSyncType());
        log.debug("syncInfo={}", (Object)syncInfo);
        Date beginTime = null;
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.LESSON_STUDENT_DEFAULT_COMMENT.getSyncType()));
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
        } else {
            beginTime = syncInfo.getSyncTime();
        }
        Date endTime = DateUtil.getDayDiff((int)-7);
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(200));
        List lessons = this.orgClassLessonDao.querylessonsByEndTime(beginTime, endTime, Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto);
        log.debug("query lessons beginTIme={},endTime={} lessons.size={}", new Object[]{beginTime, endTime, lessons.size()});
        Map lessonMap = CollectorUtil.collectMap((Collection)lessons, (Function)new Function<OrgClassLesson, Long>(){

            public Long apply(OrgClassLesson arg0) {
                return arg0.getId();
            }
        });
        for (int count = 0; CollectionUtils.isNotEmpty((Collection)lessons) && count < 10; ++count) {
            log.debug("pageDto={},next sync time ={},lessons ={}", new Object[]{pageDto, ((OrgClassLesson)lessons.get(0)).getEndTime(), lessonMap.keySet()});
            syncInfo.setSyncTime(((OrgClassLesson)lessons.get(0)).getEndTime());
            Map lessonTeacherMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(null, lessonMap.keySet());
            this.addDefaultComment(lessonMap.keySet(), lessonMap, lessonTeacherMap);
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            lessons = this.orgClassLessonDao.querylessonsByEndTime(beginTime, endTime, Integer.valueOf(DeleteStatus.NORMAL.getValue()), pageDto);
            lessonMap = CollectorUtil.collectMap((Collection)lessons, (Function)new Function<OrgClassLesson, Long>(){

                public Long apply(OrgClassLesson arg0) {
                    return arg0.getId();
                }
            });
        }
    }

    private void addDefaultComment(Collection<Long> lessonIds, Map<Long, OrgClassLesson> lessonMap, Map<Long, Long> lessonTeacherMap) {
        Map lessonStudentMap = this.orgStudentLessonDao.getLessonStudentList(lessonIds);
        Map lessonStudentCommentMap = this.orgLessonCommentDao.getLessonCommentStudentMap(lessonIds, null, Integer.valueOf(UserRole.STUDENT.getRole()));
        Map lessonTeacherCommentMap = this.orgLessonCommentDao.getLessonCommentStudentMap(lessonIds, null, Integer.valueOf(UserRole.TEACHER.getRole()));
        log.debug("lessonStudentCommentMap={}", (Object)lessonStudentCommentMap);
        log.debug("lessonTeacherCommentMap={}", (Object)lessonTeacherCommentMap);
        ArrayList addComments = Lists.newArrayList();
        for (Map.Entry entry : lessonStudentMap.entrySet()) {
            OrgLessonComment comment;
            Long lessonId = (Long)entry.getKey();
            OrgClassLesson lesson = lessonMap.get(lessonId);
            if (lesson == null) continue;
            List studentIds = (List)entry.getValue();
            ArrayList teacherStudentIds = Lists.newArrayList();
            teacherStudentIds.addAll(studentIds);
            if (!CollectionUtils.isNotEmpty((Collection)studentIds)) continue;
            List hasStudentCommentIds = (List)lessonStudentCommentMap.get(lessonId);
            List hasTeacherCommentIds = (List)lessonTeacherCommentMap.get(lessonId);
            if (hasStudentCommentIds != null && CollectionUtils.isNotEmpty((Collection)hasStudentCommentIds)) {
                studentIds.removeAll(hasStudentCommentIds);
            }
            if (hasTeacherCommentIds != null && CollectionUtils.isNotEmpty((Collection)hasTeacherCommentIds)) {
                teacherStudentIds.removeAll(hasTeacherCommentIds);
            }
            for (Long userId : studentIds) {
                comment = new OrgLessonComment();
                comment.setOrgId(lesson.getOrgId());
                comment.setCourseId(lesson.getCourseId());
                comment.setLessonId(lessonId);
                comment.setFromId(userId);
                comment.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
                if (lessonTeacherMap.get(lessonId) == null) continue;
                comment.setToId(lessonTeacherMap.get(lessonId));
                comment.setContent("");
                comment.setCustomFastComment("");
                comment.setScore(Integer.valueOf(500));
                comment.setStarScore(Integer.valueOf(500));
                comment.setIsSystem(Boolean.valueOf(true));
                comment.setCreateTime(new Date());
                comment.setUpdateTime(comment.getCreateTime());
                addComments.add(comment);
            }
            for (Long userId : teacherStudentIds) {
                comment = new OrgLessonComment();
                comment.setOrgId(lesson.getOrgId());
                comment.setCourseId(lesson.getCourseId());
                comment.setLessonId(lessonId);
                comment.setFromId(lessonTeacherMap.get(lessonId));
                comment.setUserRole(Integer.valueOf(UserRole.TEACHER.getRole()));
                if (lessonTeacherMap.get(lessonId) == null) continue;
                comment.setToId(userId);
                comment.setContent("");
                comment.setCustomFastComment("");
                comment.setScore(Integer.valueOf(500));
                comment.setStarScore(Integer.valueOf(500));
                comment.setIsSystem(Boolean.valueOf(true));
                comment.setCreateTime(new Date());
                comment.setUpdateTime(comment.getCreateTime());
                addComments.add(comment);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)addComments)) {
            this.orgLessonCommentDao.saveAll((List)addComments, new String[]{"orgId", "courseId", "lessonId", "fromId", "userRole", "toId", "content", "score", "isSystem", "updateTime", "createTime"});
        }
    }

    @Override
    public List<CommentInfoDto> queryComments(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds, Integer commentReqType, Boolean isSystem, Integer userRole, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        log.info("get comments of students with param: courseIds={},teacherIds={},commentReqType={}, isSystem={},pageDto={}", new Object[]{courseIds, teacherIds, commentReqType, isSystem, pageDto});
        List lessonIds = null;
        Integer lowScore = commentReqType != null && commentReqType.intValue() == CommentReqType.LOW_SCORE.getCode() ? Integer.valueOf(300) : null;
        Integer highScore = commentReqType != null && commentReqType.intValue() == CommentReqType.HIGN_SCORE.getCode() ? Integer.valueOf(500) : null;
        Boolean hasPic = commentReqType != null && commentReqType.intValue() == CommentReqType.WITH_PIC.getCode() ? Boolean.valueOf(true) : null;
        log.info("low_score={},hasPic={},hign_score={}", new Object[]{lowScore, hasPic, highScore});
        if (CollectionUtils.isNotEmpty(teacherIds) || CollectionUtils.isNotEmpty(courseIds)) {
            lessonIds = this.orgClassLessonDao.filterLessonList(orgId, courseIds, teacherIds);
        }
        List comments = this.orgLessonCommentDao.getComments(orgId, (Collection)lessonIds, userRole, lowScore, hasPic, highScore, pageDto, isSystem, new String[0]);
        List<CommentInfoDto> dtos = this.buildCommentInfoDtos(comments);
        this.getAndSetCourseAndLesson(orgId, dtos);
        log.info("get comments result={}", (Object)dtos.size());
        return dtos;
    }

    @Override
    public List<CommentInfoDto> getComments(@NonNull Long orgId, @NonNull Long lessonId, List<Long> fromIds, List<Long> toIds, @NonNull Integer userRole) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (userRole == null) {
            throw new NullPointerException("userRole");
        }
        List comments = this.orgLessonCommentDao.getComments(orgId, lessonId, fromIds, toIds, userRole);
        List<CommentInfoDto> dtos = this.buildCommentInfoDtos(comments);
        this.getAndSetCourseAndLesson(orgId, dtos);
        return dtos;
    }

    @Override
    public CommentInfoDto getComment(@NonNull Long orgId, @NonNull Long commentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (commentId == null) {
            throw new NullPointerException("commentId");
        }
        OrgLessonComment comment = this.orgLessonCommentDao.getByIdAndOrgId(commentId, orgId);
        if (null != comment) {
            List<CommentInfoDto> dtos = this.buildCommentInfoDtos(Lists.newArrayList((Object[])new OrgLessonComment[]{comment}));
            this.getAndSetCourseAndLesson(orgId, dtos);
            if (CollectionUtils.isNotEmpty(dtos)) {
                return dtos.get(0);
            }
        }
        return null;
    }
}

