
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.comment.service;

import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.OrgCommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.OrgStudentCommentAuditDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.List;

/**
 * @title LessonCommentAudiService
 * @desc TODO
 * @author bjhl
 * @date 2016年1月3日
 * @version 1.0
 */

public interface LessonCommentAudiService {

    /**
     * 获取课节评价统计
     * 
     * @param lessonId
     * @param orgId
     * @return
     */
    public CommentAuditDto getLessonCommentAudit(Long lessonId, Long orgId);

    /**
     * 获取老师评价统计
     * 
     * @param teacherId
     * @param orgId
     * @return
     */
    public CommentAuditDto getTeacherCommentAudit(Long teacherId, Long orgId);

    /**
     * 获取老师评级统计列表
     * 
     * @param orgId
     * @param page
     * @return
     */
    public List<CommentAuditDto> getTeacherAuditList(Long orgId, Collection<Long> teacherIds, Integer userRole,
        Boolean isSystem);

    /**
     * 获取老师课程评价统计
     * 
     * @param teacherId
     * @param orgId
     * @return
     */
    public List<CommentAuditDto> getTeacherCourseCommentAudit(Long teacherId, Long orgId, Boolean isSystem,
        Integer userRole, PageDto pageDto);

    /**
     * 获取机构评价统计
     * 
     * @param orgId
     * @param withSystem 是否计算默认评价
     * @return
     */
    OrgCommentAuditDto getOrgCommentAudit(Long orgId, Boolean withSystem);

    /**
     * 学员评价数统计
     * 
     * @param courseIds 班级
     * @param courseIds 班级
     * @param teacherIds 老师
     * @param isSystem
     * @param isSystem
     * @return
     */
    OrgStudentCommentAuditDto getOrgCommentAudit(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds,
        Boolean isSystem, Integer userRole);

    /**
     * 同步更新机构评价统计
     */
    void syncUpdateOrgCommentAudit();

}
