package com.baijia.tianxiao.sal.comment.dto.request;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * Created by wengshengli on 2017/9/12.
 */
@Data
public class CommentListRequest extends BaseDto {

    private Integer cascadeId;//员工账号

    private Long currentCascadeTeacherUserId = -1l;//当前老师userid

    private String searchKey;

    /**
     * 评价来源类型：-1-所有，0-来自老师，2-来自学生
     */
    private Integer sourceType = -1;

    /**
     * -1 所有
     */
    private Long teacherId = -1l;

    /**
     * 时间类型：-1-所有，0-近7天，1-近30天，2-本月，3-上月
     */
    private Integer timeType = -1;

    /**
     * 评分类型：-1-所有，1-好评，2-中评，3-差评
     */
    private Integer scoreType = -1;

    /**
     * 分页, 上次列表最小id，首页id=-1
     */
    private Long lastId = -1l;

    /**
     * 分页条数
     */
    private Integer PageSize = 20;


    public static Date getBeginTimeByType(int timeType) {
        Date beginTime = null;
        switch (timeType) {
            case -1:
                beginTime = null;
                break;
            case 0:
                beginTime = DateUtil.getStartOfDay(DateUtil.getDiffDateTime(new Date(), -6));
                break;
            case 1:
                beginTime = DateUtil.getStartOfDay(DateUtil.getDiffDateTime(new Date(), -29));
                break;
            case 2:
                beginTime = DateUtil.getStartOfMonth();
                break;
            case 3:
                beginTime = DateUtil.getLastMonthFirstDate(new Date());
                break;
        }
        return beginTime;
    }

    /**
     * 结束时间都是取的第二天的0点  查询是用<号
     *
     * @param timeType
     * @return
     */
    public static Date getEndTimeByType(int timeType) {
        Date endTime = null;
        switch (timeType) {
            case -1:
                endTime = null;
                break;
            case 0:
                endTime = DateUtil.getStartOfDay(DateUtil.getDiffDateTime(new Date(), 1));
                break;
            case 1:
                endTime = DateUtil.getStartOfDay(DateUtil.getDiffDateTime(new Date(), 1));
                break;
            case 2:
                endTime = DateUtil.getNextMonthFirstDate(new Date());
                break;
            case 3:
                endTime = DateUtil.getStartOfMonth();
                break;
        }
        return endTime;
    }
}
