
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.comment.constant;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * @title CourseErrorCode
 * @desc TODO
 * @author bjhl
 * @date 2015年12月26日
 * @version 1.0
 */

public enum CommentErrorCode implements UniverseErrorCode {

    UNKNOW(1, "未知类型错误"),

    COURSE_NOT_EXIST(2001, "课程不存在"),

    USER_ROLE_ERRER(2002, "角色错误"),

    COMMENT_NOT_EXSIST(2003, "评价不存在"),

    NOT_IN_LESSON(2004, "学员或者老师不属于该课节"),

    LESSON_NOT_END(2005, "课节未结束暂时不能评价"),

    COMMENT_TIME_OUT(2006, "评价有效期结束，不能再评价"),

    COMMENT_REPEAT(2007, "不能重复评价"),

    CONTENT_TOO_LONG(2008, "评价内容过长"),

    COMMENT_RANK_NULL(2009, "您的机构暂未获得学生评价"),

    LESSON_WITH_COMMENT(2010, "课节已被评价，不能删除"),

    LESSON_WITH_SIGN(2011, "课节已有签到，不能删除"),

    ;
    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private CommentErrorCode(int code, String msg) {
        this.errorSide = ErrorSide.SERVER;
        this.subsystem = Subsystem.STUDENT;
        this.platform = Platform.PC;
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public CommentErrorCode fromCode(int code) {
        for (CommentErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CommentErrorCode.UNKNOW;
    }

}
