/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.comment.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCommentAuditDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.org.po.CommentAudit;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCommentAudit;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.OrgCommentAuditDto;
import com.baijia.tianxiao.sal.comment.dto.OrgStudentCommentAuditDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentAudiService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ArithUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LessonCommentAudiServiceImpl
implements LessonCommentAudiService {
    private static final Logger log = LoggerFactory.getLogger(LessonCommentAudiServiceImpl.class);
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentLessonDao OrgStudentLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgCommentAuditDao orgCommentAuditDao;
    @Resource
    private AreaDao areaDao;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Override
    public CommentAuditDto getLessonCommentAudit(Long lessonId, Long orgId) {
        log.info("audit lesson commet");
        CommentAudit commentAudit = this.orgLessonCommentDao.getLessonCommentAudit(lessonId, orgId, Boolean.valueOf(false));
        Integer studentCount = this.OrgStudentLessonDao.queryLessonStudentCount(orgId, lessonId);
        return this.buildCommentInfoDto(commentAudit, studentCount, lessonId);
    }

    private CommentAuditDto buildCommentInfoDto(CommentAudit commentAudit, Integer studentCount, Long id) {
        CommentAuditDto dto = new CommentAuditDto();
        dto.setId(id);
        if (commentAudit != null && studentCount != null && studentCount > 0 && commentAudit.getNum() > 0) {
            dto.setCount(commentAudit.getNum());
            if (dto.getCount() > 0) {
                if (commentAudit.getTotalScore() == null) {
                    dto.setScore(0.0);
                } else {
                    dto.setScore(ArithUtil.round((double)((double)commentAudit.getTotalScore().intValue() / (double)(commentAudit.getNum() * 100)), (int)1));
                }
                dto.setRate((double)commentAudit.getNum().intValue() / (double)studentCount.intValue());
            } else {
                dto.setScore(0.0);
                dto.setRate(0.0);
            }
        } else {
            dto.setCount(0);
            dto.setRate(0.0);
            dto.setScore(0.0);
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public CommentAuditDto getTeacherCommentAudit(Long teacherId, Long orgId) {
        Date now = new Date();
        log.info("audit teacher comment, teacherId={}, orgId={}, page={}", (Object)teacherId, (Object)orgId);
        List lessonIds = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherId);
        List courseIds = this.orgCourseTeacherDao.getTeacherCourseIds(teacherId, null);
        lessonIds = this.orgClassLessonDao.filterLessonListByTime((Collection)courseIds, (Collection)lessonIds, now);
        Integer studentCount = this.OrgStudentLessonDao.queryLessonStudentCount(orgId, (Collection)lessonIds);
        CommentAudit commentAudit = this.orgLessonCommentDao.getCommentAudit((Collection)lessonIds, orgId, Boolean.valueOf(false));
        log.debug("teacher comment, commentAudit={}", (Object)commentAudit);
        return this.buildCommentInfoDto(commentAudit, studentCount, teacherId);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentAuditDto> getTeacherCourseCommentAudit(Long teacherId, Long orgId, Boolean isSystem, Integer userRole, PageDto pageDto) {
        log.info("audit teacher course comment, teacherId={}, orgId={}, page={}", new Object[]{teacherId, orgId, pageDto});
        List responseDto = Lists.newArrayList();
        List courseIds = this.orgCourseTeacherDao.getTeacherCourseIds(teacherId, pageDto);
        List lessonIds = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherId);
        lessonIds = this.orgClassLessonDao.filterLessonListByTime((Collection)courseIds, (Collection)lessonIds, new Date());
        log.debug("courseIds={},lessonIds={}", (Object)courseIds, (Object)lessonIds);
        if (CollectionUtils.isNotEmpty((Collection)lessonIds)) {
            List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)courseIds, null, (Collection)lessonIds, null, null, null, new String[0]);
            List commentAudits = this.orgLessonCommentDao.getLessonsCommentAudit((Collection)lessonIds, orgId, userRole, isSystem);
            log.debug("audit teacher course, commentAudits={}", (Object)commentAudits);
            Map<Long, CommentAudit> commentMap = this.getCommentMap(commentAudits);
            Map studentCountMap = this.OrgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map<Long, List<OrgClassLesson>> courseLessonMap = this.getCourseLessonMap(lessons);
            Map courseNameMap = this.orgCourseDao.getCourseNameMap(courseLessonMap.keySet());
            log.debug("studentCountMap={}", (Object)studentCountMap);
            log.debug("courseLessonMap={}", courseLessonMap);
            log.debug("courseNameMap={}", (Object)courseNameMap);
            for (Long courseId : courseLessonMap.keySet()) {
                CommentAuditDto dto = new CommentAuditDto();
                dto.setId(courseId);
                dto.setName((String)courseNameMap.get(courseId));
                dto.setTimeoutCount(0);
                dto.setWaitCount(0);
                dto.setCount(0);
                Integer studentCount = this.getStudentCount(studentCountMap, courseId, courseLessonMap);
                if (studentCount != null && studentCount > 0) {
                    this.getCommentCountAndScore(commentMap, courseId, courseLessonMap, dto, studentCountMap);
                    dto.setRate((double)dto.getCount().intValue() / (double)studentCount.intValue());
                } else {
                    dto.setCount(0);
                    dto.setRate(0.0);
                    dto.setScore(0.0);
                }
                responseDto.add(dto);
            }
        }
        return responseDto;
    }

    private void getCommentCountAndScore(Map<Long, CommentAudit> commentMap, Long courseId, Map<Long, List<OrgClassLesson>> courseLessonMap, CommentAuditDto dto, Map<Long, Integer> studentCountMap) {
        Integer score = 0;
        Integer count = 0;
        Date time = DateUtil.getDayDiff((int)-7);
        List<OrgClassLesson> lessons = courseLessonMap.get(courseId);
        if (CollectionUtils.isNotEmpty(lessons)) {
            for (OrgClassLesson lesson : lessons) {
                CommentAudit commentAudit = commentMap.get(lesson.getId());
                if (commentAudit == null) continue;
                count = count + commentAudit.getNum();
                int studentCount = 0;
                if (studentCountMap.get(lesson.getId()) != null) {
                    studentCount = studentCountMap.get(lesson.getId());
                }
                if (commentAudit.getTotalScore() != null) {
                    score = score + commentAudit.getTotalScore();
                }
                if (studentCount <= 0 || studentCount < commentAudit.getNum()) continue;
                if (lesson.getEndTime().before(time)) {
                    dto.setWaitCount(dto.getWaitCount() + studentCount - commentAudit.getNum());
                    continue;
                }
                dto.setTimeoutCount(dto.getTimeoutCount() + studentCount - commentAudit.getNum());
            }
        }
        dto.setCount(count);
        if (count > 0) {
            dto.setScore(ArithUtil.round((double)(score.doubleValue() / (double)(count * 100)), (int)1));
        } else {
            dto.setScore(0.0);
        }
    }

    private Integer getStudentCount(Map<Long, Integer> studentCountMap, Long courseId, Map<Long, List<OrgClassLesson>> courseLessonMap) {
        Integer count = 0;
        List<OrgClassLesson> lessons = courseLessonMap.get(courseId);
        if (CollectionUtils.isNotEmpty(lessons)) {
            for (OrgClassLesson lesson : lessons) {
                Integer countValue = studentCountMap.get(lesson.getId());
                if (countValue == null) continue;
                count = count + countValue;
            }
        }
        return count;
    }

    private Map<Long, CommentAudit> getCommentMap(List<CommentAudit> commentAudits) {
        return CollectorUtil.collectMap(commentAudits, (Function)new Function<CommentAudit, Long>(){

            public Long apply(CommentAudit arg0) {
                return arg0.getLessonId();
            }
        });
    }

    private Map<Long, List<OrgClassLesson>> getCourseLessonMap(List<OrgClassLesson> lessons) {
        return CollectorUtil.group(lessons, (Function)new Function<OrgClassLesson, Long>(){

            public Long apply(OrgClassLesson arg0) {
                return arg0.getCourseId();
            }
        });
    }

    @Override
    @Transactional(readOnly=true)
    public List<CommentAuditDto> getTeacherAuditList(Long orgId, Collection<Long> teacherIds, Integer userRole, Boolean isSystem) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Lists.newArrayList();
        }
        log.debug("orgId={}, teacherIds={}", (Object)orgId, teacherIds);
        List result = Lists.newArrayList();
        Date endTime = DateUtil.getDayDiff((int)-7);
        Map commentCountMap = this.orgLessonCommentDao.getTeacherCommentCountMap(orgId, teacherIds, userRole, endTime, isSystem);
        Map studentCountMap = this.OrgStudentLessonDao.getStudentCountOfTeacher(orgId, teacherIds, endTime);
        log.debug("commentCountMap={}", (Object)commentCountMap);
        log.debug("studentCountMap={}", (Object)studentCountMap);
        Map commentCountMapAll = this.orgLessonCommentDao.getTeacherCommentCountMap(orgId, teacherIds, userRole, null, isSystem);
        Map studentCountMapAll = this.OrgStudentLessonDao.getStudentCountOfTeacher(orgId, teacherIds, null);
        log.debug("commentCountMapAll={}", (Object)commentCountMapAll);
        log.debug("studentCountMapAll={}", (Object)studentCountMapAll);
        for (Long teacherId : teacherIds) {
            CommentAuditDto dto = new CommentAuditDto();
            dto.setId(teacherId);
            int commentCount = commentCountMapAll.get(teacherId) == null ? 0 : ((CommentAudit)commentCountMapAll.get(teacherId)).getNum();
            int studentCount = studentCountMapAll.get(teacherId) == null ? 0 : (Integer)studentCountMapAll.get(teacherId);
            int totalScore = commentCountMapAll.get(teacherId) == null ? 0 : ((CommentAudit)commentCountMapAll.get(teacherId)).getTotalScore();
            int commentTimeIn = commentCountMap.get(teacherId) == null ? 0 : ((CommentAudit)commentCountMap.get(teacherId)).getNum();
            int studentTimeIn = studentCountMap.get(teacherId) == null ? 0 : (Integer)studentCountMap.get(teacherId);
            dto.setId(teacherId);
            if (studentCount <= 0) continue;
            dto.setCount(commentCount);
            if (commentCount > 0) {
                dto.setScore(ArithUtil.round((double)((double)totalScore / (double)(commentCount * 100)), (int)1));
            }
            dto.setWaitCount(studentTimeIn - commentTimeIn);
            dto.setTimeoutCount(studentCount - commentCount - dto.getWaitCount());
            dto.setRate((double)commentCount / (double)studentCount);
            result.add(dto);
        }
        return result;
    }

    @Override
    public OrgCommentAuditDto getOrgCommentAudit(Long orgId, Boolean withSystem) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        OrgCommentAuditDto dto = new OrgCommentAuditDto();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        Area area = (Area)this.areaDao.getById((Serializable)orgInfo.getAreaId(), new String[0]);
        dto.setAreaName(area.getName());
        Map commentCountMap = this.orgLessonCommentDao.getCommentCountOfOrg(orgId, withSystem, null);
        Map lowScoreMap = this.orgLessonCommentDao.getCommentCountOfOrg(orgId, withSystem, Integer.valueOf(300));
        Map commentCountMapWithOutDefault = this.orgLessonCommentDao.getCommentCountOfOrg(orgId, Boolean.valueOf(false), null);
        Map lowScoreMapWithOutDefault = this.orgLessonCommentDao.getCommentCountOfOrg(orgId, Boolean.valueOf(false), Integer.valueOf(300));
        log.debug("commentCountMap={},lowScoreMap={}", (Object)commentCountMap, (Object)lowScoreMap);
        log.debug("commentCountMapWithOutDefault={},lowScoreMapWithOutDefault={}", (Object)commentCountMapWithOutDefault, (Object)lowScoreMapWithOutDefault);
        dto.setStudentCommentCount(commentCountMap.get(UserRole.STUDENT.getRole()) == null ? 0 : (Integer)commentCountMap.get(UserRole.STUDENT.getRole()));
        dto.setTeacherCommentCount(commentCountMap.get(UserRole.TEACHER.getRole()) == null ? 0 : (Integer)commentCountMap.get(UserRole.TEACHER.getRole()));
        Integer studentCount = this.OrgStudentLessonDao.getFinishLessonStudentCount(orgId);
        log.debug("studentCount={}", (Object)studentCount);
        if (studentCount > 0) {
            int studentCommentCount = commentCountMapWithOutDefault.get(UserRole.STUDENT.getRole()) == null ? 0 : (Integer)commentCountMapWithOutDefault.get(UserRole.STUDENT.getRole());
            int teacherCommentCount = commentCountMapWithOutDefault.get(UserRole.TEACHER.getRole()) == null ? 0 : (Integer)commentCountMapWithOutDefault.get(UserRole.TEACHER.getRole());
            int lowScoreStudentCount = lowScoreMapWithOutDefault.get(UserRole.STUDENT.getRole()) == null ? 0 : (Integer)lowScoreMapWithOutDefault.get(UserRole.STUDENT.getRole());
            dto.setStudentCommentRate(ArithUtil.round((double)((double)studentCommentCount / (double)studentCount.intValue()), (int)3));
            if (studentCommentCount > 0) {
                dto.setStudentLowRate(ArithUtil.round((double)((double)lowScoreStudentCount / (double)studentCommentCount), (int)3));
            } else {
                dto.setStudentLowRate(0.0);
            }
            dto.setTeacherCommentRate(ArithUtil.round((double)((double)teacherCommentCount / (double)studentCount.intValue()), (int)3));
            OrgCommentAudit audit = this.orgCommentAuditDao.getCommentAuditByOrgId(orgId, new String[0]);
            log.debug("audit={}", (Object)audit);
            if (audit != null) {
                dto.setDate(DateUtil.getStrByDate((Date)DateUtil.getDiffDateTime((Date)audit.getUpdateTime(), (int)-1)));
                if (withSystem != null && !withSystem.booleanValue() && audit.getCommentCount() > 0) {
                    Integer rank = this.orgCommentAuditDao.getRank(orgId, withSystem);
                    dto.setOrgScore(ArithUtil.round((double)((double)audit.getScore().intValue() / 100.0), (int)2));
                    dto.setRank(rank);
                } else if (withSystem == null && audit.getCommentCountAll() > 0) {
                    Integer rank = this.orgCommentAuditDao.getRank(orgId, Boolean.valueOf(true));
                    dto.setOrgScore(ArithUtil.round((double)((double)audit.getScoreAll().intValue() / 100.0), (int)2));
                    dto.setRank(rank);
                }
            }
        } else {
            dto.setStudentCommentRate(0.0);
            dto.setStudentLowRate(0.0);
            dto.setTeacherCommentRate(0.0);
        }
        if (dto.getRank() == null) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.COMMENT_RANK_NULL);
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncUpdateOrgCommentAudit() {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.COMMENT_AUDIT.getSyncType());
        List addAudits = Lists.newArrayList();
        List updateAudits = Lists.newArrayList();
        Date startTime = null;
        Date endTime = DateUtil.getCurrentDate();
        List newCommentAuditList = null;
        List newCommentAuditListAll = null;
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(Integer.valueOf(MsgSyncType.COMMENT_AUDIT.getSyncType()));
            syncInfo.setSyncTime(endTime);
            this.txMsgSyncTimestampDao.save((Object)syncInfo, Boolean.valueOf(false), new String[0]);
            newCommentAuditList = this.orgLessonCommentDao.getOrgCommentAudit(null, endTime, Boolean.valueOf(false));
            newCommentAuditListAll = this.orgLessonCommentDao.getOrgCommentAudit(null, endTime, null);
        } else {
            startTime = syncInfo.getSyncTime();
            syncInfo.setSyncTime(endTime);
            this.txMsgSyncTimestampDao.update((Object)syncInfo, new String[]{"syncTime"});
            newCommentAuditList = this.orgLessonCommentDao.getOrgCommentAudit(startTime, endTime, Boolean.valueOf(false));
            newCommentAuditListAll = this.orgLessonCommentDao.getOrgCommentAudit(startTime, endTime, null);
        }
        log.info("new commentAudit={}, startTime={},endTime={}", new Object[]{newCommentAuditList, startTime, endTime});
        log.info("new newCommentAuditListAll={}, startTime={},endTime={}", new Object[]{newCommentAuditListAll, startTime, endTime});
        Map newCommentAuditMap = CollectorUtil.collectMap((Collection)newCommentAuditList, (Function)new Function<OrgCommentAudit, Long>(){

            public Long apply(OrgCommentAudit arg0) {
                return arg0.getOrgId();
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)newCommentAuditListAll)) {
            HashSet orgIdInts = Sets.newHashSet();
            HashSet orgIds = Sets.newHashSet();
            for (OrgCommentAudit audit : newCommentAuditListAll) {
                orgIds.add(audit.getOrgId());
                orgIdInts.add(audit.getOrgId().intValue());
            }
            Map areaIdMap = this.orgInfoDao.getAreaMap((Collection)orgIdInts);
            Map auditMap = this.orgCommentAuditDao.getCommentAuditMapByOrgIds((Collection)orgIds, new String[0]);
            for (OrgCommentAudit audit : newCommentAuditListAll) {
                if (auditMap.get(audit.getOrgId()) != null) {
                    OrgCommentAudit updateAudit = (OrgCommentAudit)auditMap.get(audit.getOrgId());
                    updateAudit.setCommentCountAll(Integer.valueOf(updateAudit.getCommentCountAll() + audit.getCommentCountAll()));
                    updateAudit.setTotalScoreAll(Integer.valueOf(updateAudit.getTotalScoreAll() + audit.getTotalScoreAll()));
                    if (updateAudit.getCommentCountAll() > 0) {
                        updateAudit.setScoreAll(Integer.valueOf(updateAudit.getTotalScoreAll() / updateAudit.getCommentCountAll()));
                    } else {
                        updateAudit.setScoreAll(Integer.valueOf(0));
                    }
                    OrgCommentAudit auditWithoutSystem = (OrgCommentAudit)newCommentAuditMap.get(audit.getOrgId());
                    if (auditWithoutSystem != null) {
                        updateAudit.setCommentCount(Integer.valueOf(updateAudit.getCommentCount() + auditWithoutSystem.getCommentCount()));
                        updateAudit.setTotalScore(Integer.valueOf(updateAudit.getTotalScore() + auditWithoutSystem.getTotalScore()));
                        if (updateAudit.getCommentCount() > 0) {
                            updateAudit.setScore(Integer.valueOf(updateAudit.getTotalScore() / updateAudit.getCommentCount()));
                        } else {
                            updateAudit.setScore(Integer.valueOf(0));
                        }
                    }
                    updateAudits.add(updateAudit);
                    continue;
                }
                audit.setAreaId((Long)areaIdMap.get(audit.getOrgId().intValue()));
                if (audit.getCommentCountAll() > 0) {
                    audit.setScoreAll(Integer.valueOf(audit.getTotalScoreAll() / audit.getCommentCountAll()));
                } else {
                    audit.setScoreAll(Integer.valueOf(0));
                }
                OrgCommentAudit auditWithoutSystem = (OrgCommentAudit)newCommentAuditMap.get(audit.getOrgId());
                if (auditWithoutSystem != null) {
                    audit.setCommentCount(auditWithoutSystem.getCommentCount());
                    audit.setTotalScore(auditWithoutSystem.getTotalScore());
                    if (audit.getCommentCount() > 0) {
                        audit.setScore(Integer.valueOf(audit.getTotalScore() / audit.getCommentCount()));
                    } else {
                        audit.setScore(Integer.valueOf(0));
                    }
                } else {
                    audit.setCommentCount(Integer.valueOf(0));
                    audit.setScore(Integer.valueOf(0));
                    audit.setTotalScore(Integer.valueOf(0));
                }
                addAudits.add(audit);
            }
            log.info("update commentAudit updateAudits={}", (Object)updateAudits);
            log.info("add commentAudit addAudits={}", (Object)addAudits);
            if (CollectionUtils.isNotEmpty((Collection)updateAudits)) {
                this.orgCommentAuditDao.updateAllByOrgId((Collection)updateAudits);
            }
            if (CollectionUtils.isNotEmpty((Collection)addAudits)) {
                this.orgCommentAuditDao.saveAll(addAudits, new String[]{"orgId", "areaId", "score", "totalScore", "commentCount", "scoreAll", "totalScoreAll", "commentCountAll"});
            }
            this.orgCommentAuditDao.updateAuditTime(endTime);
        }
    }

    @Override
    public OrgStudentCommentAuditDto getOrgCommentAudit(Long orgId, Collection<Long> courseIds, Collection<Long> teacherIds, Boolean isSystem, Integer userRole) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId is null!");
        log.info("audit comments of students with param: courseIds={},teacherIds={}, isSystem={}", new Object[]{courseIds, teacherIds, isSystem});
        List lessonIds = null;
        if (CollectionUtils.isNotEmpty(teacherIds) || CollectionUtils.isNotEmpty(courseIds)) {
            lessonIds = this.orgClassLessonDao.filterLessonList(orgId, courseIds, teacherIds);
        }
        OrgStudentCommentAuditDto response = new OrgStudentCommentAuditDto();
        log.info("audit comments of students result ={}", (Object)response);
        return response;
    }

    public static void main(String[] args) {
        Date endTime = DateUtil.getCurrentDate();
        System.out.println(endTime);
    }
}

