/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.card.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.constants.CommonConfig;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.card.dao.TxCardSignDao;
import com.baijia.tianxiao.dal.card.dto.TimesCardSearchDto;
import com.baijia.tianxiao.dal.card.dto.TimesCardSignSearchDto;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.card.dto.StudentTimesCardDto;
import com.baijia.tianxiao.sal.card.dto.TimesCardQrCodeDto;
import com.baijia.tianxiao.sal.card.dto.TimesCardStudentDto;
import com.baijia.tianxiao.sal.card.dto.TimescardRuleDto;
import com.baijia.tianxiao.sal.card.enums.CardStatus;
import com.baijia.tianxiao.sal.card.service.StudentTimesCardService;
import com.baijia.tianxiao.sal.card.service.TxTimescardRuleService;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.dto.request.TimesCardStudentSearchDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentTimesCardServiceImpl
implements StudentTimesCardService {
    private static final Logger log = LoggerFactory.getLogger(StudentTimesCardServiceImpl.class);
    @Autowired
    private TxPurchaseTimescardDao purchaseTimescardDao;
    @Autowired
    private TxCardSignDao signDao;
    @Autowired
    private OrgStudentDao studentDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgStudentApiService studentApiService;
    @Autowired
    private TxTimescardRuleService txTimescardRuleService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private CommonMsgService commonMsgService;

    @Override
    public List<StudentTimesCardDto> getCardListByStudentId(long orgId, long studentId) {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(PurchaseTimescardStatus.SUCCESS.getCode());
        status.add(PurchaseTimescardStatus.ECPIRE.getCode());
        status.add(PurchaseTimescardStatus.REFUND.getCode());
        List cards = this.purchaseTimescardDao.getByStudentId(Long.valueOf(orgId), Long.valueOf(studentId), status);
        ArrayList<StudentTimesCardDto> ret = new ArrayList<StudentTimesCardDto>();
        if (cards == null || cards.size() < 1) {
            return ret;
        }
        List ids = ListUtil.toKeyList((Collection)cards, (String)"id", TxPurchaseTimescard.class);
        Map signTimesMap = this.signDao.getSignTimes((Collection)ids);
        for (TxPurchaseTimescard card : cards) {
            StudentTimesCardDto dto = this.toStudentTimesCardDto(card);
            dto.setKexiaoCount(signTimesMap.get(card.getId()) == null ? 0 : (Integer)signTimesMap.get(card.getId()));
            if (dto.getBuyCount() > 0 && dto.getBuyCount() <= dto.getKexiaoCount()) {
                dto.setStatus(CardStatus.END.getCode());
                dto.setStatusStr(CardStatus.END.getDesc());
            }
            ret.add(dto);
        }
        return ret;
    }

    private StudentTimesCardDto toStudentTimesCardDto(TxPurchaseTimescard card) {
        StudentTimesCardDto dto = new StudentTimesCardDto();
        dto.setBuyCount(card.getLessonCount());
        dto.setContractEndTime(card.getEndTime());
        dto.setCardId(card.getId());
        dto.setKexiaoCount(0);
        dto.setRemark(card.getRemark());
        dto.setContractStartTime(card.getStartTime());
        dto.setDelayCount(card.getDelayCount());
        dto.setDelayDays(card.getDeferDays());
        dto.setAmount(card.getPayPrice());
        CardStatus status = this.getCardStatus(card);
        dto.setStatus(status.getCode());
        dto.setStatusStr(status.getDesc());
        dto.setPurcharseId(String.valueOf(card.getSignupPurchaseId()));
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delay(long orgId, long cardId, Date delayDate) {
        TxPurchaseTimescard card = this.purchaseTimescardDao.getByCardId(Long.valueOf(orgId), Long.valueOf(cardId), null);
        if (card == null) {
            log.info("The cardId is not exist.cardId={},orgId={}", (Object)cardId, (Object)orgId);
            throw new ParameterException("\u5361\u53f7\u4e0d\u5b58\u5728");
        }
        if (card.getEndTime() == null) {
            throw new ParameterException("\u65e0\u9650\u671f\u7684\u5361\u4e0d\u80fd\u5ef6\u671f");
        }
        TimescardRuleDto ruleDto = this.txTimescardRuleService.getRuleByOrgId(orgId);
        Date oldEndTime = card.getEndTime();
        card.setUpdateTime(new Date());
        card.setEndTime(delayDate);
        card.setDelayCount(card.getDelayCount() + 1);
        card.setDeferDays(Integer.valueOf(card.getDeferDays() + DateUtil.getDateDiff((Date)oldEndTime, (Date)delayDate)));
        Preconditions.checkArgument((card.getDelayCount() <= ruleDto.getMaxDeferTimes() ? 1 : 0) != 0, (Object)String.format("\u5ef6\u671f\u6b21\u6570\u4e0d\u80fd\u8d85\u8fc7%s\u6b21", ruleDto.getMaxDeferTimes()));
        Preconditions.checkArgument((card.getDeferDays() <= ruleDto.getMaxTotalDeferDays() ? 1 : 0) != 0, (Object)String.format("\u603b\u5ef6\u671f\u5929\u6570\u4e0d\u80fd\u8d85\u8fc7%s\u5929", ruleDto.getMaxTotalDeferDays()));
        Preconditions.checkArgument((DateUtil.getDateDiff((Date)oldEndTime, (Date)delayDate) >= ruleDto.getMinDeferDaysEachtime() ? 1 : 0) != 0, (Object)String.format("\u5355\u6b21\u5ef6\u671f\u64cd\u4f5c\u4e0d\u80fd\u5c11\u4e8e%s\u5929", ruleDto.getMinDeferDaysEachtime()));
        this.purchaseTimescardDao.update((Object)card, new String[0]);
        OrgBaseInfoDto orgInfo = this.orgInfoDao.getBaseInfo(card.getOrgId().intValue());
        OrgStudent orgStudent = (OrgStudent)this.studentDao.getById((Serializable)card.getStudentId(), new String[]{"mobile"});
        this.commonMsgService.sendTxSms(Long.valueOf(orgId), Long.valueOf(orgId), Integer.valueOf(UserRole.ORGANIZATION.getRole()), null, null, TxSmsCodeType.TIMECARD_DELAY, null, orgStudent.getMobile(), SmsContentHelper.createTimescardDelay((Date)delayDate, (String)orgInfo.getShortName()));
    }

    @Override
    @Transactional
    public void modifyRemark(long orgId, Collection<Long> cardIds, String remark) {
        List cards = this.purchaseTimescardDao.getByIds(cardIds, new String[0]);
        for (TxPurchaseTimescard card : cards) {
            card.setRemark(remark);
            card.setUpdateTime(new Date());
            this.purchaseTimescardDao.update((Object)card, new String[0]);
        }
    }

    @Override
    public List<TimesCardStudentDto> getTimesCardStudentList(long orgId, TimesCardStudentSearchDto searchDto, PageDto pageDto) {
        List cardList;
        TimesCardSignSearchDto signSearchDto;
        ArrayList<TimesCardStudentDto> retList = new ArrayList<TimesCardStudentDto>();
        TimesCardSearchDto timesCardSearchDto = searchDto.getTimesCardSearchDto();
        if (timesCardSearchDto == null) {
            timesCardSearchDto = new TimesCardSearchDto();
        }
        if ((signSearchDto = searchDto.getSignSearchDto()) == null) {
            signSearchDto = new TimesCardSignSearchDto();
        }
        Map studentMap = null;
        if (StringUtils.isNotBlank((CharSequence)searchDto.getMobile()) || StringUtils.isNotBlank((CharSequence)searchDto.getName())) {
            List studentList = this.studentDao.getStudentsLikeMobileAndName(Long.valueOf(orgId), searchDto.getMobile(), searchDto.getName(), new String[]{"id", "name", "mobile", "gender"});
            if (studentList == null || studentList.size() <= 0) {
                log.info("No student.orgId={},name={},mobile={}", new Object[]{orgId, searchDto.getName(), searchDto.getMobile()});
                return retList;
            }
            studentMap = CollectionHelper.toIdMap((Collection)studentList);
            timesCardSearchDto.setStudentIds(studentMap.keySet());
        }
        Map cardCountMap = null;
        if (signSearchDto.isFilter()) {
            cardCountMap = this.signDao.searchCardIdBySign(Long.valueOf(orgId), signSearchDto);
            if (cardCountMap == null || cardCountMap.isEmpty()) {
                log.info("No sign times card.orgId={},signSearchDto={}", (Object)orgId, (Object)signSearchDto);
                return retList;
            }
            timesCardSearchDto.setCardIds(cardCountMap.keySet());
        }
        if ((cardList = this.purchaseTimescardDao.searchTimesCardStudentList(orgId, timesCardSearchDto, pageDto)) == null || cardList.size() <= 0) {
            log.info("No times card.orgId={},searchDto={}", (Object)orgId, (Object)timesCardSearchDto);
            return retList;
        }
        if (studentMap == null) {
            List studentIds = ListUtil.toKeyList((Collection)cardList, (String)"studentId", TxPurchaseTimescard.class);
            List studentList = this.studentDao.getByIds((Collection)studentIds, new String[]{"id", "name", "mobile", "gender"});
            studentMap = CollectionHelper.toIdMap((Collection)studentList);
        }
        List cardIds = ListUtil.toKeyList((Collection)cardList, (String)"id", TxPurchaseTimescard.class);
        if (cardCountMap == null) {
            signSearchDto.setCardIds(cardIds);
            cardCountMap = this.signDao.searchCardIdBySign(Long.valueOf(orgId), signSearchDto);
        }
        Map signMap = this.signDao.getLastSignRecord(orgId, (Collection)cardIds);
        Map signTimesMap = this.signDao.getSignTimes((Collection)cardIds);
        boolean isShow = this.txCascadeCredentialService.isShowMobile(Long.valueOf(orgId), TianxiaoPCContext.getTXCascadeId());
        for (TxPurchaseTimescard card : cardList) {
            TimesCardStudentDto dto = this.toTimesCardStudentDto(card, (OrgStudent)studentMap.get(card.getStudentId()), (Integer)cardCountMap.get(card.getId()));
            dto.setLastSignTime((Date)signMap.get(dto.getCardId()));
            dto.setSignCount(signTimesMap.get(card.getId()) == null ? 0 : (Integer)signTimesMap.get(card.getId()));
            if (dto.getBuyCount() > 0 && dto.getBuyCount() <= dto.getSignCount()) {
                dto.setStatus(CardStatus.END.getCode());
                dto.setStatusStr(CardStatus.END.getDesc());
            }
            if (!isShow) {
                dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
            }
            retList.add(dto);
        }
        return retList;
    }

    private TimesCardStudentDto toTimesCardStudentDto(TxPurchaseTimescard card, OrgStudent student, Integer signCount) {
        TimesCardStudentDto dto = new TimesCardStudentDto();
        dto.setBuyCount(card.getLessonCount());
        dto.setCardId(card.getId());
        dto.setContractStartTime(card.getStartTime());
        dto.setContractEndTime(card.getEndTime());
        dto.setDelayCount(card.getDelayCount());
        dto.setMobile(student.getMobile());
        dto.setName(student.getName());
        dto.setRemark(card.getRemark());
        dto.setStudentId(card.getStudentId());
        dto.setStatusStr(this.getCardStatus(card).getDesc());
        dto.setStatus(this.getCardStatus(card).getCode());
        dto.setDelayDays(card.getDeferDays());
        if (signCount == null) {
            dto.setSignCount(0);
        } else {
            dto.setSignCount(signCount);
        }
        dto.setGenderStr(student.getGender() == 0 ? "\u7537" : "\u5973");
        return dto;
    }

    @Override
    public TimesCardQrCodeDto getTimesCardQrCode(long orgId, long cardId) {
        TxPurchaseTimescard card = this.purchaseTimescardDao.getByCardId(Long.valueOf(orgId), Long.valueOf(cardId), null);
        TimesCardQrCodeDto dto = new TimesCardQrCodeDto();
        dto.setRemark(card.getRemark());
        dto.setContractEndTime(card.getEndTime());
        OrgStudent student = (OrgStudent)this.studentDao.getById((Serializable)card.getStudentId(), new String[0]);
        dto.setName(student.getName());
        dto.setAvatar((String)this.studentApiService.batchGetStudentAvatarUrl(Arrays.asList(student)).get(student.getId()));
        dto.setUrl(CommonConfig.KE_DOMAIN + "/qrSignIn/cardInfo.do?cardId=" + cardId);
        return dto;
    }

    private CardStatus getCardStatus(TxPurchaseTimescard card) {
        if (card.getStartTime() != null && card.getStartTime().after(new Date())) {
            return CardStatus.UN_START;
        }
        if (card.getEndTime() != null) {
            if (card.getStatus() == PurchaseTimescardStatus.REFUND.getCode()) {
                return CardStatus.END;
            }
            if (new Date().after(DateUtil.getStartOfDay((Date)DateUtil.addDay((Date)card.getEndTime(), (int)1)))) {
                return CardStatus.END;
            }
        } else if (card.getStatus() == PurchaseTimescardStatus.REFUND.getCode()) {
            return CardStatus.END;
        }
        return CardStatus.NORMAL;
    }

    public static void main(String[] args) {
        System.out.print(DateUtil.getStartOfDay((Date)DateUtil.addDay((Date)new Date(), (int)1)));
    }
}

