/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.card.service.impl;

import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.LessonType;
import com.baijia.tianxiao.constant.OrgLessonSignSourceEnum;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constant.finance.PurchaseTimescardStatus;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.card.dao.TxCardSignDao;
import com.baijia.tianxiao.dal.card.enums.TxCardSignStatus;
import com.baijia.tianxiao.dal.card.po.TxCardSign;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.TxPurchaseTimescardDao;
import com.baijia.tianxiao.dal.signup.po.TxPurchaseTimescard;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErpErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.card.dto.TimesCardDto;
import com.baijia.tianxiao.sal.card.dto.TxCardSignDto;
import com.baijia.tianxiao.sal.card.service.TxCardSignService;
import com.baijia.tianxiao.sal.common.api.CommonMsgService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.dto.WechatMsgTypeSuper;
import com.baijia.tianxiao.sal.common.dto.msg.SendMsgRequest;
import com.baijia.tianxiao.sal.common.dto.wechatMsgRequest.SignWechatTemplateMsg;
import com.baijia.tianxiao.sal.common.utils.WechatTemplateMsgHelper;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.util.ErpUtils;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.SmsContentHelper;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TxCardSignServiceImpl
implements TxCardSignService {
    private static final Logger log = LoggerFactory.getLogger(TxCardSignServiceImpl.class);
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxCardSignDao txCardSignDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Autowired
    private CourseTeacherService courseTeacherService;
    @Autowired
    private TxPurchaseTimescardDao txPurchaseTimescardDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private OrgLessonSignDao orgLessonSignDao;
    @Autowired
    private CommonMsgService commonMsgService;
    @Autowired
    private OrgStudentApiService studentApiService;
    @Autowired
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Autowired
    private OrgSignupCourseLessonDao courseLessonDao;

    @Override
    @Transactional(readOnly=true)
    public List<TxCardSignDto> list(@NonNull Long orgId, List<Long> courseIds, String courseName, String studentName, String studentMobile, Date start, Date end, boolean noLesson, @NonNull PageDto pageDto) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (pageDto == null) {
            throw new NullPointerException("pageDto");
        }
        HashSet classIds = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)courseName)) {
            Integer number = ((OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[]{"number"})).getNumber();
            classIds.addAll(this.orgCourseDao.getCourseIdsByOrgNumberAndCourseName(Long.valueOf(number.longValue()), courseName, null, CourseTypeEnum.IS_COURSE_TRUE.getCode(), CourseTypeEnum.IS_CLASS_TRUE.getCode(), CourseTypeEnum.COURSE_TYPE_CLASS.getCode()));
            if (CollectionUtils.isEmpty((Collection)classIds)) {
                return Collections.EMPTY_LIST;
            }
        }
        Collection studentIds = null;
        if ((StringUtils.isNotEmpty((CharSequence)studentName) || StringUtils.isNotEmpty((CharSequence)studentMobile)) && CollectionUtils.isEmpty((Collection)(studentIds = (Collection)this.orgStudentDao.searchStudentByLike(orgId, studentMobile, Integer.valueOf(DeleteStatus.NORMAL.getValue()), studentName, new String[]{"id"}).stream().map(value -> value.getId()).collect(Collectors.toList())))) {
            return Collections.EMPTY_LIST;
        }
        if (CollectionUtils.isNotEmpty(courseIds)) {
            classIds.addAll(courseIds);
        }
        List cardSigns = this.txCardSignDao.list(orgId, studentIds, (Collection)classIds, start, end, noLesson, pageDto);
        return this.fillDetail(orgId, cardSigns);
    }

    private List<TxCardSignDto> fillDetail(Long orgId, List<TxCardSign> cardSigns) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(cardSigns)) {
            ArrayList classIds = Lists.newArrayList();
            ArrayList studentIds = Lists.newArrayList();
            ArrayList lessonIds = Lists.newArrayList();
            cardSigns.stream().forEach(txCardSign -> {
                studentIds.add(txCardSign.getStudentId());
                if (txCardSign.getStudentLessonId() > 0L) {
                    classIds.add(txCardSign.getClassId());
                    lessonIds.add(txCardSign.getLessonId());
                }
            });
            List studentList = this.orgStudentDao.getByIds((Collection)studentIds, new String[]{"id", "name", "nickName", "mobile", "gender"});
            log.debug("query students by:{}, result:{}", (Object)studentIds, (Object)studentList);
            Map classNameMap = this.orgCourseDao.getCourseNameMap((Collection)classIds);
            Map studentNameMap = CollectorUtil.collectMap((Collection)studentList, input -> input.getId(), input -> input.getNotEmptyName());
            Map studentMobileMap = CollectorUtil.collectMap((Collection)studentList, input -> input.getId(), input -> input.getMobile());
            Map studentGenderMap = CollectorUtil.collectMap((Collection)studentList, input -> input.getId(), input -> input.getGender());
            Map lessonMap = CollectorUtil.collectMap((Collection)this.orgClassLessonDao.getByIds((Collection)lessonIds, new String[]{"id", "number", "startTime", "endTime"}), input -> input.getId());
            Map<Long, String> teacherNameMap = this.getTeachersOfCourses(orgId, classIds);
            cardSigns.stream().forEach(txCardSign -> {
                TxCardSignDto dto = new TxCardSignDto();
                dto.setId(txCardSign.getId());
                dto.setStudentId(txCardSign.getStudentId());
                dto.setUserId(txCardSign.getUserId());
                dto.setStudentLessonId(txCardSign.getStudentLessonId());
                dto.setStudentName((String)studentNameMap.get(txCardSign.getStudentId()));
                dto.setStudentGender((Integer)studentGenderMap.get(txCardSign.getStudentId()));
                dto.setStudentMobile((String)studentMobileMap.get(txCardSign.getStudentId()));
                OrgClassLesson lesson = (OrgClassLesson)lessonMap.get(txCardSign.getLessonId());
                dto.setLessonName(null == lesson ? "\u65e0\u8bfe\u7a0b\u4fe1\u606f" : (String)classNameMap.get(txCardSign.getClassId()) + String.format("-\u7b2c%s\u8282", lesson.getNumber()));
                dto.setStartTime(null == lesson ? null : lesson.getStartTime());
                dto.setEndTime(null == lesson ? null : lesson.getEndTime());
                dto.setTeacherName(teacherNameMap.getOrDefault(txCardSign.getClassId(), "\u65e0"));
                dto.setSignTime(txCardSign.getCreateTime());
                dto.setRemark(txCardSign.getRemark());
                result.add(dto);
            });
        }
        return result;
    }

    private Map<Long, String> getTeachersOfCourses(Long orgId, Collection<Long> courseIds) {
        log.info("orgId={},courseIds={}", (Object)orgId, courseIds);
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        HashMap resultMap = Maps.newHashMap();
        Map courseTeachersMap = this.orgCourseTeacherDao.getTeacherMap(courseIds);
        HashSet teacherIdsSet = Sets.newHashSet();
        for (Long key : courseTeachersMap.keySet()) {
            List list = (List)courseTeachersMap.get(key);
            teacherIdsSet.addAll(list);
        }
        List teacherDtoList = this.courseTeacherService.getTeachers((Collection)teacherIdsSet, orgId);
        Map teacherMap = CollectorUtil.collectMap((Collection)teacherDtoList, from -> from.getTeacherId(), from -> from.getTeacherName());
        for (Long courseId : courseIds) {
            List teacherIds = (List)courseTeachersMap.get(courseId);
            ArrayList teacherList = Lists.newArrayList();
            if (!CollectionUtils.isNotEmpty((Collection)teacherIds)) continue;
            for (Long tid : teacherIds) {
                teacherList.add(teacherMap.get(tid));
            }
            resultMap.put(courseId, teacherList.stream().filter(s -> s != null).reduce((s, s2) -> s + "," + s2).orElse(""));
        }
        return resultMap;
    }

    @Override
    @Transactional(readOnly=true)
    public TimesCardDto getCardInfo(Long orgId, Long cardId) {
        TxPurchaseTimescard timescard = this.txPurchaseTimescardDao.getByCardId(orgId, cardId, null);
        Preconditions.checkArgument((null != timescard ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((orgId.longValue() == timescard.getOrgId().longValue() ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u4e0d\u5c5e\u4e8e\u60a8\u7684\u673a\u6784");
        Preconditions.checkArgument((timescard.getStatus() != PurchaseTimescardStatus.INIT.getCode() && timescard.getStatus() != PurchaseTimescardStatus.CANCEL.getCode() ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u672a\u652f\u4ed8");
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)timescard.getStudentId(), new String[0]);
        Preconditions.checkArgument((null != orgStudent ? 1 : 0) != 0, (Object)"\u5b66\u751f\u4e0d\u5b58\u5728");
        Preconditions.checkArgument((timescard.getLessonCount() < 0 || timescard.getLessonCount() > this.txCardSignDao.getSignTimes(cardId) ? 1 : 0) != 0, (Object)"\u6b21\u5361\u4f7f\u7528\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650!");
        TimesCardDto timesCardDto = new TimesCardDto();
        timesCardDto.setId(timescard.getId());
        timesCardDto.setSignupPurchaseId(timescard.getSignupPurchaseId());
        timesCardDto.setCardNumber(timescard.getCardNumber());
        timesCardDto.setSignInTimes(this.txCardSignDao.getSignTimes(cardId));
        timesCardDto.setLessonCount(timescard.getLessonCount());
        timesCardDto.setCardRemark(timescard.getRemark());
        timesCardDto.setStartTime(timescard.getStartTime());
        timesCardDto.setEndTime(timescard.getEndTime());
        timesCardDto.setStudentId(timescard.getStudentId());
        timesCardDto.setUserId(timescard.getUserId());
        timesCardDto.setStudentName(orgStudent.getName());
        timesCardDto.setStudentAvatar((String)this.studentApiService.batchGetStudentAvatarUrl(Arrays.asList(orgStudent)).get(timescard.getStudentId()));
        return timesCardDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<OrgLessonSign> qrSignBindStudentLessonSign(@NonNull Long orgId, Long cascadeId, List<Long> cardSignIds, @NonNull Long lessonId, boolean commit) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        List cardSigns = this.txCardSignDao.getByIds(cardSignIds, new String[0]);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)cardSigns), (Object)"TxCardSign list is empty!");
        Preconditions.checkArgument((boolean)cardSigns.stream().allMatch(txCardSign -> txCardSign.getIsdel().intValue() == DeleteStatus.NORMAL.getValue()), (Object)"TxCardSign list can not contains deleted ones");
        Preconditions.checkArgument((boolean)cardSigns.stream().allMatch(txCardSign -> txCardSign.getStatus().intValue() == TxCardSignStatus.INIT.getCode() && txCardSign.getClassId() == (long)Flag.FALSE.getInt() && txCardSign.getLessonId() == (long)Flag.FALSE.getInt() && txCardSign.getStudentLessonId() == (long)Flag.FALSE.getInt()), (Object)"\u6570\u636e\u4e0d\u4e00\u81f4! \u5217\u8868\u5305\u542b\u5df2\u7ecf\u8865\u5145\u8fc7\u7684\u626b\u7801\u7b7e\u5230!");
        return this.bindStudentLessonSign(orgId, cascadeId, cardSigns, lessonId, commit);
    }

    @Transactional(rollbackFor={Exception.class})
    private List<OrgLessonSign> bindStudentLessonSign(@NonNull Long orgId, Long cascadeId, @NonNull List<TxCardSign> txCardSigns, @NonNull Long lessonId, boolean commit) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (txCardSigns == null) {
            throw new NullPointerException("txCardSigns");
        }
        if (lessonId == null) {
            throw new NullPointerException("lessonId");
        }
        if (CollectionUtils.isEmpty(txCardSigns)) {
            return Collections.EMPTY_LIST;
        }
        OrgClassLesson classLesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Preconditions.checkArgument((null != classLesson && classLesson.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() ? 1 : 0) != 0, (Object)"\u8bfe\u8282\u88ab\u5220\u9664\u4e86!");
        Preconditions.checkArgument((txCardSigns.stream().allMatch(txCardSign -> orgId.longValue() == txCardSign.getOrgId().longValue()) && orgId.longValue() == classLesson.getOrgId().longValue() ? 1 : 0) != 0, (Object)"orgId\u4e0d\u4e00\u81f4!");
        Map txCardSignMap = CollectorUtil.collectMap(txCardSigns, input -> input.getUserId());
        Set userIds = txCardSignMap.keySet();
        Preconditions.checkArgument((userIds.size() == txCardSigns.size() ? 1 : 0) != 0, (Object)"\u4e00\u6b21\u64cd\u4f5c\u4e2d\u4e0d\u80fd\u6709\u91cd\u590d\u5b66\u5458");
        Map studentLessonMap = CollectorUtil.collectMap((Collection)this.orgStudentLessonDao.getByLessonIdsStudentIds((Collection)Lists.newArrayList((Object[])new Long[]{lessonId}), userIds, new String[0]), input -> input.getUserId());
        Map studentSignMap = CollectorUtil.collectMap((Collection)this.orgLessonSignDao.getByOrgIdCourseIdLessonIdsStudentIds(orgId, classLesson.getCourseId(), (Collection)Lists.newArrayList((Object[])new Long[]{lessonId}), userIds, new String[0]), input -> input.getUserId());
        HashSet alreadyHasNormalLessonUserIds = Sets.newHashSet();
        HashSet alreadyHasLessonSignUserIds = Sets.newHashSet();
        for (Long userId : userIds) {
            OrgStudentLesson orgStudentLesson = (OrgStudentLesson)studentLessonMap.get(userId);
            OrgLessonSign orgLessonSign = (OrgLessonSign)studentSignMap.get(userId);
            if (null != orgStudentLesson && orgStudentLesson.getLessonType().intValue() != LessonType.FREE.getCode()) {
                alreadyHasNormalLessonUserIds.add(userId);
                log.info("[bindStudentLessonSign] userId:{}, \u6b63\u4ef7\u8bfe:{}", (Object)userId, (Object)orgStudentLesson);
                continue;
            }
            if (null == orgLessonSign || orgLessonSign.getStatus().intValue() == SignStatus.UNSIGN.getCode()) continue;
            alreadyHasLessonSignUserIds.add(userId);
            log.info("[bindStudentLessonSign] userId:{}, \u7b7e\u5230:{}", (Object)userId, (Object)orgLessonSign);
        }
        StringBuilder exceptionStr = new StringBuilder();
        boolean throwErr = false;
        if (CollectionUtils.isNotEmpty((Collection)alreadyHasNormalLessonUserIds)) {
            exceptionStr.append(String.format("\u5df2\u7ecf\u6709%s\u4e2a\u5b66\u751f\u5728\u8be5\u8bfe\u8282\u7ed1\u5b9a\u6b63\u4ef7\u8bfe ", alreadyHasNormalLessonUserIds.size()));
            userIds.removeAll(alreadyHasNormalLessonUserIds);
            throwErr = true;
        }
        if (CollectionUtils.isNotEmpty((Collection)alreadyHasLessonSignUserIds)) {
            exceptionStr.append(String.format("\u5df2\u7ecf\u6709%s\u4e2a\u5b66\u751f\u5728\u8be5\u8bfe\u8282\u6709\u7b7e\u5230\u72b6\u6001", alreadyHasLessonSignUserIds.size()));
            userIds.removeAll(alreadyHasLessonSignUserIds);
            throwErr = true;
        }
        if (!commit && throwErr) {
            throw new BussinessException((UniverseErrorCode)ErpErrorCode.QR_SIGN_CANNOT_BIND_LESSON, exceptionStr.toString());
        }
        ArrayList result = Lists.newArrayList();
        for (Long userId : userIds) {
            OrgStudentLesson orgStudentLesson = (OrgStudentLesson)studentLessonMap.get(userId);
            OrgLessonSign orgLessonSign = (OrgLessonSign)studentSignMap.get(userId);
            TxCardSign cardSign = (TxCardSign)txCardSignMap.get(userId);
            if (null == orgStudentLesson) {
                orgStudentLesson = new OrgStudentLesson();
                orgStudentLesson.setOrgId(orgId);
                orgStudentLesson.setLessonId(classLesson.getId());
                orgStudentLesson.setUserId(userId);
                orgStudentLesson.setCourseId(classLesson.getCourseId());
                orgStudentLesson.setCreateTime(new Date());
                orgStudentLesson.setUpdateTime(new Date());
                orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                orgStudentLesson.setLessonType(Integer.valueOf(LessonType.NORMAL.getCode()));
                orgStudentLesson.setLessonDuration(Integer.valueOf(DateUtil.getMinuteDiff((Date)classLesson.getStartTime(), (Date)classLesson.getEndTime())));
                this.orgStudentLessonDao.save((Object)orgStudentLesson, new String[]{"orgId", "lessonId", "userId", "courseId", "createTime", "updateTime", "delStatus", "lessonType", "lessonDuration"});
                cardSign.setClassId(classLesson.getCourseId());
                cardSign.setLessonId(classLesson.getId());
                cardSign.setStudentLessonId(orgStudentLesson.getId());
                cardSign.setUpdateTime(new Date());
                cardSign.setStatus(Integer.valueOf(TxCardSignStatus.NEW_LESSON.getCode()));
                this.txCardSignDao.update((Object)cardSign, new String[]{"classId", "lessonId", "studentLessonId", "updateTime", "status"});
            } else {
                if (orgStudentLesson.getLessonType().intValue() != LessonType.FREE.getCode() || orgLessonSign != null && orgLessonSign.getStatus().intValue() != SignStatus.UNSIGN.getCode()) continue;
                orgStudentLesson.setLessonType(Integer.valueOf(LessonType.NORMAL.getCode()));
                orgStudentLesson.setUpdateTime(new Date());
                this.orgStudentLessonDao.update((Object)orgStudentLesson, new String[]{"lessonType", "updateTime"});
                this.signupCourseLessonDao.deleteSignupCourseLesson(orgStudentLesson.getUserId().longValue(), orgStudentLesson.getLessonId().longValue());
                cardSign.setClassId(classLesson.getCourseId());
                cardSign.setLessonId(classLesson.getId());
                cardSign.setStudentLessonId(orgStudentLesson.getId());
                cardSign.setUpdateTime(new Date());
                cardSign.setStatus(Integer.valueOf(TxCardSignStatus.UPGRADE_TO_PAY_LESSON.getCode()));
                this.txCardSignDao.update((Object)cardSign, new String[]{"classId", "lessonId", "studentLessonId", "updateTime", "status"});
                this.courseLessonDao.batchDelStuLesson(orgId.longValue(), Arrays.asList(orgStudentLesson.getUserId()), Arrays.asList(orgStudentLesson.getLessonId()));
            }
            if (null != orgLessonSign) {
                this.orgLessonSignDao.orgLessonSignBatchEdit(orgId, lessonId, (Collection)Lists.newArrayList((Object[])new Long[]{userId}), Integer.valueOf(SignStatus.SIGNED.getCode()), cascadeId, Integer.valueOf(OrgLessonSignSourceEnum.QR_SCAN.getValue()));
                result.add(orgLessonSign);
                continue;
            }
            OrgLessonSign lessonSign = new OrgLessonSign();
            lessonSign.setCourseId(classLesson.getCourseId());
            lessonSign.setCreateTime(new Date());
            lessonSign.setLessonId(lessonId);
            lessonSign.setOrgId(orgId);
            lessonSign.setStatus(Integer.valueOf(SignStatus.SIGNED.getCode()));
            lessonSign.setUserId(userId);
            lessonSign.setUpdateTime(new Date());
            lessonSign.setUserRole(Integer.valueOf(UserRole.STUDENT.getRole()));
            lessonSign.setCascadeId(cascadeId);
            lessonSign.setTeacherId(Integer.valueOf(0));
            lessonSign.setSource(Integer.valueOf(OrgLessonSignSourceEnum.QR_SCAN.getValue()));
            this.orgLessonSignDao.save((Object)lessonSign, Boolean.valueOf(false), new String[]{"courseId", "createTime", "lessonId", "orgId", "status", "userId", "updateTime", "userRole", "cascadeId", "source", "teacherId"});
            result.add(lessonSign);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void qrSign(@NonNull Long orgId, Long cascadeId, @NonNull Long cardId, Long lessonId, String remark) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (cardId == null) {
            throw new NullPointerException("cardId");
        }
        TxPurchaseTimescard timescard = this.txPurchaseTimescardDao.getByCardId(orgId, cardId, null);
        Preconditions.checkArgument((null != timescard && orgId.longValue() == timescard.getOrgId().longValue() ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u4e0d\u5b58\u5728");
        if (timescard.getStatus() != PurchaseTimescardStatus.SUCCESS.getCode()) {
            Preconditions.checkArgument((timescard.getStatus() != PurchaseTimescardStatus.INIT.getCode() && timescard.getStatus() != PurchaseTimescardStatus.CANCEL.getCode() ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u672a\u652f\u4ed8");
            Preconditions.checkArgument((timescard.getStatus() != PurchaseTimescardStatus.REFUND.getCode() ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u5df2\u7ecf\u9000\u5361\uff0c\u65e0\u6cd5\u7b7e\u5230");
            Preconditions.checkArgument((timescard.getStatus() != PurchaseTimescardStatus.ECPIRE.getCode() ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u5df2\u7ecf\u8fc7\u671f\u5931\u6548\uff0c\u65e0\u6cd5\u7b7e\u5230");
        }
        Preconditions.checkArgument((boolean)timescard.getStartTime().before(new Date()), (Object)"\u60a8\u7684\u6b21\u5361\u672a\u5230\u5f00\u59cb\u4f7f\u7528\u65f6\u95f4\uff0c\u65e0\u6cd5\u7b7e\u5230");
        Preconditions.checkArgument((null == timescard.getEndTime() || DateUtil.addDay((Date)DateUtil.getStartOfDay((Date)timescard.getEndTime()), (int)1).after(new Date()) ? 1 : 0) != 0, (Object)"\u60a8\u626b\u63cf\u7684\u6b21\u5361\u5df2\u7ecf\u8fc7\u671f\u5931\u6548\uff0c\u65e0\u6cd5\u7b7e\u5230");
        Integer totalSignTimes = this.txCardSignDao.getSignTimes(cardId);
        Preconditions.checkArgument((timescard.getLessonCount() < 0 || timescard.getLessonCount() > totalSignTimes ? 1 : 0) != 0, (Object)"\u6b21\u5361\u4f7f\u7528\u6b21\u6570\u5df2\u7ecf\u8fbe\u5230\u4e0a\u9650!");
        Preconditions.checkArgument((timescard.getStatus() == PurchaseTimescardStatus.SUCCESS.getCode() ? 1 : 0) != 0);
        TxCardSign txCardSign = new TxCardSign();
        txCardSign.setOrgId(orgId);
        txCardSign.setStudentId(timescard.getStudentId());
        txCardSign.setUserId(timescard.getUserId());
        txCardSign.setCardId(cardId);
        txCardSign.setStatus(Integer.valueOf(TxCardSignStatus.INIT.getCode()));
        txCardSign.setRemark(StringUtils.defaultString((String)remark, (String)""));
        txCardSign.setClassId(Long.valueOf(0L));
        txCardSign.setLessonId(Long.valueOf(0L));
        txCardSign.setStudentLessonId(Long.valueOf(0L));
        txCardSign.setCreateTime(new Date());
        txCardSign.setUpdateTime(txCardSign.getCreateTime());
        txCardSign.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        this.txCardSignDao.save((Object)txCardSign, new String[0]);
        List<OrgLessonSign> signs = null;
        if (null != lessonId) {
            try {
                signs = this.bindStudentLessonSign(orgId, cascadeId, Lists.newArrayList((Object[])new TxCardSign[]{txCardSign}), lessonId, false);
            }
            catch (BussinessException e) {
                if (e.getErrorCode() == ErpErrorCode.QR_SIGN_CANNOT_BIND_LESSON) {
                    throw new BussinessException((UniverseErrorCode)ErpErrorCode.QR_SIGN_CANNOT_BIND_LESSON, "\u8be5\u5b66\u5458\u5728\u8be5\u8bfe\u8282\u4e0a\u662f\u6b63\u4ef7\u8bfe\u6216\u5df2\u6709\u7b7e\u5230\u72b6\u6001");
                }
                throw e;
            }
        }
        this.txPurchaseTimescardDao.increaseSignInCount(cardId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)timescard.getStudentId(), new String[0]);
        String courseName = null;
        String teacherName = null;
        OrgClassLesson lesson = null;
        if (CollectionUtils.isNotEmpty(signs)) {
            OrgLessonSign sign = signs.get(0);
            courseName = ((OrgCourse)this.orgCourseDao.getById((Serializable)sign.getCourseId(), new String[]{"name"})).getName();
            lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)sign.getLessonId(), new String[0]);
            teacherName = this.getTeachersOfCourses(orgId, Lists.newArrayList((Object[])new Long[]{sign.getCascadeId()})).getOrDefault(sign.getCascadeId(), "-");
        }
        this.signSendMsg(orgAccount, orgInfo, orgStudent, teacherName, lesson, courseName, txCardSign.getCreateTime().getTime());
        if (timescard.getLessonCount() > 0 && timescard.getLessonCount() <= totalSignTimes + 1) {
            this.commonMsgService.sendTxSms(orgId, orgId, Integer.valueOf(UserRole.ORGANIZATION.getRole()), null, null, TxSmsCodeType.TIMECARD_EXHAUSTED, null, orgStudent.getMobile(), SmsContentHelper.createTimescardExhausted((String)orgInfo.getShortName()));
        }
    }

    private void signSendMsg(OrgAccount orgAccount, OrgInfo orgInfo, OrgStudent student, String teacherName, OrgClassLesson lesson, String courseName, Long signTime) {
        try {
            SendMsgRequest sendMsgRequest = this.getSendMsgRequest(orgAccount, orgInfo, student, teacherName, lesson, courseName, signTime);
            log.info("sendMsgRequest is:{}", (Object)sendMsgRequest);
            sendMsgRequest.setSmsCodeType(TxSmsCodeType.SIGN_NOTIFY_PRESENT);
            this.commonMsgService.sendMsg(sendMsgRequest);
        }
        catch (Exception e) {
            log.error("error : {} ", (Throwable)e);
            log.warn(e.getMessage());
        }
    }

    private SendMsgRequest getSendMsgRequest(OrgAccount orgAccount, OrgInfo orgInfo, OrgStudent student, String teacherName, OrgClassLesson lesson, String courseName, Long signTime) {
        String studentName = (String)StringUtils.defaultIfBlank((CharSequence)student.getNotEmptyName(), (CharSequence)"-");
        String orgName = orgInfo.getShortName();
        String extention = orgInfo.getExtension();
        teacherName = (String)StringUtils.defaultIfBlank((CharSequence)teacherName, (CharSequence)"-");
        String smsContent = SmsContentHelper.createSignRecordSmsMsg((int)1, (String)studentName, (Long)signTime, (String)courseName, (String)orgName);
        String url = ErpUtils.createClassSchedule((Integer)orgAccount.getNumber(), (Long)orgInfo.getOrgId().longValue(), (Long)student.getId());
        SignWechatTemplateMsg msg = SignWechatTemplateMsg.newInstance((String)studentName, (String)orgName, (Integer)SignStatus.SIGNED.getCode(), (String)((String)StringUtils.defaultIfBlank((CharSequence)courseName, (CharSequence)"-")), (Long)(lesson == null ? null : Long.valueOf(lesson.getStartTime().getTime())), (Long)(lesson == null ? null : Long.valueOf(lesson.getEndTime().getTime())), (long)signTime, (String)teacherName, (String)extention, (String)url);
        SendMsgRequest createSendMsgRequestToStu = WechatTemplateMsgHelper.createSendMsgRequestToStu((Long)orgInfo.getOrgId().longValue(), (String)student.getMobile(), (Long)student.getId(), (String)student.getWeixin(), (String)smsContent, (WechateTemplateMsgType)WechateTemplateMsgType.COURSE_SIGNIN_TO_STU, (WechatMsgTypeSuper)msg);
        return createSendMsgRequestToStu;
    }
}

