/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.callservice.service;

import com.baijia.tianxiao.sal.callservice.dto.BidirectionalCallResponse;
import com.baijia.tianxiao.sal.callservice.dto.CallRecordDto;
import com.baijia.tianxiao.sal.callservice.dto.CallbackRecordRequest;
import com.baijia.tianxiao.sal.callservice.dto.MakeCallDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * @title CallService
 * @desc TODO
 * @author cxm
 * @date 2015年12月7日
 * @version 1.0
 */
public interface CallService {

    public static final Long ANONYMOUS_USER_ID = -9999L;
    public static final String CALLSERVICE_VALIDATE_KEY = "bjhl_ddte3782Jskgwd278";
    public static final int DEFAULT_HOLDING_SEC = 1000*60;// 用户默认通话1000分钟

    // @Override
    public abstract boolean callParty(MakeCallDto callDto);
    
    public BidirectionalCallResponse bidirectionalCall(MakeCallDto callDto);
    
    /**
     * 容联回调使用的service
     * 
     * @param 回调req转换dto
     * @return 正确码
     */
    public String bidirectionalCallRecord(CallbackRecordRequest dto);
    
    public void cancelBidirectionalCall(String callId);
    
    List<CallRecordDto> listCallRecord(Integer cascadeId, Integer userId, Integer userType, PageDto pageDto);
}
