
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.callservice.ronglian;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import com.baijia.tianxiao.sal.callservice.dto.RLBiCallResponse;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import lombok.extern.slf4j.Slf4j;

/**
 * @title RLCallHelper
 * @desc TODO
 * @author caoliang
 * @date 2016年5月3日
 * @version 1.0
 */
@Slf4j
public class RLCallHelper {

    private static Properties PROP;
    private static String APPID = "rl.bidirectional_call.appid";
    private static String URL = "rl.bidirectional_call.url";
    private static String PORT = "rl.bidirectional_call.port";
    private static String ACCOUNTSID = "rl.bidirectional_call.account_sid";
    private static String ACCOUNTTOKEN = "rl.bidirectional_call.account_token";
    private static String SUBACCOUNTSID = "rl.bidirectional_call.sub_account_sid";
    private static String SUBACCOUNTTOKEN = "rl.bidirectional_call.sub_account_token";
    private static String CALLBACK = "rl.bidirectional_call.callback";
    public static String FROM_DISPLAY = "rl.subscriber_display_number";
    // 默认常量
    private static final Integer MAX_CALL_TIME = 60 * 30;// 单次通话最多30分钟
    private static final String NEED_RECORD = "1";
    public static final String RL_SUCCESS = "000000";
    private static final String NEED_BOTH_CDR = "1";
    private static String SUBSCRIBERDISPLAYMOBILE = null;
    private static CCPRestSDK restAPI = new CCPRestSDK();

    static {
        PROP = PropertiesReader.fillProperties("callservice");
        if (PROP != null) {
            // 初始化服务器地址和端口，格式如下，服务器地址不需要写https://
            restAPI.init(PROP.getProperty(URL), PROP.getProperty(PORT));
            // 初始化主帐号，token
            restAPI.setAccount(PROP.getProperty(ACCOUNTSID), PROP.getProperty(ACCOUNTTOKEN));
            restAPI.setSubAccount(PROP.getProperty(SUBACCOUNTSID), PROP.getProperty(SUBACCOUNTTOKEN));
            restAPI.setAppId(PROP.getProperty(APPID));
            SUBSCRIBERDISPLAYMOBILE = PROP.getProperty(FROM_DISPLAY);
        }
    }

    /**
     * 每次请求都打印详细返回 如请求不成功，抛异常
     * 
     * @param from 主叫号码
     * @param to 被叫号码
     * @return
     */

    @SuppressWarnings("unchecked")
    public static final RLBiCallResponse bidirectionalCall(String callId, String from, String to) throws Exception {
        RLBiCallResponse res = null;
        HashMap<String, Object> result = null;
        try {
            result = restAPI.callback(from, to, null, SUBSCRIBERDISPLAYMOBILE, null, null, null, callId, MAX_CALL_TIME.toString(),
                PROP.getProperty(CALLBACK), NEED_BOTH_CDR, NEED_RECORD, null, null);
            log.info("callId:{},from:{},to:{},result:{}", callId, from, to, result);
        } catch (Exception e) {
            log.error("call rl server error!", e);
            throw new Exception("call rl server error!");
        }
        if (result != null) {
            if (RL_SUCCESS.equals(result.get("statusCode"))) {
                HashMap<String, Object> data = (HashMap<String, Object>) result.get("data");
                res = JacksonUtil.str2Obj(JacksonUtil.obj2Str(data.get("CallBack")), RLBiCallResponse.class);
                log.info("call rl server success!!res:{}",res);
            } else {
                throw new Exception("fail to call rl server!");
            }
        } else {
            throw new Exception("no response from rl server!");
        }
        return res;
    }

    /**
     * 取消双呼
     * 
     * @param callId
     */
    public static final void cancelBidirectionalCall(String callId) {
        Map<String, Object> result = restAPI.CallCancel(callId, null);
        log.info("cancelBidirectionalCall callId,:{},result:{}", callId, result);
    }
}
