/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.callservice.ronglian;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.callservice.dto.RLBiCallResponse;
import com.baijia.tianxiao.sal.callservice.ronglian.CCPRestSDK;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RLCallHelper {
    private static final Logger log = LoggerFactory.getLogger(RLCallHelper.class);
    private static Properties PROP;
    private static String APPID;
    private static String URL;
    private static String PORT;
    private static String ACCOUNTSID;
    private static String ACCOUNTTOKEN;
    private static String SUBACCOUNTSID;
    private static String SUBACCOUNTTOKEN;
    private static String CALLBACK;
    public static String FROM_DISPLAY;
    private static final Integer MAX_CALL_TIME;
    private static final String NEED_RECORD = "1";
    public static final String RL_SUCCESS = "000000";
    private static final String NEED_BOTH_CDR = "1";
    private static String SUBSCRIBERDISPLAYMOBILE;
    private static CCPRestSDK restAPI;

    public static final RLBiCallResponse bidirectionalCall(String callId, String from, String to) throws Exception {
        if (StringUtils.isBlank((CharSequence)from) || StringUtils.isBlank((CharSequence)to)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "mobile is null! from:" + from + ",to:" + to);
        }
        if (from.equals(to)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "from equals to! from:" + from + ",to:" + to);
        }
        RLBiCallResponse res = null;
        HashMap<String, Object> result = null;
        try {
            result = restAPI.callback(from, to, null, SUBSCRIBERDISPLAYMOBILE, null, null, null, callId, MAX_CALL_TIME.toString(), PROP.getProperty(CALLBACK), "1", "1", null, null);
            log.info("callId:{},from:{},to:{},result:{}", new Object[]{callId, from, to, result});
        }
        catch (Exception e) {
            log.error("call rl server error!", (Throwable)e);
            throw new Exception("call rl server error!");
        }
        if (result != null) {
            if (!RL_SUCCESS.equals(result.get("statusCode"))) {
                throw new Exception("fail to call rl server!" + result.get("statusMsg"));
            }
        } else {
            throw new Exception("no response from rl server!");
        }
        HashMap data = (HashMap)result.get("data");
        res = (RLBiCallResponse)JacksonUtil.str2Obj((String)JacksonUtil.obj2Str(data.get("CallBack")), RLBiCallResponse.class);
        log.info("call rl server success!!res:{}", (Object)res);
        return res;
    }

    public static final void cancelBidirectionalCall(String callId) {
        HashMap<String, Object> result = restAPI.CallCancel(callId, null);
        log.info("cancelBidirectionalCall callId,:{},result:{}", (Object)callId, result);
    }

    static {
        APPID = "rl.bidirectional_call.appid";
        URL = "rl.bidirectional_call.url";
        PORT = "rl.bidirectional_call.port";
        ACCOUNTSID = "rl.bidirectional_call.account_sid";
        ACCOUNTTOKEN = "rl.bidirectional_call.account_token";
        SUBACCOUNTSID = "rl.bidirectional_call.sub_account_sid";
        SUBACCOUNTTOKEN = "rl.bidirectional_call.sub_account_token";
        CALLBACK = "rl.bidirectional_call.callback";
        FROM_DISPLAY = "rl.subscriber_display_number";
        MAX_CALL_TIME = 1800;
        SUBSCRIBERDISPLAYMOBILE = null;
        restAPI = new CCPRestSDK();
        PROP = PropertiesReader.fillProperties((String)"callservice");
        if (PROP != null) {
            restAPI.init(PROP.getProperty(URL), PROP.getProperty(PORT));
            restAPI.setAccount(PROP.getProperty(ACCOUNTSID), PROP.getProperty(ACCOUNTTOKEN));
            restAPI.setSubAccount(PROP.getProperty(SUBACCOUNTSID), PROP.getProperty(SUBACCOUNTTOKEN));
            restAPI.setAppId(PROP.getProperty(APPID));
            SUBSCRIBERDISPLAYMOBILE = PROP.getProperty(FROM_DISPLAY);
        }
    }
}

