/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.callservice.service.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.common.ServiceException;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.dal.callservice.constant.PartyCallType;
import com.baijia.tianxiao.dal.callservice.constant.RLCallStatus;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceDialBackDao;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceDialBack;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.callservice.constants.CallServiceErrorCode;
import com.baijia.tianxiao.sal.callservice.dto.BidirectionalCallResponse;
import com.baijia.tianxiao.sal.callservice.dto.CallServiceResponse;
import com.baijia.tianxiao.sal.callservice.dto.CallbackRecordRequest;
import com.baijia.tianxiao.sal.callservice.dto.MakeCallDto;
import com.baijia.tianxiao.sal.callservice.dto.MnsMessageBodyDto;
import com.baijia.tianxiao.sal.callservice.dto.RLBiCallResponse;
import com.baijia.tianxiao.sal.callservice.ronglian.RLCallHelper;
import com.baijia.tianxiao.sal.callservice.service.CallService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CallServiceImpl
implements CallService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CallServiceImpl.class);
    @Resource
    private UserDao userDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private CallServiceDialBackDao callServiceDialBackDao;
    @Autowired(required=false)
    private CloudAccount cloudAccount;
    private CloudQueue downloadFileQueue;
    private CloudQueue consulterFollowRecordQueue;

    @Override
    public boolean callParty(MakeCallDto callDto) {
        this.fillCallAndSubscriberId(callDto);
        Preconditions.checkArgument((callDto.getSubscriberUserId() != null ? 1 : 0) != 0, (Object)"subscriber user id or user number can not be null");
        Preconditions.checkArgument((callDto.getCalledUserId() != null ? 1 : 0) != 0, (Object)"called user id or user number can not be null");
        long timeStamp = System.currentTimeMillis();
        Properties callserviceProp = PropertiesReader.getProperties((String)"callservice.properties");
        String secStr = callDto.getCalledUserId().toString() + callDto.getSubscriberUserId().toString() + timeStamp + callserviceProp.getProperty("callservice.secure.key", "bjhl_ddte3782Jskgwd278");
        HashMap params = Maps.newHashMap();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callDto.getSubscriberMobile()})) {
            secStr = secStr + callDto.getSubscriberMobile();
            params.put("subscriberNumber", callDto.getSubscriberMobile());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callDto.getCalledUserMobile()})) {
            secStr = secStr + callDto.getCalledUserMobile();
            params.put("calledPartyMobile", callDto.getCalledUserMobile());
        }
        String sign = DigestUtils.md5Hex((String)secStr);
        params.put("sign", sign);
        params.put("timeStamp", timeStamp + "");
        params.put("callType", "4");
        params.put("calledParty", callDto.getCalledUserId().toString());
        params.put("callSubscriber", callDto.getSubscriberUserId().toString());
        String url = callserviceProp.getProperty("callservice.makecall.url");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url}), (Object)("url is illegal:" + url));
        try {
            log.info("callParty.url:{}, params:{}", (Object)url, (Object)params);
            String resp = HttpClientUtils.doGet((String)url, (Map)params);
            log.info("callParty.resp:{}", (Object)resp);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resp})) {
                CallServiceResponse response = (CallServiceResponse)JacksonUtil.str2Obj((String)resp, CallServiceResponse.class);
                if (response.getStatus() != 200) {
                    log.warn("make call error:{}", (Object)response.getError());
                    return false;
                }
                log.info("success submit call party request to url:{},params:{},resp:{}", new Object[]{url, params, resp});
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.warn("call party catch error,params:{},url:{},error:{}", new Object[]{params, url, e});
            return false;
        }
    }

    private void fillCallAndSubscriberId(MakeCallDto callDto) {
        User user;
        OrgAccount orgAcc;
        if (callDto.getSubscriberUserId() == null || callDto.getSubscriberUserId() <= 0L) {
            Preconditions.checkArgument((callDto.getSubscriberNumber() != null && callDto.getSubscriberNumber() > 0L ? 1 : 0) != 0, (Object)"subscriber user id or user number can not both be null");
            if (PartyCallType.getOrgSubsriberType().contains(callDto.getCallType())) {
                orgAcc = this.orgAccountDao.getAccountByNumber(Integer.valueOf(callDto.getSubscriberNumber().intValue()), new String[0]);
                if (orgAcc != null) {
                    callDto.setSubscriberUserId(orgAcc.getId().longValue());
                }
            } else {
                user = this.userDao.getByNumber(callDto.getSubscriberNumber(), new String[]{"id"});
                if (user != null) {
                    callDto.setSubscriberUserId(user.getId());
                }
            }
        }
        if (callDto.getCalledUserId() == null || !callDto.getCalledUserId().equals(ANONYMOUS_USER_ID) && callDto.getCalledUserId() <= 0L) {
            Preconditions.checkArgument((callDto.getCalledUserNumber() != null && callDto.getCalledUserNumber() > 0L ? 1 : 0) != 0, (Object)"subscriber user id or user number can not both be null");
            if (PartyCallType.getOrgCalledType().contains(callDto.getCallType())) {
                orgAcc = this.orgAccountDao.getAccountByNumber(Integer.valueOf(callDto.getSubscriberNumber().intValue()), new String[0]);
                if (orgAcc != null) {
                    callDto.setCalledUserId(orgAcc.getId().longValue());
                }
            } else {
                user = this.userDao.getByNumber(callDto.getSubscriberNumber(), new String[]{"id"});
                if (user != null) {
                    callDto.setCalledUserId(user.getId());
                }
            }
        }
    }

    @Override
    public BidirectionalCallResponse bidirectionalCall(MakeCallDto callDto) {
        this.fillCallAndSubscriberId(callDto);
        this.fillSubcriberMobile(callDto);
        this.validDuration(callDto.getSubscriberUserId().intValue());
        CallServiceInfo callServiceInfo = new CallServiceInfo();
        callServiceInfo.setCallSubscriber(callDto.getSubscriberUserId());
        callServiceInfo.setCalledParty(callDto.getCalledUserId());
        callServiceInfo.setCallSubscriberNum(callDto.getSubscriberMobile());
        callServiceInfo.setCalledPartyNum(callDto.getCalledUserMobile());
        callServiceInfo.setStatus(Integer.valueOf(-2));
        callServiceInfo.setCreateTime(new Date());
        callServiceInfo.setMonth(DateUtil.getCurrentYM());
        callServiceInfo.setCallType(Integer.valueOf(PartyCallType.O2S.getCode()));
        this.callServiceInfoDao.save((Object)callServiceInfo, new String[0]);
        BidirectionalCallResponse res = new BidirectionalCallResponse();
        res.setCallId(callServiceInfo.getId());
        try {
            RLBiCallResponse rlRes = RLCallHelper.bidirectionalCall(callServiceInfo.getId().toString(), callDto.getSubscriberMobile(), callDto.getCalledUserMobile());
            res.setCallres(true);
            res.setSubscriberDisplayMobile(PropertiesReader.getValue((String)"callservice", (String)RLCallHelper.FROM_DISPLAY));
            callServiceInfo.setStatus(Integer.valueOf(-1));
            callServiceInfo.setUniqueId(rlRes.getCallSid());
            this.callServiceInfoDao.update((Object)callServiceInfo, new String[0]);
        }
        catch (Exception e) {
            log.error("bidirectionalCall error!callDto:{}", (Object)callDto, (Object)e);
            res.setCallres(false);
            callServiceInfo.setStatus(Integer.valueOf(0));
            this.callServiceInfoDao.update((Object)callServiceInfo, new String[0]);
        }
        return res;
    }

    private void validDuration(int orgId) {
        Integer currentDuration = this.callServiceInfoDao.getTotalDurationByOrgId(Integer.valueOf(orgId));
        if (currentDuration > 60000) {
            throw new BussinessException((UniverseErrorCode)CallServiceErrorCode.TIME_EXHAUSTED);
        }
    }

    private void fillSubcriberMobile(MakeCallDto callDto) {
        if (StringUtils.isBlank((CharSequence)callDto.getSubscriberMobile())) {
            String mobile = null;
            OrgTxtMsg orgTxtMsg = this.orgTxtMsgDao.getOrgTxtById(callDto.getSubscriberUserId().intValue());
            if (orgTxtMsg != null && orgTxtMsg.getAuditstatus() != null && orgTxtMsg.getAuditstatus() == 1) {
                mobile = orgTxtMsg.getValue();
                mobile = ParamValidateUtils.filterInvalidateTel((String)mobile);
            }
            if (StringUtils.isBlank(mobile)) {
                OrgAccount account = this.orgAccountDao.getAccountById(callDto.getSubscriberUserId().intValue(), new String[0]);
                mobile = account.getMobile();
            }
            callDto.setSubscriberMobile(mobile);
        }
    }

    @Override
    public String bidirectionalCallRecord(CallbackRecordRequest dto) {
        CallServiceInfo info;
        if (dto != null && NumberUtils.isNumber((String)dto.getCallerCdr().getUserData()) && (info = (CallServiceInfo)this.callServiceInfoDao.getById((Serializable)Long.valueOf(dto.getCallerCdr().getUserData()), new String[0])) != null) {
            log.info("update bidirectionalCall info:" + ToStringBuilder.reflectionToString((Object)info));
            Long callId = Long.valueOf(dto.getCallerCdr().getUserData());
            if (info.getUniqueId().equals(dto.getCallerCdr().getCallSid())) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
                try {
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getCallerCdr().getBeginCallTime()})) {
                        info.setCallStart(sdf.parse(dto.getCallerCdr().getBeginCallTime()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)dto.getCallerCdr().getEndtime())) {
                        info.setCallEnd(sdf.parse(dto.getCallerCdr().getEndtime()));
                    }
                    info.setUpdateTime(new Date());
                }
                catch (ParseException e) {
                    log.error("trans bidirectionalCall time error!", (Throwable)e);
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getCallerCdr().getDuration())) {
                    info.setDuration(Integer.valueOf(dto.getCallerCdr().getDuration()).intValue());
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getCallerCdr().getByetype())) {
                    info.setCdrStatus(RLCallStatus.getCdrStatus((String)dto.getCallerCdr().getByetype()));
                    info.setResult(Integer.valueOf(dto.getCallerCdr().getByetype()));
                }
                this.callServiceInfoDao.update((Object)info, new String[0]);
            }
            this.consulterFollowRecordQueue.putMessage(new Message("1$" + info.getId()));
            CallServiceDialBack callServiceDialBack = new CallServiceDialBack();
            callServiceDialBack.setFromMobile(info.getCallSubscriberNum());
            callServiceDialBack.setToMobile(info.getCalledPartyNum());
            callServiceDialBack.setCallStart(info.getCallStart());
            callServiceDialBack.setCallEnd(info.getCallEnd());
            callServiceDialBack.setDuration(info.getDuration());
            callServiceDialBack.setStart(info.getCallStart());
            callServiceDialBack.setCallType(Integer.valueOf(PartyCallType.O2S.getCode()));
            callServiceDialBack.setUniqueId(info.getUniqueId());
            callServiceDialBack.setCdrStatus(info.getCdrStatus());
            this.callServiceDialBackDao.save((Object)callServiceDialBack, new String[0]);
            if (this.downloadFileQueue != null) {
                if (StringUtils.isNotBlank((CharSequence)dto.getRecordurl())) {
                    MnsMessageBodyDto messageBody = new MnsMessageBodyDto(MnsMessageBodyDto.MnsCallType.RL.getCode(), info.getUniqueId(), dto.getRecordurl(), info.getCallType().toString());
                    try {
                        log.info("send download msg :{} to mns", (Object)messageBody);
                        this.downloadFileQueue.putMessage(new Message(JacksonUtil.obj2Str((Object)messageBody)));
                    }
                    catch (ClientException | ServiceException e) {
                        log.error("send download record msg catch error:{},callInfo:{}", (Object)e, (Object)info);
                        log.error("send download record msg catch error:{},request:{}", (Object)e, (Object)dto);
                    }
                    catch (Exception e) {
                        log.error("send download record msg catch error:{},callInfo:{}", (Object)e, (Object)info);
                        log.error("send download record msg catch error:{},request:{}", (Object)e, (Object)dto);
                    }
                } else {
                    log.info("recordurl is null! calledCdr:{},callServiceInfo:{}", (Object)dto, (Object)info);
                }
            }
        }
        return "000000";
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cloudAccount != null) {
            Properties mnsProperties = PropertiesReader.getProperties((String)"mns.properties");
            this.downloadFileQueue = this.cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("call.recordfile.download.queue"));
            this.consulterFollowRecordQueue = this.cloudAccount.getMNSClient().getQueueRef(mnsProperties.getProperty("consulter.followrecord.queue"));
        } else {
            log.warn("init cloud account error.");
        }
    }

    @Override
    public void cancelBidirectionalCall(String callId) {
        CallServiceInfo callServiceInfo = (CallServiceInfo)this.callServiceInfoDao.getById((Serializable)Long.valueOf(callId), new String[0]);
        if (callServiceInfo != null) {
            RLCallHelper.cancelBidirectionalCall(callServiceInfo.getUniqueId());
        }
    }
}

