/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.callservice.service.impl;

import com.baijia.tianxiao.dal.callservice.constant.PartyCallType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.callservice.dto.CallServiceResponse;
import com.baijia.tianxiao.sal.callservice.dto.MakeCallDto;
import com.baijia.tianxiao.sal.callservice.service.CallService;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CallServiceImpl
implements CallService {
    private static final Logger log = LoggerFactory.getLogger(CallServiceImpl.class);
    @Resource
    private UserDao userDao;
    @Resource
    private OrgAccountDao orgAccountDao;

    @Override
    public boolean callParty(MakeCallDto callDto) {
        this.fillCallAndSubscriberId(callDto);
        Preconditions.checkArgument((callDto.getSubscriberUserId() != null ? 1 : 0) != 0, (Object)"subscriber user id or user number can not be null");
        Preconditions.checkArgument((callDto.getCalledUserId() != null ? 1 : 0) != 0, (Object)"called user id or user number can not be null");
        long timeStamp = System.currentTimeMillis();
        Properties callserviceProp = PropertiesReader.getProperties((String)"callservice.properties");
        String secStr = callDto.getCalledUserId().toString() + callDto.getSubscriberUserId().toString() + timeStamp + callserviceProp.getProperty("callservice.secure.key", "bjhl_ddte3782Jskgwd278");
        HashMap params = Maps.newHashMap();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callDto.getSubscriberMobile()})) {
            secStr = secStr + callDto.getSubscriberMobile();
            params.put("subscriberNumber", callDto.getSubscriberMobile());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{callDto.getCalledUserMobile()})) {
            secStr = secStr + callDto.getCalledUserMobile();
            params.put("calledPartyMobile", callDto.getCalledUserMobile());
        }
        String sign = DigestUtils.md5Hex((String)secStr);
        params.put("sign", sign);
        params.put("timeStamp", timeStamp + "");
        params.put("callType", "4");
        params.put("calledParty", callDto.getCalledUserId().toString());
        params.put("callSubscriber", callDto.getSubscriberUserId().toString());
        String url = callserviceProp.getProperty("callservice.makecall.url");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url}), (Object)("url is illegal:" + url));
        try {
            log.info("callParty.url:{}, params:{}", (Object)url, (Object)params);
            String resp = HttpClientUtils.doGet((String)url, (Map)params);
            log.info("callParty.resp:{}", (Object)resp);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{resp})) {
                CallServiceResponse response = (CallServiceResponse)JacksonUtil.str2Obj((String)resp, CallServiceResponse.class);
                if (response.getStatus() != 200) {
                    log.warn("make call error:{}", (Object)response.getError());
                    return false;
                }
                log.info("success submit call party request to url:{},params:{},resp:{}", new Object[]{url, params, resp});
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.warn("call party catch error,params:{},url:{},error:{}", new Object[]{params, url, e});
            return false;
        }
    }

    private void fillCallAndSubscriberId(MakeCallDto callDto) {
        User user;
        OrgAccount orgAcc;
        if (callDto.getSubscriberUserId() == null || callDto.getSubscriberUserId() <= 0L) {
            Preconditions.checkArgument((callDto.getSubscriberNumber() != null && callDto.getSubscriberNumber() > 0L ? 1 : 0) != 0, (Object)"subscriber user id or user number can not both be null");
            if (PartyCallType.getOrgSubsriberType().contains(callDto.getCallType())) {
                orgAcc = this.orgAccountDao.getAccountByNumber(Integer.valueOf(callDto.getSubscriberNumber().intValue()), new String[0]);
                if (orgAcc != null) {
                    callDto.setSubscriberUserId(orgAcc.getId().longValue());
                }
            } else {
                user = this.userDao.getByNumber(callDto.getSubscriberNumber(), new String[]{"id"});
                if (user != null) {
                    callDto.setSubscriberUserId(user.getId());
                }
            }
        }
        if (callDto.getCalledUserId() == null || !callDto.getCalledUserId().equals(ANONYMOUS_USER_ID) && callDto.getCalledUserId() <= 0L) {
            Preconditions.checkArgument((callDto.getCalledUserNumber() != null && callDto.getCalledUserNumber() > 0L ? 1 : 0) != 0, (Object)"subscriber user id or user number can not both be null");
            if (PartyCallType.getOrgCalledType().contains(callDto.getCallType())) {
                orgAcc = this.orgAccountDao.getAccountByNumber(Integer.valueOf(callDto.getSubscriberNumber().intValue()), new String[0]);
                if (orgAcc != null) {
                    callDto.setCalledUserId(orgAcc.getId().longValue());
                }
            } else {
                user = this.userDao.getByNumber(callDto.getSubscriberNumber(), new String[]{"id"});
                if (user != null) {
                    callDto.setCalledUserId(user.getId());
                }
            }
        }
    }
}

