package com.baijia.tianxiao.dal.advisory.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.advisory.constant.AdvisoryType;
import com.baijia.tianxiao.dal.advisory.dao.OrgStudentAdvisoryDao;
import com.baijia.tianxiao.dal.advisory.po.OrgStudentAdvisory;
import com.baijia.tianxiao.dal.advisory.service.AdvisoryService;
import com.baijia.tianxiao.dal.course.dao.TeacherClassCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherClassCourse;
import com.baijia.tianxiao.dal.dto.response.AdvisoryInfoDto;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.sync.constant.AdvisoryStatus;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class AdvisoryServiceImpl implements AdvisoryService {

    @Resource
    private OrgStudentAdvisoryDao orgStudentAdvisoryDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private StudentDao studentDao;

    @Resource
    private UserDao userDao;

    @Resource
    private TeacherClassCourseDao teacherClassCourseDao;

    @Resource
    private OrgAccountDao orgAccountDao;
    
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;

    @Override
    public List<AdvisoryInfoDto> getAdvisoryInfos(Long minId, Date latestDate, int size) {
        log.info("query advisory infos by minId:{},lastDate:{}", minId, latestDate);
        List<OrgStudentAdvisory> orgStudentAdvisorys = orgStudentAdvisoryDao.getAdvisoryListByMinId(minId, latestDate, size);
        
        return _getAdvisoryInfo(orgStudentAdvisorys);
    }
    
    
    @Override
	public List<AdvisoryInfoDto> getAdvisoryInfos(List<Long> advisoryIds) {
    	log.info("query advisory infos by advisoryIds:{}", advisoryIds);
    	if(advisoryIds==null || advisoryIds.isEmpty()){
    		return new ArrayList<AdvisoryInfoDto>();
    	}
        List<OrgStudentAdvisory> orgStudentAdvisorys = orgStudentAdvisoryDao.getByIds(advisoryIds);
        
        return _getAdvisoryInfo(orgStudentAdvisorys);
	}
    
    
    private List<AdvisoryInfoDto> _getAdvisoryInfo(List<OrgStudentAdvisory> orgStudentAdvisorys){
    	List<AdvisoryInfoDto> advisoryInfoDtos = Lists.newArrayList();
    	
    	Map<Long, Long> orgNumberMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orgStudentAdvisorys)) {
            Collection<Integer> orgIds =
                CollectorUtil.collect(orgStudentAdvisorys, new Function<OrgStudentAdvisory, Integer>() {
                    public Integer apply(OrgStudentAdvisory input) {
                        return input.getOrgId().intValue();
                    }
                });
            List<OrgAccount> accList = this.orgAccountDao.getByIds(orgIds, "id", "number");
            orgNumberMap = CollectorUtil.collectMap(accList, new Function<OrgAccount, Long>() {
                public Long apply(OrgAccount input) {
                    return input.getId().longValue();
                }
            }, new Function<OrgAccount, Long>() {
                public Long apply(OrgAccount input) {
                    return input.getNumber().longValue();
                }
            });
        }
        
        Map<Long, TeacherClassCourse> teacherClassCourseMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(orgStudentAdvisorys)) {
            Set<Long> studentIdsTmp = Sets.newHashSet();
            Set<Long> courseIdSets = Sets.newHashSet();
            Set<String> mobiles = Sets.newHashSet();
            for (OrgStudentAdvisory orgStudentAdvisory : orgStudentAdvisorys) {
                if (orgStudentAdvisory.getStudentId().longValue() > 0) {
                    studentIdsTmp.add(orgStudentAdvisory.getStudentId().longValue());
                } else {
                    mobiles.add(orgStudentAdvisory.getMobile());
                }
                courseIdSets.add(orgStudentAdvisory.getCourseId());
            }
            Map<Long, String> nameMap = this.studentDao.getStudentNameMap(studentIdsTmp);

            List<User> users = Lists.newArrayList();
            users.addAll(this.userDao.getByIds(studentIdsTmp, "id", "mobile", "number"));
            users.addAll(this.userDao.getByMobiles(mobiles, "id", "mobile", "number"));

            Map<Long, OrgCourse> courseMap = this.orgCourseDao.getOrgCourseMap(courseIdSets);
            List<TeacherClassCourse> classCourses = this.teacherClassCourseDao.getByIds(courseIdSets);
            for (TeacherClassCourse teacherClassCourse : classCourses) {
                teacherClassCourseMap.put(teacherClassCourse.getId(), teacherClassCourse);
            }
            buildAdvisoryInfos(advisoryInfoDtos, orgStudentAdvisorys, nameMap, users, courseMap, teacherClassCourseMap,
                orgNumberMap);
        }
        
        return advisoryInfoDtos;
    }
    

    private void buildAdvisoryInfos(List<AdvisoryInfoDto> advisoryInfoDtos,
        List<OrgStudentAdvisory> orgStudentAdvisorys, Map<Long, String> nameMap, List<User> userList,
        Map<Long, OrgCourse> courseMap, Map<Long, TeacherClassCourse> teacherClassCourseMap,
        Map<Long, Long> orgNumberMap) {
        if (CollectionUtils.isNotEmpty(orgStudentAdvisorys)) {
            Map<String, User> userMap = Maps.newHashMap();
            Map<Long, User> userIdMap = Maps.newHashMap();
            for (User user : userList) {
                userMap.put(user.getMobile(), user);
                userIdMap.put(user.getId(), user);
            }

            User user = null;
            for (OrgStudentAdvisory orgStudentAdvisory : orgStudentAdvisorys) {
                AdvisoryInfoDto advisoryInfoDto = new AdvisoryInfoDto();
                buildAdvisoryInfoDto(advisoryInfoDto, orgStudentAdvisory,
                    orgNumberMap.get(orgStudentAdvisory.getOrgId()));
                advisoryInfoDto.setOrgId(orgStudentAdvisory.getOrgId());
                if(orgStudentAdvisory.getStudentId() > 0){
                	user = userIdMap.get(orgStudentAdvisory.getStudentId());
                }else{
                	OrgStudent student = orgStudentDao.getStudentByMobileAndOrgId(orgStudentAdvisory.getOrgId(), orgStudentAdvisory.getMobile());
                	if(student!=null && student.getUserId()>0){
                		user = userDao.getById(student.getUserId());
                	}else{
                		List<TxConsultUser> consulters = txConsultUserDao.lookByMobile(orgStudentAdvisory.getOrgId(), orgStudentAdvisory.getMobile());
                		if(CollectionUtils.isNotEmpty(consulters)){
                            user = userDao.getById(consulters.get(0).getUserId());
                		}
                	}
                	
                	//user = userMap.get(orgStudentAdvisory.getMobile());
                }
//                user = orgStudentAdvisory.getStudentId() > 0 ? userIdMap.get(orgStudentAdvisory.getStudentId())
//                    : userMap.get(orgStudentAdvisory.getMobile());
                if (user != null) {
                    advisoryInfoDto.setUserNumber(user.getNumber());
                    advisoryInfoDto.setStudentId(user.getId());
                }
                String studentName = orgStudentAdvisory.getRealname();
                if (StringUtils.isBlank(studentName)) {
                    studentName = nameMap.get(orgStudentAdvisory.getStudentId().longValue());
                }
                advisoryInfoDto.setStudentName(StringUtils.isBlank(studentName) ? TianXiaoConstant.APPOINTMENT_STUDENT_NAME : studentName);
                if (StringUtils.isEmpty(orgStudentAdvisory.getMobile().trim())) {
                    String mobile = user != null ? user.getMobile() : "-";
                    // if (StringUtils.isEmpty(studentName)) {
                    // advisoryInfoDto.setStudentName(MaskUtil.maskMobile(mobile));
                    // } else {
                    advisoryInfoDto.setStudentMobile(mobile);
                    // }
                } else {
                    advisoryInfoDto.setStudentMobile(orgStudentAdvisory.getMobile());
                }
                OrgCourse course = courseMap.get(orgStudentAdvisory.getCourseId());
                if (course != null) {
                    advisoryInfoDto.setCourseName(course.getName());
                    advisoryInfoDto.setCourseNumber(course.getNumber());
                }
                if (advisoryInfoDto.getAdvisoryType().equals(AdvisoryType.CLASS_COURSE_ADVISORY.getCode())) {
                    TeacherClassCourse classCourse =
                        teacherClassCourseMap.get(orgStudentAdvisory.getCourseId().longValue());
                    if (classCourse != null) {
                        advisoryInfoDto.setClassCourseNumber(classCourse.getNumber());
                        advisoryInfoDto.setCourseName(classCourse.getName());
                    }
                } else if (advisoryInfoDto.getAdvisoryType().equals(AdvisoryType.ORG_ADVISORY.getCode())) {
                    advisoryInfoDto.setCourseName(AdvisoryType.ORG_ADVISORY.getNote());
                }
                advisoryInfoDto.setWords(orgStudentAdvisory.getWords());
                advisoryInfoDtos.add(advisoryInfoDto);
            }
        }
    }

    private void buildAdvisoryInfoDto(AdvisoryInfoDto advisoryInfoDto, OrgStudentAdvisory orgStudentAdvisory,
        Long orgNumber) {
        advisoryInfoDto.setOrgNumber(orgNumber);
        advisoryInfoDto.setAdvisoryId(orgStudentAdvisory.getId());
        advisoryInfoDto.setAdvisoryStatusEnum(AdvisoryStatus.getTypeByCode(orgStudentAdvisory.getStatus()));
        if (orgStudentAdvisory.getContentType().equals(AdvisoryType.TRIAL_COURSE.getTable())) {
            advisoryInfoDto.setAdvisotryTypeEnum(AdvisoryType.getTypeByCode(orgStudentAdvisory.getAdvisoryType()));
        } else {
            advisoryInfoDto.setAdvisotryTypeEnum(AdvisoryType.getTypeByCode(orgStudentAdvisory.getContentType()));
        }
        advisoryInfoDto.setCreateTime(orgStudentAdvisory.getCreateTime());
        advisoryInfoDto.setCourseId(orgStudentAdvisory.getCourseId());
    }

	
}
