/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.ExcelHelper;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailSendExecutor;
import com.baijia.tianxiao.sal.marketing.commons.utils.MailUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Session;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityMailSender {
    private static final Logger log = LoggerFactory.getLogger(ActivityMailSender.class);

    public static Mail createMail(String email, String from, String subject, String content) {
        log.info("begin to create mail !");
        Mail mail = new Mail();
        from = GenericsUtils.isNullOrEmpty((Object)from) ? ConstantEnums.MAILBOX_FROM.value() : from;
        mail.setFrom(from);
        mail.setContent(content);
        mail.addToAddress(email);
        mail.setSubject(subject);
        log.info("mail is : " + ToStringBuilder.reflectionToString((Object)mail));
        return mail;
    }

    public static Mail addAttache(Mail mail, List<Map<String, String>> rows, String ... attacheFileName) {
        try {
            String filename = null;
            filename = GenericsUtils.notNullAndEmpty((Object)attacheFileName) ? attacheFileName[0] : DateUtil.getStrByDate((Date)new Date()) + ".xls";
            File file = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
            if (file == null) {
                return mail;
            }
            log.info("ATTACH FILE  path is : {}", (Object)file.getAbsolutePath());
            mail.addAttachFile(file);
        }
        catch (Exception e) {
            log.error("error :", (Throwable)e);
        }
        return mail;
    }

    public static void sendMail(String email, final Mail mail, final Boolean ... needClean) {
        System.out.println("begin to send mail ");
        MailSendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    System.out.println("begin to send mail !");
                    String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession(host, username, password) : MailUtils.createSession(host);
                    MailUtils.send(session, mail);
                    log.info("send successful");
                    System.out.println("send successful");
                }
                catch (Exception ex) {
                    log.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (GenericsUtils.notNullAndEmpty((Object)needClean) && needClean[0].booleanValue()) {
                        mail.clean();
                    }
                }
            }
        });
    }

    public static void sendMail(String email, final Mail mail, final String host, final String username, final String password, final Boolean ... needClean) {
        MailSendExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession(host, username, password) : MailUtils.createSession(host);
                    MailUtils.send(session, mail);
                    log.info("send successful");
                }
                catch (Exception ex) {
                    log.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (GenericsUtils.notNullAndEmpty((Object)needClean) && needClean[0].booleanValue()) {
                        mail.clean();
                    }
                }
            }
        });
    }

    public static void sendMail(final String email, final String subject, final String content, final Long activityId, final List<Map<String, String>> rows) {
        System.out.println("begin to send mail ");
        MailSendExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File reportFile = null;
                try {
                    String password;
                    String username;
                    String host;
                    Mail mail;
                    block11: {
                        System.out.println("begin to send mail !");
                        mail = new Mail();
                        String from = ConstantEnums.MAILBOX_FROM.value();
                        host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                        username = ConstantEnums.MAILBOX_USERNAME.value();
                        password = ConstantEnums.MAILBOX_PASSWORD.value();
                        mail.setFrom(from);
                        mail.setContent(content);
                        mail.addToAddress(email);
                        mail.setSubject(subject);
                        System.out.println("mail is : " + ToStringBuilder.reflectionToString((Object)mail));
                        String filename = activityId + "_" + DateUtil.getStrByDate((Date)new Date()) + ".xls";
                        reportFile = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
                        if (reportFile != null) break block11;
                        return;
                    }
                    try {
                        log.info("PARTAKE FILE  path is : {}", (Object)reportFile.getAbsolutePath());
                        if (reportFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(reportFile.getName());
                            fileAttach.setFile(reportFile);
                            fileAttach.setFileName(reportFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    }
                    catch (Exception e) {
                        log.error("error :", (Throwable)e);
                    }
                    Session session = null;
                    session = GenericsUtils.notNullAndEmpty((Object)username) && GenericsUtils.notNullAndEmpty((Object)password) ? MailUtils.createSession(host, username, password) : MailUtils.createSession(host);
                    MailUtils.send(session, mail);
                    log.info("send successful");
                    System.out.println("send successful");
                }
                catch (Exception ex) {
                    log.error("can not send email cause by {}", (Throwable)ex);
                }
                finally {
                    if (reportFile != null) {
                        reportFile.delete();
                    }
                }
            }
        });
    }
}

