/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.TemplateTypeDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.TemplateType;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.marketing.activity.dto.TemplateDto;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.dtos.TxActivityCommonFilterParams;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.TemplateService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    public final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private TemplateTypeDao templateTypeDao;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public List<TemplateDto> getTemplateByTypeId(int typeId, TemplateTypeCategory category, PageInfo page) {
        HashSet<Integer> typeIds = new HashSet<Integer>();
        Map<Integer, TemplateType> typeMap = new HashMap();
        if (typeId < 1) {
            List typeList = this.templateTypeDao.selectTemplateTypeListByCategory(category.getType());
            for (TemplateType type : typeList) {
                typeMap.put(type.getTypeId(), type);
                typeIds.add(type.getTypeId());
            }
        } else {
            typeIds.add(typeId);
            typeMap = this.templateTypeDao.selectTypeByIds(typeIds);
        }
        List templateList = this.templateDao.selectTemplateListByTypeId(typeIds, page);
        ArrayList<TemplateDto> dtoList = new ArrayList<TemplateDto>();
        for (Template template : templateList) {
            TemplateDto dto = TemplateDto.getInstance(template);
            dto.setUrl(Config.DOMAIN + template.getUrl());
            dto.setDesc(template.getActivityDesc());
            dtoList.add(dto);
        }
        this.logger.info("[Debug] typeMap=" + typeMap);
        for (TemplateDto dto : dtoList) {
            dto.setInitial(((TemplateType)typeMap.get(dto.getTypeId())).getFlag());
            dto.setUrl(dto.getUrl() + "#!/");
        }
        return dtoList;
    }

    @PostConstruct
    public void init() {
        List templateList = this.templateDao.selectTemplateList();
        if (templateList != null && templateList.size() > 0) {
            HashSet<Integer> ids = new HashSet<Integer>();
            for (Template template : templateList) {
                ids.add(template.getTypeId());
                TemplateConstant.getMap().put(template.getTemplateId(), template);
            }
            Map templateTypeMap = this.templateTypeDao.selectTypeByIds(ids);
            for (Template template : templateList) {
                ((Template)TemplateConstant.getMap().get(template.getTemplateId())).setType((TemplateType)templateTypeMap.get(template.getTypeId()));
            }
        }
        this.logger.info("[Init template]=" + TemplateConstant.getMap());
    }

    @Override
    public List<TemplateDto> getTemplateDtoListByCondition(TxActivityCommonFilterParams filterParams, PageDto pageDto, Integer orgId, Integer cascadeId) {
        List<Integer> typeIds = new ArrayList<Integer>();
        Map typeMap = new HashMap();
        Integer templateType = filterParams.getTemplateType();
        if (templateType == null) {
            typeIds = TemplateTypeCategory.getTypeIdList();
        } else {
            typeIds.add(TemplateTypeCategory.getTemplateTypeCategoryByType(templateType).getTypeId());
        }
        log.info("[ActivityMerge] typeIds param:{}", typeIds);
        typeMap = this.templateTypeDao.selectTypeByIds(typeIds);
        log.info("[Template] orgId:{}, cascadeId:{}", (Object)orgId, (Object)cascadeId);
        TxAccountPermissionsDto permissions = this.permissionService.universalGetPermissions(orgId.intValue(), cascadeId);
        HashMap<Long, Integer> map = new HashMap<Long, Integer>();
        if (permissions != null && permissions.getAPPps() != null && permissions.getAPPps().size() > 0) {
            for (TxAccountPermissionsDto.AccountPermissionDto permissionDto : permissions.getAPPps()) {
                map.put(permissionDto.getPCode(), permissionDto.getPType());
            }
        }
        TXAccount txAccount = this.txAccountService.getTXAccountByOrgId(orgId, new String[0]);
        Integer vipLevel = null;
        if (txAccount != null) {
            vipLevel = txAccount.getVipLevel();
        }
        log.info("[Template] vipLevel:{}", (Object)vipLevel);
        List templateList = this.templateDao.getTemplateListByCondition(typeIds, pageDto, filterParams.getIsSortedByPopular());
        ArrayList<TemplateDto> permissionTemplateList = new ArrayList<TemplateDto>();
        ArrayList<TemplateDto> noPermissionTemplateList = new ArrayList<TemplateDto>();
        if (templateList != null && templateList.size() > 0) {
            for (Template template : templateList) {
                TemplateDto dto = TemplateDto.getInstance(template);
                dto.setUrl(Config.DOMAIN + template.getUrl() + "#!/");
                dto.setDesc(template.getActivityDesc());
                dto.setInitial(((TemplateType)typeMap.get(dto.getTypeId())).getFlag());
                TemplateTypeCategory category = TemplateTypeCategory.getTemplateTypeCategoryByTypeId(dto.getTypeId());
                String templateTypeStr = category.getLabel();
                dto.setTemplateType(category.getType());
                dto.setVipLevel(vipLevel);
                dto.setPromotionIconUrl(this.getPromotionIconUrl(vipLevel, template));
                String titleFormat = "[%s] %s";
                String title = String.format(titleFormat, templateTypeStr, template.getName());
                dto.setTitle(title);
                long pCode = category.getPCode();
                if (vipLevel == TXAccountType.DAZHONG.getCode() && map.get(pCode) != null && (Integer)map.get(pCode) == 1) {
                    dto.setHasPermition(0);
                    noPermissionTemplateList.add(dto);
                    continue;
                }
                dto.setHasPermition(1);
                permissionTemplateList.add(dto);
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        permissionTemplateList.addAll(noPermissionTemplateList);
        return permissionTemplateList;
    }

    private String getPromotionIconUrl(Integer vipLevel, Template template) {
        String promotionIconUrl = "";
        if (StringUtils.isNotBlank((CharSequence)template.getVipLevel())) {
            Integer vipProxy;
            List<String> vipLevelList = Arrays.asList(template.getVipLevel().split(","));
            Integer n = vipProxy = TXAccountType.getPaySet().contains(TXAccountType.getTXAccountTypeByCode((Integer)vipLevel)) ? TXAccountType.BAIJIN.getCode() : vipLevel;
            if (vipLevelList.contains(vipProxy.toString())) {
                promotionIconUrl = template.getPromotionIconUrl();
            }
        }
        return promotionIconUrl;
    }

    public static void main(String[] args) {
        Integer vipProxy = TXAccountType.getPaySet().contains(1) ? TXAccountType.BAIJIN.getCode() : 10;
        System.out.println(TXAccountType.getPaySet().contains(TXAccountType.getTXAccountTypeByCode((Integer)1)));
    }
}

