/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.article.dto;

import com.baijia.tianxiao.dal.activity.po.ArticleDetail;
import com.baijia.tianxiao.sal.marketing.article.dto.ArticleBaseDto;
import com.baijia.tianxiao.sal.marketing.article.utils.ArticleUtil;
import com.baijia.tianxiao.sal.marketing.article.utils.QrCodeUtil;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import java.sql.Timestamp;
import java.util.Date;

public class ArticleDetailDto
extends ArticleBaseDto {
    private int source;
    private String content;
    private String author;
    private String translator;
    private Timestamp publicTime;
    private String digest;
    private String originUrl;
    private String orgLogo;
    private String orgName;
    private String orgQrCodeUrl;
    private String orgHomeUrl;
    private String orgWeiPage;
    private String orgHomeQrCodeUrl;

    public static ArticleDetailDto buildDto(ArticleDetail detail) {
        ArticleDetailDto articleDto = new ArticleDetailDto();
        articleDto.setTitle(detail.getArticleTitle());
        articleDto.setSource(1);
        articleDto.setOriginUrl(detail.getArticleUrl());
        articleDto.setThumbNail(detail.getArticleImg());
        articleDto.setArticleId(detail.getId());
        articleDto.setContent(QrCodeUtil.replaceWechatImgUrl(detail.getContent()));
        articleDto.setPublicTime(new Timestamp(new Date().getTime()));
        articleDto.setDigest(ArticleUtil.getDigest(detail.getContent()));
        return articleDto;
    }

    public void setOrgInfo(OrgInfoSimpleDto orgInfo) {
        this.orgLogo = orgInfo.getLogo();
        this.orgName = orgInfo.getShortName();
    }

    public int getSource() {
        return this.source;
    }

    public String getContent() {
        return this.content;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTranslator() {
        return this.translator;
    }

    public Timestamp getPublicTime() {
        return this.publicTime;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public String getOrgLogo() {
        return this.orgLogo;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getOrgQrCodeUrl() {
        return this.orgQrCodeUrl;
    }

    public String getOrgHomeUrl() {
        return this.orgHomeUrl;
    }

    public String getOrgWeiPage() {
        return this.orgWeiPage;
    }

    public String getOrgHomeQrCodeUrl() {
        return this.orgHomeQrCodeUrl;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setTranslator(String translator) {
        this.translator = translator;
    }

    public void setPublicTime(Timestamp publicTime) {
        this.publicTime = publicTime;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    public void setOrgLogo(String orgLogo) {
        this.orgLogo = orgLogo;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setOrgQrCodeUrl(String orgQrCodeUrl) {
        this.orgQrCodeUrl = orgQrCodeUrl;
    }

    public void setOrgHomeUrl(String orgHomeUrl) {
        this.orgHomeUrl = orgHomeUrl;
    }

    public void setOrgWeiPage(String orgWeiPage) {
        this.orgWeiPage = orgWeiPage;
    }

    public void setOrgHomeQrCodeUrl(String orgHomeQrCodeUrl) {
        this.orgHomeQrCodeUrl = orgHomeQrCodeUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArticleDetailDto)) {
            return false;
        }
        ArticleDetailDto other = (ArticleDetailDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSource() != other.getSource()) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$translator = this.getTranslator();
        String other$translator = other.getTranslator();
        if (this$translator == null ? other$translator != null : !this$translator.equals(other$translator)) {
            return false;
        }
        Timestamp this$publicTime = this.getPublicTime();
        Timestamp other$publicTime = other.getPublicTime();
        if (this$publicTime == null ? other$publicTime != null : !((Object)this$publicTime).equals(other$publicTime)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
            return false;
        }
        String this$originUrl = this.getOriginUrl();
        String other$originUrl = other.getOriginUrl();
        if (this$originUrl == null ? other$originUrl != null : !this$originUrl.equals(other$originUrl)) {
            return false;
        }
        String this$orgLogo = this.getOrgLogo();
        String other$orgLogo = other.getOrgLogo();
        if (this$orgLogo == null ? other$orgLogo != null : !this$orgLogo.equals(other$orgLogo)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$orgQrCodeUrl = this.getOrgQrCodeUrl();
        String other$orgQrCodeUrl = other.getOrgQrCodeUrl();
        if (this$orgQrCodeUrl == null ? other$orgQrCodeUrl != null : !this$orgQrCodeUrl.equals(other$orgQrCodeUrl)) {
            return false;
        }
        String this$orgHomeUrl = this.getOrgHomeUrl();
        String other$orgHomeUrl = other.getOrgHomeUrl();
        if (this$orgHomeUrl == null ? other$orgHomeUrl != null : !this$orgHomeUrl.equals(other$orgHomeUrl)) {
            return false;
        }
        String this$orgWeiPage = this.getOrgWeiPage();
        String other$orgWeiPage = other.getOrgWeiPage();
        if (this$orgWeiPage == null ? other$orgWeiPage != null : !this$orgWeiPage.equals(other$orgWeiPage)) {
            return false;
        }
        String this$orgHomeQrCodeUrl = this.getOrgHomeQrCodeUrl();
        String other$orgHomeQrCodeUrl = other.getOrgHomeQrCodeUrl();
        return !(this$orgHomeQrCodeUrl == null ? other$orgHomeQrCodeUrl != null : !this$orgHomeQrCodeUrl.equals(other$orgHomeQrCodeUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArticleDetailDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSource();
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $translator = this.getTranslator();
        result = result * 59 + ($translator == null ? 43 : $translator.hashCode());
        Timestamp $publicTime = this.getPublicTime();
        result = result * 59 + ($publicTime == null ? 43 : ((Object)$publicTime).hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        String $originUrl = this.getOriginUrl();
        result = result * 59 + ($originUrl == null ? 43 : $originUrl.hashCode());
        String $orgLogo = this.getOrgLogo();
        result = result * 59 + ($orgLogo == null ? 43 : $orgLogo.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $orgQrCodeUrl = this.getOrgQrCodeUrl();
        result = result * 59 + ($orgQrCodeUrl == null ? 43 : $orgQrCodeUrl.hashCode());
        String $orgHomeUrl = this.getOrgHomeUrl();
        result = result * 59 + ($orgHomeUrl == null ? 43 : $orgHomeUrl.hashCode());
        String $orgWeiPage = this.getOrgWeiPage();
        result = result * 59 + ($orgWeiPage == null ? 43 : $orgWeiPage.hashCode());
        String $orgHomeQrCodeUrl = this.getOrgHomeQrCodeUrl();
        result = result * 59 + ($orgHomeQrCodeUrl == null ? 43 : $orgHomeQrCodeUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ArticleDetailDto(source=" + this.getSource() + ", content=" + this.getContent() + ", author=" + this.getAuthor() + ", translator=" + this.getTranslator() + ", publicTime=" + this.getPublicTime() + ", digest=" + this.getDigest() + ", originUrl=" + this.getOriginUrl() + ", orgLogo=" + this.getOrgLogo() + ", orgName=" + this.getOrgName() + ", orgQrCodeUrl=" + this.getOrgQrCodeUrl() + ", orgHomeUrl=" + this.getOrgHomeUrl() + ", orgWeiPage=" + this.getOrgWeiPage() + ", orgHomeQrCodeUrl=" + this.getOrgHomeQrCodeUrl() + ")";
    }
}

