/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.smsGroupSend.dto;

import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.StudentDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsGroupSendRequest {
    private static final Logger log = LoggerFactory.getLogger(SmsGroupSendRequest.class);
    public static final Integer NOT_ALL = 0;
    public static final Integer IS_ALL = 1;
    public static final String splitSymbol = "\u3001";
    private Long recordId;
    private String studentIds;
    private String courseIds;
    private Integer studentStatus = 0;
    private Integer courseStatus = 0;
    private String content;
    private Long orgId;
    private Long cascadeId;
    private PageDto pageDto;
    private List<Long> studentIdList = Lists.newArrayList();
    private List<Long> courseIdList = Lists.newArrayList();
    private boolean needDistinct;

    public void setStudentIds(String studentIds) {
        this.studentIds = studentIds;
        if (GenericsUtils.notNullAndEmpty((Object)studentIds)) {
            this.studentIdList.addAll(this.getIdsFromString(studentIds));
        }
    }

    public void setCourseIds(String courseIds) {
        this.courseIds = courseIds;
        if (GenericsUtils.notNullAndEmpty((Object)courseIds)) {
            this.courseIdList.addAll(this.getIdsFromString(courseIds));
        }
    }

    private List<Long> getIdsFromString(String idsStr) {
        log.debug("idStr is : {} ", (Object)idsStr);
        String[] ids = idsStr.split(",");
        ArrayList idList = Lists.newArrayListWithCapacity((int)ids.length);
        for (String idStr : ids) {
            try {
                idList.add(Long.parseLong(idStr));
            }
            catch (NumberFormatException e) {
                log.debug("error whhile parseLong from str: {} ", (Object)idStr);
            }
        }
        return idList;
    }

    public boolean isAllStudent() {
        return this.studentStatus != NOT_ALL;
    }

    public boolean isAllCourse() {
        return this.courseStatus != NOT_ALL;
    }

    public void checkParams() {
        if (GenericsUtils.isNullOrEmpty(this.studentIdList) && !this.isAllStudent() && GenericsUtils.isNullOrEmpty(this.courseIdList) && !this.isAllCourse()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u9009\u5b9a\u4efb\u4f55\u5b66\u5458");
        }
    }

    public SmsGroupSendRecord buildPo(List<StudentDto> studentDtos) {
        if (GenericsUtils.isNullOrEmpty(studentDtos)) {
            return null;
        }
        Timestamp nowTimestamp = new Timestamp(new Date().getTime());
        SmsGroupSendRecord record = new SmsGroupSendRecord();
        record.setOrgId(this.orgId);
        record.setContent(this.content);
        record.setId(this.recordId);
        record.setCreateCascadeId(this.cascadeId);
        record.setCreateTime(nowTimestamp);
        record.setUpdateTime(nowTimestamp);
        record.setSendStatus(SendStatus.WAIT_TO_SEND.code.intValue());
        String allReceivers = SmsGroupSendRequest.extractReceivers(studentDtos);
        record.setAllReceiver(allReceivers);
        record.setTotalCount(studentDtos.size());
        return record;
    }

    public static String extractReceivers(List<StudentDto> studentDtos) {
        StringBuilder sb = new StringBuilder();
        for (StudentDto sd : studentDtos) {
            sb.append(sd.getId()).append(",");
        }
        String allReceivers = GenericsUtils.deleteLastCharToString((StringBuilder)sb);
        return allReceivers;
    }

    public static String extractReceiverNames(List<StudentDto> studentDtos) {
        StringBuilder sb = new StringBuilder();
        for (StudentDto sd : studentDtos) {
            sb.append(sd.getName()).append(splitSymbol);
        }
        String allReceivers = GenericsUtils.deleteLastCharToString((StringBuilder)sb);
        return allReceivers;
    }

    public Long getRecordId() {
        return this.recordId;
    }

    public String getStudentIds() {
        return this.studentIds;
    }

    public String getCourseIds() {
        return this.courseIds;
    }

    public Integer getStudentStatus() {
        return this.studentStatus;
    }

    public Integer getCourseStatus() {
        return this.courseStatus;
    }

    public String getContent() {
        return this.content;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getCascadeId() {
        return this.cascadeId;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public List<Long> getStudentIdList() {
        return this.studentIdList;
    }

    public List<Long> getCourseIdList() {
        return this.courseIdList;
    }

    public boolean isNeedDistinct() {
        return this.needDistinct;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public void setStudentStatus(Integer studentStatus) {
        this.studentStatus = studentStatus;
    }

    public void setCourseStatus(Integer courseStatus) {
        this.courseStatus = courseStatus;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setCascadeId(Long cascadeId) {
        this.cascadeId = cascadeId;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setStudentIdList(List<Long> studentIdList) {
        this.studentIdList = studentIdList;
    }

    public void setCourseIdList(List<Long> courseIdList) {
        this.courseIdList = courseIdList;
    }

    public void setNeedDistinct(boolean needDistinct) {
        this.needDistinct = needDistinct;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmsGroupSendRequest)) {
            return false;
        }
        SmsGroupSendRequest other = (SmsGroupSendRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$recordId = this.getRecordId();
        Long other$recordId = other.getRecordId();
        if (this$recordId == null ? other$recordId != null : !((Object)this$recordId).equals(other$recordId)) {
            return false;
        }
        String this$studentIds = this.getStudentIds();
        String other$studentIds = other.getStudentIds();
        if (this$studentIds == null ? other$studentIds != null : !this$studentIds.equals(other$studentIds)) {
            return false;
        }
        String this$courseIds = this.getCourseIds();
        String other$courseIds = other.getCourseIds();
        if (this$courseIds == null ? other$courseIds != null : !this$courseIds.equals(other$courseIds)) {
            return false;
        }
        Integer this$studentStatus = this.getStudentStatus();
        Integer other$studentStatus = other.getStudentStatus();
        if (this$studentStatus == null ? other$studentStatus != null : !((Object)this$studentStatus).equals(other$studentStatus)) {
            return false;
        }
        Integer this$courseStatus = this.getCourseStatus();
        Integer other$courseStatus = other.getCourseStatus();
        if (this$courseStatus == null ? other$courseStatus != null : !((Object)this$courseStatus).equals(other$courseStatus)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$cascadeId = this.getCascadeId();
        Long other$cascadeId = other.getCascadeId();
        if (this$cascadeId == null ? other$cascadeId != null : !((Object)this$cascadeId).equals(other$cascadeId)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        List<Long> this$studentIdList = this.getStudentIdList();
        List<Long> other$studentIdList = other.getStudentIdList();
        if (this$studentIdList == null ? other$studentIdList != null : !((Object)this$studentIdList).equals(other$studentIdList)) {
            return false;
        }
        List<Long> this$courseIdList = this.getCourseIdList();
        List<Long> other$courseIdList = other.getCourseIdList();
        if (this$courseIdList == null ? other$courseIdList != null : !((Object)this$courseIdList).equals(other$courseIdList)) {
            return false;
        }
        return this.isNeedDistinct() == other.isNeedDistinct();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmsGroupSendRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $recordId = this.getRecordId();
        result = result * 59 + ($recordId == null ? 43 : ((Object)$recordId).hashCode());
        String $studentIds = this.getStudentIds();
        result = result * 59 + ($studentIds == null ? 43 : $studentIds.hashCode());
        String $courseIds = this.getCourseIds();
        result = result * 59 + ($courseIds == null ? 43 : $courseIds.hashCode());
        Integer $studentStatus = this.getStudentStatus();
        result = result * 59 + ($studentStatus == null ? 43 : ((Object)$studentStatus).hashCode());
        Integer $courseStatus = this.getCourseStatus();
        result = result * 59 + ($courseStatus == null ? 43 : ((Object)$courseStatus).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $cascadeId = this.getCascadeId();
        result = result * 59 + ($cascadeId == null ? 43 : ((Object)$cascadeId).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        List<Long> $studentIdList = this.getStudentIdList();
        result = result * 59 + ($studentIdList == null ? 43 : ((Object)$studentIdList).hashCode());
        List<Long> $courseIdList = this.getCourseIdList();
        result = result * 59 + ($courseIdList == null ? 43 : ((Object)$courseIdList).hashCode());
        result = result * 59 + (this.isNeedDistinct() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SmsGroupSendRequest(recordId=" + this.getRecordId() + ", studentIds=" + this.getStudentIds() + ", courseIds=" + this.getCourseIds() + ", studentStatus=" + this.getStudentStatus() + ", courseStatus=" + this.getCourseStatus() + ", content=" + this.getContent() + ", orgId=" + this.getOrgId() + ", cascadeId=" + this.getCascadeId() + ", pageDto=" + this.getPageDto() + ", studentIdList=" + this.getStudentIdList() + ", courseIdList=" + this.getCourseIdList() + ", needDistinct=" + this.isNeedDistinct() + ")";
    }
}

