/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.commons.utils.AttachBean;
import com.baijia.tianxiao.sal.marketing.commons.utils.Mail;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailUtils {
    public static Session createSession(String host, final String username, final String password) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", host);
        prop.setProperty("mail.smtp.auth", "true");
        Authenticator auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
        return Session.getInstance((Properties)prop, (Authenticator)auth);
    }

    public static Session createSession(String host) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", host);
        prop.setProperty("mail.smtp,auth", "false");
        return Session.getInstance((Properties)prop);
    }

    public static void send(Session session, Mail mail) throws MessagingException, IOException {
        String bcc;
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(mail.getFrom()));
        msg.addRecipients(Message.RecipientType.TO, mail.getToAddress());
        String cc = mail.getCcAddress();
        if (!cc.isEmpty()) {
            msg.addRecipients(Message.RecipientType.CC, cc);
        }
        if (!(bcc = mail.getBccAddress()).isEmpty()) {
            msg.addRecipients(Message.RecipientType.BCC, bcc);
        }
        msg.setSubject(MimeUtility.encodeText((String)mail.getSubject(), (String)"UTF-8", (String)"B"));
        MimeMultipart parts = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        part.setContent((Object)mail.getContent(), "text/html;charset=utf-8");
        parts.addBodyPart((BodyPart)part);
        List<AttachBean> attachBeanList = mail.getAttachs();
        if (attachBeanList != null) {
            for (AttachBean attach : attachBeanList) {
                MimeBodyPart attachPart = new MimeBodyPart();
                attachPart.attachFile(attach.getFile());
                attachPart.setFileName(MimeUtility.encodeText((String)attach.getFileName()));
                String cid = attach.getCid();
                if (cid != null) {
                    attachPart.setContentID(cid);
                }
                parts.addBodyPart((BodyPart)attachPart);
            }
        }
        msg.setContent((Multipart)parts);
        Transport.send((Message)msg);
    }
}

