package com.baijia.tianxiao.sal.marketing.referral.service.impl;

import com.baijia.tianxiao.dal.activity.constants.CommonConstant;
import com.baijia.tianxiao.dal.activity.dao.TemplateDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.dao.referral.GiftInfoDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.sal.marketing.commons.enums.DeleteStatus;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralBaseInfo;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralRequest;
import com.baijia.tianxiao.sal.marketing.referral.dto.ReferralResponse;
import com.baijia.tianxiao.sal.marketing.referral.service.GiftService;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralService;
import com.baijia.tianxiao.sal.marketing.referral.service.ReferralStatisticsService;
import com.baijia.tianxiao.util.GenericsUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 4:04:24 PM
 * @desc :
 */
@Service
@Slf4j
public class ReferralServiceImpl implements ReferralService {

    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private GiftService giftService;
    @Autowired
    private ReferralStatisticsService referralStatisticsService;
    @Autowired
    private GiftInfoDao giftInfoDao;
    @Autowired
    private TxActivityCommonDao txActivityCommonDao;
    @Autowired
    private TxActivityCommonService txActivityCommonService;

    @Override
    @Transactional("yunyingTransactionManager")
    public ReferralResponse addActivity(ReferralRequest request) {
        // Long orgId = request.getOrgId();
        ReferralInfo ri = request.buildPo();
        log.info("find referralInfo :{}", ri);
        if (ri == null) {
            return null;
        }
        ri.setTemplateTypeId(CommonConstant.REFERRAL_ACTIVITY_TYPE_ID);
        ri.setStatus(1);
        if (GenericsUtils.isNullOrEmpty(ri.getTopPicUrl())) {
            ri.setTopPicUrl(ConstantEnums.REFERRAL_DEFAULT_TOP_PIC.value());
        }
        ri.setTemplateTypeId(CommonConstant.REFERRAL_ACTIVITY_TYPE_ID);
        
        //判断机构类型 如果是免费版，需要判断机构已经创建活动的个数
        this.txActivityCommonService.checkoutOrgActivityVipLevelAndAmount(request.getOrgId());
        Long activityId = this.referralInfoDao.saveReferral(ri);
        
        //将数据同步到tx_activity_conf中
        TxActivityCommon conf = new TxActivityCommon();
        txActivityCommonService.saveOrUpdateTxActivityCommon(conf, TemplateTypeCategory.REFERRAL_TYPE, ri, null);
        log.info("[Referral] save success and ret activityId is :{}, save success txActivtyConf", activityId, conf);
        
        List<GiftInfo> gifts = request.buildGiftInfos(activityId);
        templateDao.updateTemplateUseCount(request.getTemplateId().longValue());
        log.info("templateUserCount is update success");
        giftService.batchAdd(activityId, gifts);
        request.setActivityId(activityId);
        return this.findDetail(request);
    }
    
    @Override
    public ReferralResponse findDetail(ReferralRequest request) {
        ReferralInfo info = this.referralInfoDao.getReferralInfo(request.getActivityId(), request.getOrgId(), null);
        if (info == null) {
            return null;
        }
        // if (GenericsUtils.isNullOrEmpty(info.getTopPicUrl())) {
        // info.setTopPicUrl(ConstantEnums.REFERRAL_TOP_PIC_URL.value());
        // }
        List<GiftInfo> gifts = this.giftService.findGifts(request.getActivityId());
        ReferralResponse response = ReferralResponse.buildResponse(info, gifts);
        statistics(Arrays.asList((ReferralBaseInfo) response));
        return response;
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public boolean modifyStatus(ReferralRequest request) {
        ReferralInfo info = this.referralInfoDao.getReferralInfo(request.getActivityId(), request.getOrgId());
        if (info != null) {
            info.setStatus(request.getStatus());
            info.setUpdateTime(new Timestamp(new Date().getTime()));
            this.referralInfoDao.updateReferral(info);
            
            //同步到tx_activity_conf中
            TxActivityCommon conf = txActivityCommonDao.getTxActivityCommon(info.getOrgId(), info.getTemplateTypeId(), info.getActivityId());
            conf.setStatus(request.getStatus());
            conf.setUpdateTime(new Date());
            
            txActivityCommonService.saveOrUpdateTxActivityCommon(conf, null, null, null, "status", "updateTime");
            return true;
        }
        return false;
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public ReferralResponse modifyActivity(ReferralRequest request) {
        ReferralInfo ri = request.buildPo();
        Long activityId = request.getActivityId();
        ri.setOrgId(request.getOrgId());
        Timestamp time = new Timestamp(new Date().getTime());
        ri.setUpdateTime(time);
        List<GiftInfo> gifts = request.buildGiftInfos();
        Set<Long> existsIds = new HashSet<>();
        if (GenericsUtils.notNullAndEmpty(gifts)) {
            List<GiftInfo> newGifts = new ArrayList<>();
            for (GiftInfo gi : gifts) {
                Long id = gi.getId();
                if (id == null || id == 0) {
                    gi.setActivityId(activityId);
                    gi.setCreateTime(time);
                    gi.setStatus(1);
                    gi.setUpdateTime(time);
                    newGifts.add(gi);
                } else {
                    existsIds.add(id);
                    gi.setUpdateTime(time);
                    gi.setStatus(1);
                    this.giftInfoDao.updateGifts(Arrays.asList(gi));
                }
            }
            log.info("existsIds are : {} ", existsIds);
            log.info("new giftInfos are :{} ", newGifts);
            this.giftService.deleteGifts(activityId, new ArrayList<>(existsIds));
            this.giftService.batchAdd(activityId, newGifts);
        }
        this.referralInfoDao.updateReferral(ri);
        //将数据更新到tx_activity_conf中
        TxActivityCommon conf = txActivityCommonDao.getTxActivityCommon(ri.getOrgId(), TemplateTypeCategory.REFERRAL_TYPE.getTypeId(), ri.getActivityId());
        log.info("[Referral] conf:{}, referralInfo:{}", conf, ri);
        txActivityCommonService.saveOrUpdateTxActivityCommon(conf, TemplateTypeCategory.REFERRAL_TYPE, ri, null);
        return this.findDetail(request);
    }

    @Override
    public List<ReferralBaseInfo> listActivitys(ReferralRequest request, PageInfo pageInfo) {
        Integer status = request.getStatus();
        Long orgId = request.getOrgId();
        List<ReferralInfo> listReferrals = this.referralInfoDao.listReferrals(status, orgId, pageInfo);
        if (GenericsUtils.isNullOrEmpty(listReferrals)) {
            return Collections.emptyList();
        }
        List<ReferralBaseInfo> rbis = new ArrayList<>(listReferrals.size());
        for (ReferralInfo ri : listReferrals) {
            ReferralBaseInfo rbi = ReferralBaseInfo.buildDto(ri);
            rbis.add(rbi);
        }
        statistics(rbis);
        return rbis;
    }

    /**
     * 
     * @param rbis
     */
    private void statistics(List<ReferralBaseInfo> rbis) {
        if (GenericsUtils.isNullOrEmpty(rbis)) {
            return;
        }
        this.referralStatisticsService.setStatistics(rbis);
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public void deleteActivity(Long activityId, Long orgId) {
        // 获取活动
        ReferralInfo referralInfo = this.referralInfoDao.getReferralInfo(activityId, orgId);

        if (referralInfo != null) {
            ReferralInfo updateInfo = new ReferralInfo();
            updateInfo.setActivityId(activityId);
            updateInfo.setOrgId(orgId);
            updateInfo.setDelStatus(1);
            updateInfo.setUpdateTime(new Timestamp(new Date().getTime()));
            referralInfoDao.updateReferral(updateInfo);
            
            //同步tx_activity_conf
            TxActivityCommon conf = txActivityCommonDao.getTxActivityCommon(orgId, referralInfo.getTemplateTypeId(), activityId);
            conf.setDelStatus(DeleteStatus.IS_DELETE.getCode());
            conf.setUpdateTime(new Date());
            txActivityCommonService.saveOrUpdateTxActivityCommon(conf, null, null, null, "delStatus", "updateTime");
            log.info("[referral] delete status set success confId:{}", conf.getId());
        } else {
            log.warn("[Draw] draw is not exist or delete.drawId=" + activityId);
        }

    }
}
