package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.sal.marketing.commons.utils.MnsUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.dal.activity.dto.PageInfo;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.draw.Winner;
import com.baijia.tianxiao.sal.marketing.commons.dtos.MnsDrawDto;
import com.baijia.tianxiao.sal.marketing.commons.service.mq.MqService;
import com.baijia.tianxiao.sal.marketing.commons.utils.TupleUtil;
import com.baijia.tianxiao.sal.marketing.commons.utils.TwoTuple;
import com.baijia.tianxiao.sal.marketing.draw.dto.WinnerDto;
import com.baijia.tianxiao.sal.marketing.draw.service.WinnerService;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

/**
 * Created by liuxp on 16/1/26.
 */
@Service
@Slf4j
public class WinnerServiceImpl implements WinnerService {

    @Autowired
    private WinnerDao winnerDao;
    @Autowired
    private MqService mqService;
    @Autowired
    private DrawActivityDao drawActivityDao;

    @Override
    public List<Winner> getWinnerList(long activityId, PageInfo pageInfo) {
        List<Winner> winners = winnerDao.selectWinnerListByPage(activityId, pageInfo);
        if (GenericsUtils.isNullOrEmpty(winners)) {
            return Collections.emptyList();
        }
        for (Winner winner : winners) {
            String username = winner.getName();
            String mobile = winner.getMobile();
            String userInfo = winner.getUserInfo();
            TwoTuple<String, String> retInfo = retrievalUserInfo(username, mobile, userInfo);
            winner.setName(retInfo.first);
            winner.setMobile(retInfo.second);
        }
        return winners;
    }

    private TwoTuple<String, String> retrievalUserInfo(String username, String mobile, String userInfo) {
        if (GenericsUtils.isNullOrEmpty(username) || GenericsUtils.isNullOrEmpty(mobile)) {
            if (GenericsUtils.isNullOrEmpty(userInfo)) {
                return TupleUtil.tuple(username, mobile);
            }
            JSONObject fromObject = JSONObject.fromObject(userInfo);
            String name = fromObject.getString("name");
            String userMobile = fromObject.getString("mobile");
            username = GenericsUtils.isNullOrEmpty(username) ? name : username;
            mobile = GenericsUtils.isNullOrEmpty(mobile) ? userMobile : mobile;
        }
        return TupleUtil.tuple(username, mobile);
    }

    @Override
    public List<WinnerDto> getWinnerDtoList(long activityId, PageInfo pageInfo) {
        List<Winner> winners = winnerDao.selectWinnerListByPage(activityId, pageInfo);
        List<WinnerDto> dtos = new ArrayList<>(winners.size());
        for (Winner winner : winners) {
            dtos.add(WinnerDto.getDto(winner));
        }
        return dtos;
    }

    @Override
    public void addCheckInInfo(Winner winner) {
        Winner oldWinner = winnerDao.selectWinnerById(winner.getDrawId());
        if (oldWinner == null) {
            log.warn("[CheckInInfo] Winner is not existed.{}", winner);
            return;
        }
        if (StringUtils.isNotBlank(oldWinner.getMobile())) {
            log.warn("[CheckInInfo] The prize was checked.{}", winner);
            return;
        }

        DrawInfo info = drawActivityDao.getDrawInfoDetail(oldWinner.getActivityId(), null);
        oldWinner.setName(winner.getName());
        oldWinner.setMobile(winner.getMobile());
        mqService.pushMns(MnsDrawDto.getInstance(info, oldWinner), MnsUtils.getPrefix());
        winnerDao.updateCheckInInfo(winner);
    }
}
