/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.WinnerDao;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawStatisticData;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawDataExportService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年4月23日
 * @desc
 */
@Service
public class DrawDataExportServiceImpl implements DrawDataExportService {
    @Autowired
    DrawActivityDao drawActivityDao;
    @Autowired
    ActivityUserDao activityUserDao;
    @Autowired
    WinnerDao winnerDao;

    @Override
    public Map<Long, DrawStatisticData> getDrawData(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        Map<Long, DrawStatisticData> activityDatas = new HashMap<>();
        // 查询使用发活动的机构
        List<Long> orgIds = drawActivityDao.getExistOrgIds(TianxiaoOrgIds);
        if (orgIds == null || orgIds.size() == 0) {
            return activityDatas;
        }

        Map<Long, List<Long>> activityIdsOfOrgId = this.drawActivityDao.getDrawActivitysByIds(orgIds, null, null);
        Map<Long, List<Long>> activityIdsOfOrgIdByDay =
                this.drawActivityDao.getDrawActivitysByIds(orgIds, startTime, endTime);

        for (Long orgId : orgIds) {
            DrawStatisticData drawStatisticData = new DrawStatisticData();
            Integer drawActivityTotal;
            if (activityIdsOfOrgIdByDay.get(orgId) != null) {
                drawActivityTotal = activityIdsOfOrgIdByDay.get(orgId).size();
            } else {
                drawActivityTotal = 0;
            }
            List<Long> activityIds = activityIdsOfOrgId.get(orgId);

            Integer drawUserTotal = this.activityUserDao.getUserTotal(activityIds,
                    TemplateTypeCategory.DRAW_TYPE.getType(), startTime, endTime);
            Integer drawWinnerTotal = this.winnerDao.getWinnerTotal(activityIds, startTime, endTime);

            drawStatisticData.setDrawActivityTotal(drawActivityTotal == null ? 0 : drawActivityTotal);
            drawStatisticData.setWinnerCount(drawWinnerTotal == null ? 0 : drawWinnerTotal);
            drawStatisticData.setUserCount(drawUserTotal == null ? 0 : drawUserTotal);

            activityDatas.put(orgId, drawStatisticData);
        }

        return activityDatas;
    }

}
