
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.article.enums;

import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 9, 2016
 * @desc
 */
public enum TouTiaoArticleEnum {

    //推荐
    //RECOMMEND(0,ArticleTypes.RECOMMEND, "推荐"),
    //热点
//    HOTPOINT(1,ArticleTypes.HOTARTICLE,"热点"), //
    //雅思,中小学,四六级,考研
    GAOKAO(2,ArticleTypes.EDUCATION,"高考"),//
    YIKAO(3,ArticleTypes.EDUCATION,"艺考"),//
    YIASI(4,ArticleTypes.EDUCATION,"雅思"),//
    ZHONGXIAOXUE(5,ArticleTypes.EDUCATION,"中小学"),
    SILIUJI(6,ArticleTypes.EDUCATION,"四六级"),//
    KAOYAN(7,ArticleTypes.EDUCATION,"考研"), //
    //领导力,产品运营,口才,财会考试,创业
    LINGDAOLI(8,ArticleTypes.CAREER,"领导力"),
    CHANPINGYUNYING(9,ArticleTypes.CAREER,"产品运营"),//
    KOUCAI(10,ArticleTypes.CAREER,"口才"),
    CAIHUIKAOSHI(11,ArticleTypes.CAREER,"财会考试"),//
    CHUANGYE(12,ArticleTypes.CAREER,"创业"),//
    //摄影,设计
    SHEYING(14,ArticleTypes.CREATIVE,"摄影"),
    SHEJI(15,ArticleTypes.CREATIVE,"设计"),//
    //校花,美食,理财,段子,美妆,体育
    XIAOHUA(16,ArticleTypes.LIFE,"校花"),//
    MEISHI(17,ArticleTypes.LIFE,"美食"),
    LICAI(18,ArticleTypes.LIFE,"理财"),
    DUANZI(19,ArticleTypes.LIFE,"段子"),
    MEIZHUANG(20,ArticleTypes.LIFE,"美妆"),
    TIYU(21,ArticleTypes.LIFE,"体育"),
    //情感
    QINGGAN(22,ArticleTypes.EMOTION,"情感"),
    //旅游
    LVXING(23,ArticleTypes.TRAVEL,"旅游"),
    //亲子
    //QINGZI(24,ArticleTypes.PARENTING,"亲子"),
    //文化
    MEIWEN(25,ArticleTypes.CULTURE,"美文"),
    //其它 TODO
    ;
    

    public ArticleTypes articleType; //对应的文章分类
    public Integer typeId; //对应请求头条服务器的文章分类的id
    public String desc; //对应的文章类型描述(原头条的分类)

    private TouTiaoArticleEnum(Integer typeId , ArticleTypes articleType, String desc) {
        this.typeId = typeId;
        this.articleType = articleType;
        this.desc = desc;
    }
    
    private static Map<Integer,String> typeCache = new HashMap<>();
    private static Map<String,Integer> categoryMap = Maps.newHashMap();
    
    static{
        for(TouTiaoArticleEnum type : TouTiaoArticleEnum.values()){
            typeCache.put(type.typeId, type.desc);
            categoryMap.put(type.desc , type.articleType.code);
        }
    }
    
    public static List<String> getTypeDescs(){
        return new ArrayList<>(typeCache.values());
    }
    
    public static Integer getCategory(String desc){
        Integer category = categoryMap.get(desc);
        if(category == null){
//            return ArticleTypes.OTHERS.code;
        }
        return category;
    }

}
