/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.article.dto;

import com.baijia.tianxiao.dal.activity.po.ArticleBaseInfo;
import com.baijia.tianxiao.sal.marketing.article.utils.UrlUtil;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.utils.StringHelper;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年3月16日
 * @desc
 */
@Data
public class HotArticleDto extends ArticleBaseDto {
    private String articleId;
    private String introduction;
    private String accessNum;
    private String supportNum;
    private String originUrl;
    private String detailUrl;

    // 根据Mongodb中数据获取对象
    public static HotArticleDto getFromArticleBaseInfo(ArticleBaseInfo articleInfo) {
        HotArticleDto hotArticleDto = new HotArticleDto();

        hotArticleDto.setArticleId(articleInfo.getId());
        hotArticleDto.setAccessNum(articleInfo.getVisitCount().toString());
        hotArticleDto.setOriginUrl(articleInfo.getArticleUrl());
        hotArticleDto.setSupportNum(articleInfo.getThumbUpCount().toString());
        String imgUrl = articleInfo.getArticleImg();
        if (GenericsUtils.notNullAndEmpty(imgUrl)) {
            if (!imgUrl.startsWith(Config.IMAGE_SERVER_HOST)) {
                imgUrl = Config.getResourceProxyUrl(imgUrl);
            }
        }
        hotArticleDto.setThumbNail(imgUrl);
        hotArticleDto.setTitle(articleInfo.getArticleTitle());
        hotArticleDto.setDetailUrl(UrlUtil.getH5Url(hotArticleDto.getArticleId()));
        hotArticleDto.setIntroduction(StringHelper.subString(articleInfo.getAbstractContent(), 20));
        return hotArticleDto;
    }

}
