package com.baijia.tianxiao.sal.marketing.vote.dto;

import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;

import org.springframework.beans.BeanUtils;

import java.util.List;

import lombok.Data;

/**
 * Created by liuxp on 16/2/20.
 */
@Data
public class VoteRenderDto extends VoteInfoDto {
    private String orgName;
    private String orgLogo;
    private Long orgId;
    private Long orgNumber;
    private List<VoteOptionDto> voteOptions;

    private String orgWeiPage; // 微官网连接

    public static VoteRenderDto getInstance(VoteInfo info) {
        VoteRenderDto dto = new VoteRenderDto();
        BeanUtils.copyProperties(info, dto, "startTime", "endTime");
        dto.setStartTime(info.getStartTime().getTime());
        dto.setEndTime(info.getEndTime().getTime());
        return dto;
    }
}
