package com.baijia.tianxiao.sal.marketing.vote.dto;

import java.io.Serializable;

import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Feb 22, 2016 5:00:44 PM
 * @desc :
 */
@Data
public class VoteCacheDto implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private Long startTime; // 当前活动开始时间戳
    private Long endTime;// 活动结束时间
    private Long orgId;// 活动所属的机构
    private int templateId;// 活动模板ID
    private int status = 1;
    private int countLimit;
    private int isVotedByDay;
    private int infoFillStatus;

    public static VoteCacheDto getInstanceByVoteInfo(VoteInfo voteInfo) {
        VoteCacheDto vcd = new VoteCacheDto();
        vcd.setStartTime(voteInfo.getStartTime().getTime());
        vcd.setEndTime(voteInfo.getEndTime().getTime());
        vcd.setStatus(voteInfo.getStatus());
        vcd.setTemplateId(voteInfo.getTemplateId());
        vcd.setOrgId(voteInfo.getOrgId());
        int voteLimit = voteInfo.getCountLimit();
        int isVotedByDay = voteInfo.getIsVotedByDay();
        vcd.setCountLimit(voteLimit);
        vcd.setIsVotedByDay(isVotedByDay);
        vcd.setInfoFillStatus(voteInfo.getInfoFillStatus());
        return vcd;
    }

}
