package com.baijia.tianxiao.sal.marketing.referral.dto;

import com.baijia.tianxiao.dal.activity.po.referral.GiftInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;

import org.springframework.beans.BeanUtils;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author Rezar
 * @createDate :Mar 2, 2016 3:59:18 PM
 * @desc :
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class ReferralResponse extends ReferralBaseInfo {

    private String orgName;
    private String orgLogo;
    private Long orgNumber;
    private String orgQrCodeUrl;
    private String shareUrl;
    private String url;
    private String orgWeiPage;  //微官网连接
    private List<GiftInfo> gifts;

    public static ReferralResponse buildResponse(ReferralInfo ri, List<GiftInfo> gifts) {
        ReferralResponse rr = new ReferralResponse();
        BeanUtils.copyProperties(ri, rr, "startTime", "endTime", "createTime", "updateTime");
        rr.setUpdateTime(ri.getUpdateTime().getTime());
        rr.setCreateTime(ri.getCreateTime().getTime());
        rr.setStartTime(ri.getStartTime().getTime());
        rr.setEndTime(ri.getEndTime().getTime());

        String url = Config.DOMAIN + "/referral.html?activityId=" + ri.getActivityId();
        rr.setUrl(url + "#!/");

        rr.setShareUrl(url);
        rr.setDelStatus(ri.getDelStatus());

        rr.setGifts(gifts);
        ReferralBaseInfo.checkStatus(ri, rr);
        return rr;
    }

}
