/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.referral.dto;

import com.baijia.tianxiao.dal.activity.po.referral.ReferralRecord;

/**
 * @title ReferralBrokerDto
 * @desc Broker dto
 * @author gaodan
 * @date 2016年3月4日
 * @version 1.0
 */
public class BrokerDto {
    private long id;
    private String brokerName;
    private String brokerPhone;
    private int accountType;
    private String accountNum = "0";
    private String headPic;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getBrokerName() {
        return brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getBrokerPhone() {
        return brokerPhone;
    }

    public void setBrokerPhone(String brokerPhone) {
        this.brokerPhone = brokerPhone;
    }

    public int getAccountType() {
        return accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getHeadPic() {
        return headPic;
    }

    public void setHeadPic(String headPic) {
        this.headPic = headPic;
    }

    // 获取实例
    public static BrokerDto getInstance(ReferralRecord broker) {
        BrokerDto dto = new BrokerDto();
        dto.setId(broker.getId());
        dto.setBrokerName(broker.getBrokerName());
        dto.setBrokerPhone(broker.getBrokerPhone());
        dto.setAccountType(broker.getAccountType());
        dto.setAccountNum(broker.getAccountNum());
        dto.setHeadPic("");
        return dto;
    }

    /**
     * 暂时只有支付宝
     * 
     * @param type
     * @return
     */
    public static String getBrokerAccDesc(Integer type) {
        switch (type) {
            case 1:
                return "支付宝";
            default:
                return "支付宝";
        }
    }
}
