package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.draw.service.ActivityUserService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

/**
 * Created by liuxp on 16/1/26.
 */
@Service
public class ActivityUserServiceImpl implements ActivityUserService {

    @Autowired
    private ActivityUserDao activityUserDao;

    @Autowired
    private DrawActivityDao drawActivityDao;

    @Override
    public void addActivityUser(ActivityUser activityUser) {
        activityUserDao.insertActivityUser(activityUser);
    }

    @Override
    public List<DairyCountStatistics> getActivityUserStatistics(long activityId, long orgId) {

        List<DairyCountStatistics> list =
            activityUserDao.selectDairyCountStatistics(activityId, TemplateTypeCategory.DRAW_TYPE.getType());

        Map<String, DairyCountStatistics> statisticsMap =
            CollectionUtils.extractMap(list, new CollectionUtils.Extracter<String, DairyCountStatistics>() {
                @Override
                public String extract(DairyCountStatistics dairyCountStatistics) {
                    return dairyCountStatistics.getDate();
                }
            });

        DrawInfo drawInfo = drawActivityDao.getDrawInfoDetail(activityId, orgId);
        if (drawInfo == null) {
            return Collections.emptyList();
        }
        Date endDate = new Date(Math.min(new Date().getTime(), drawInfo.getEndTime().getTime()));
        Date startDate = drawInfo.getStartTime();

        List<DairyCountStatistics> ret = initStatistics(startDate, endDate);

        for (DairyCountStatistics statistics : ret) {
            DairyCountStatistics exist = statisticsMap.get(statistics.getDate());
            if (exist != null) {
                statistics.setCount(exist.getCount());
            }
        }

        return ret;
    }

    @Override
    public List<DairyCountStatistics> getActivityUserStatistics(long activityId, int category, Date startDate,
        Date endDate) {

        List<DairyCountStatistics> list = activityUserDao.selectDairyCountStatisticsWithSingle(activityId, category);

        if (GenericsUtils.isNullOrEmpty(list)) {
            list = new ArrayList<>();
        }

        Map<String, DairyCountStatistics> statisticsMap =
            CollectionUtils.extractMap(list, new CollectionUtils.Extracter<String, DairyCountStatistics>() {
                @Override
                public String extract(DairyCountStatistics dairyCountStatistics) {
                    return dairyCountStatistics.getDate();
                }
            });

        List<DairyCountStatistics> ret = voteInitStatistics();

        for (DairyCountStatistics statistics : ret) {
            DairyCountStatistics exist = statisticsMap.get(statistics.getDate());
            if (exist != null) {
                statistics.setCount(exist.getCount());
            }
        }

        return ret;
    }

    private List<DairyCountStatistics> voteInitStatistics() {
        String datePattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(datePattern);
        List<DairyCountStatistics> dairyList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i <= 30; i++) {
            dairyList.add(new DairyCountStatistics(sdf.format(calendar.getTime()), 0));
            calendar.add(Calendar.DAY_OF_MONTH, -1);
        }
        return dairyList;
    }

    private List<DairyCountStatistics> initStatistics(Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<DairyCountStatistics> statisticsList = new ArrayList<>();
        Calendar start = Calendar.getInstance();
        start.setTime(DateUtil.getStartOfDay(startTime));

        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        end.setTime(DateUtil.getStartOfDay(endTime));

        while (start.compareTo(end) <= 0) {
            statisticsList.add(new DairyCountStatistics(sdf.format(end.getTime()), 0));
            end.add(Calendar.DAY_OF_MONTH, -1);
        }
        return statisticsList;
    }

}
