package com.baijia.tianxiao.sal.marketing.commons.utils;

/**
 * @author Rezar
 * @createDate :Dec 11, 2015 7:50:50 PM
 * @desc :
 */
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class MailUtils {
    public static Session createSession(String host, final String username, final String password) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", host);
        prop.setProperty("mail.smtp.auth", "true");
        prop.setProperty("mail.smtp.connectiontimeout", String.valueOf(6000));

        Authenticator auth = new Authenticator() {
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };
        return Session.getInstance(prop, auth);
    }

    public static Session createSession(String host) {
        Properties prop = new Properties();
        prop.setProperty("mail.host", host);
        prop.setProperty("mail.smtp,auth", "false");
        prop.setProperty("mail.smtp.connectiontimeout", String.valueOf(6000));
        return Session.getInstance(prop);
    }

    public static void send(Session session, final Mail mail) throws MessagingException, IOException {
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom(new InternetAddress(mail.getFrom()));
        msg.addRecipients(Message.RecipientType.TO, mail.getToAddress());

        String cc = mail.getCcAddress();
        if (!cc.isEmpty()) {
            msg.addRecipients(Message.RecipientType.CC, cc);
        }

        String bcc = mail.getBccAddress();
        if (!bcc.isEmpty()) {
            msg.addRecipients(Message.RecipientType.BCC, bcc);
        }

        msg.setSubject(MimeUtility.encodeText(mail.getSubject(), "UTF-8", "B"));

        MimeMultipart parts = new MimeMultipart();

        MimeBodyPart part = new MimeBodyPart();
        part.setContent(mail.getContent(), "text/html;charset=utf-8");
        parts.addBodyPart(part);

        List<AttachBean> attachBeanList = mail.getAttachs();
        if (attachBeanList != null) {
            for (AttachBean attach : attachBeanList) {
                MimeBodyPart attachPart = new MimeBodyPart();
                attachPart.attachFile(attach.getFile());
                attachPart.setFileName(MimeUtility.encodeText(attach.getFileName()));
                String cid = attach.getCid();
                if (cid != null) {
                    attachPart.setContentID(cid);
                }
                parts.addBodyPart(attachPart);
            }
        }
        msg.setContent(parts);

        final Semaphore semaphore = new Semaphore(1, true);
        final AtomicReference<String> status = new AtomicReference<String>(beginToSend);
        try {
            semaphore.acquire();
        } catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            Transport transport = session.getTransport();
            transport.addTransportListener(new TransportListener() {
                @Override
                public void messagePartiallyDelivered(TransportEvent e) {
                    log.info("======mail:{} messagePartiallyDelivered ====== ", mail.toString());
                    // System.out.println("======mail:{} messagePartiallyDelivered ====== " + mail.toString());
                    status.set(partiallyDelivered);
                    semaphore.release();
                }

                @Override
                public void messageNotDelivered(TransportEvent e) {
                    log.info("======mail:{} messageNotDelivered ====== ", mail.toString());
                    // System.out.println("======mail:{} messageNotDelivered ====== " + mail.toString());
                    status.set(notDelivered);
                    semaphore.release();
                }

                @Override
                public void messageDelivered(TransportEvent e) {
                    log.info("======mail:{} messageDelivered ====== ", mail.toString());
                    // System.out.println("======mail:{} messageDelivered ====== " + mail.toString());
                    status.set(delivered);
                    semaphore.release();
                }
            });
            transport.connect();
            transport.sendMessage(msg, msg.getAllRecipients());
            log.info("====send mail OK ===== in try catch ====");
        } catch (Exception e) {
            status.set(notDelivered);
            semaphore.release();
            log.error("mail send failure : {} ", e);
        }
        try {
            log.info("begin to wait semaphore and send status :{} ", status.get());
            // //System.out.println("begin to wait semaphore and send status :{} " + status.get());
            semaphore.acquire();
            if (status.equals(notDelivered)) {
                log.info("send mail:{} failure cause by : {} and will cache it for next time send ", mail.toString(),
                    status);
            }
            log.info(" wait semaphore over ");
            // //System.out.println(" wait semaphore over ");
        } catch (InterruptedException e1) {
            e1.printStackTrace();
        } finally {
            semaphore.release();
        }
    }

    public static final String beginToSend = "BeginToSend";
    public static final String delivered = "Delivered";
    public static final String partiallyDelivered = "PartiallyDelivered";
    public static final String notDelivered = "NotDelivered";

    // Transport.send(msg);
}
