/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.commons.dtos;

import com.baijia.tianxiao.dal.activity.enums.ActivityStatus;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;

import java.util.Date;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年8月22日
 * @desc
 */
@Data
@Slf4j
public class TxActivityMergeDto {
    private Long activityId;    //活动id
    private String title;    //活动名称
    private Integer brouseCount;   //活动访问量
    private long updateTime;   //活动更新时间戳
    
    private Integer templateId;  //模板id
    private Integer templateType;   //活动类型，1：在线报名，2：微信抽奖，3：微信投票，4：转介绍
    private String templateTypeStr;  //活动类型描述
    
    private Integer status;   //活动状态 0：已关闭，1：未开始，2：进行中，3：已结束
    private String statusStr;   //活动状态描述 
    
    public static TxActivityMergeDto buildInstanceByTxAcitivityConf(TxActivityCommon conf, Integer status){
        TxActivityMergeDto dto = new TxActivityMergeDto();
        dto.setActivityId(conf.getActivityId());
        dto.setTitle(conf.getTitle());
        dto.setBrouseCount(conf.getAccessCount());
        dto.setUpdateTime(conf.getUpdateTime().getTime());
        
        dto.setTemplateId(conf.getTemplateId());
        TemplateTypeCategory category = TemplateTypeCategory.getTemplateTypeCategoryByTypeId(conf.getTemplateTypeId());
        if(category != null){
            dto.setTemplateType(category.getType());
            dto.setTemplateTypeStr(category.getLabel());
        }
        
        Date curDate = new Date();
        
        //app端没有传status时，需要展示所有活动 那么活动的状态需要按条件判断
        if(status == null){
            if(conf.getStatus() == ActivityStatus.CLOSED.getCode()){
                status = conf.getStatus();
            }else{
                if(conf.getStartTime().after(curDate)){
                    status = ActivityStatus.UN_START.getCode();
                }else if(conf.getEndTime().before(curDate)){
                    status = ActivityStatus.END.getCode();
                }else{
                    status = ActivityStatus.RUNNING.getCode();
                }
            }
        }
        
        ActivityStatus activityStatus = ActivityStatus.getActivityStatus(status);
        if(activityStatus != null){
            dto.setStatus(status);
            dto.setStatusStr(activityStatus.getDesc());
        }
        
        return dto;
    }
    
}
