/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.article.dto;

import com.baijia.tianxiao.dal.activity.po.article.PicArticleDetailInfo;
import com.baijia.tianxiao.dal.activity.po.article.PicArticleInfo;

import org.springframework.beans.BeanUtils;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年3月19日
 * @desc
 */
@Data
public class ArticleBaseDto {
    private String articleId; // 文章id
    private String title;
    private String thumbNail;//文章的封面图
    private Integer isShowQrCode;//是否显示机构公众号二维码

    public static ArticleBaseDto buildPicArticleDto(PicArticleInfo picArticleInfo) {
        ArticleBaseDto picArticleDto = new ArticleBaseDto();
        BeanUtils.copyProperties(picArticleInfo, picArticleDto);
        return picArticleDto;
    }

    public static ArticleBaseDto buildArticleDtoByPicArticleDetailInfo(PicArticleDetailInfo picArticleDetailInfo) {
        ArticleBaseDto baseDto = new ArticleBaseDto();
        BeanUtils.copyProperties(picArticleDetailInfo, baseDto, "id");
        baseDto.setArticleId(picArticleDetailInfo.getArticleId());
        return baseDto;
    }
}
