package com.baijia.tianxiao.sal.marketing.activity.dto;

import java.text.ParseException;
import java.util.Date;

import org.apache.commons.lang3.time.DateUtils;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.util.date.DateUtil;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/1/11.
 */
@Slf4j
public class ActivityBaseInfo {
    private Long id; // 活动id
    private String name; // 活动主题
    private int browseCount; // 浏览数
    private int enrollCount; // 报名人数
    private int status; // 活动状态
    private Long createTime; // 活动创建时间
    private int templateId;// 模板ID
    private int templateTypeId;// 模板类型id
    private Long updateTime;
    private Integer isDel;

    public Integer getIsDel() {
        return isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
    }

    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public int getTemplateTypeId() {
        return templateTypeId;
    }

    public void setTemplateTypeId(int templateTypeId) {
        this.templateTypeId = templateTypeId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getBrowseCount() {
        return browseCount;
    }

    public void setBrowseCount(int browseCount) {
        this.browseCount = browseCount;
    }

    public int getEnrollCount() {
        return enrollCount;
    }

    public void setEnrollCount(int enrollCount) {
        this.enrollCount = enrollCount;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public int getTemplateId() {
        return templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public static ActivityBaseInfo getInstance(Activity activity, ActivityConf conf) {
        ActivityBaseInfo baseInfo = null;
        if (activity != null && conf != null) {
            baseInfo = new ActivityBaseInfo();
            baseInfo.setId(activity.getId());
            baseInfo.setName(activity.getTitle());
            baseInfo.setStatus(activity.getSwitcher());
            baseInfo.setBrowseCount(activity.getSupportNum());
            if (conf.getEndTime().before(new Date()) && activity.getSwitcher() == 1) {
                baseInfo.setStatus(0);
            } else {
                baseInfo.setStatus(activity.getSwitcher());
            }
            toleranceSetUpdateTime(activity, baseInfo);
            baseInfo.setCreateTime(DateUtil.getStrToDate("yyyy-MM-dd HH:mm:ss", activity.getCreateTime()).getTime());
            try {
                baseInfo.setCreateTime(DateUtils.parseDate(activity.getCreateTime(), "yyyy-MM-dd HH:mm:ss").getTime());
            } catch (ParseException e) {
                log.error("ParseException", e);
                e.printStackTrace();
            }

            baseInfo.setTemplateId(conf.getTemplateId());
            baseInfo.setIsDel(activity.getIsdel());
        }
        return baseInfo;
    }

    public static void toleranceSetUpdateTime(Activity activity, ActivityBaseInfo baseInfo) {
        String formatRight = "yyyy-MM-dd HH:mm:ss";
        String formatWrong = "yyyy-MM-dd,HH:mm:ss";
        try {
            baseInfo.setUpdateTime(DateUtil.getStrToDate(formatRight, activity.getUpdateTime()).getTime());
        } catch (Exception e) {
            baseInfo.setUpdateTime(DateUtil.getStrToDate(formatWrong, activity.getUpdateTime()).getTime());
        }
    }

}
