
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.smsGroupSend.service.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter;
import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsGroupSendRecordDao;
import com.baijia.tianxiao.dal.activity.enums.SendStatus;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.dto.*;
import com.baijia.tianxiao.sal.marketing.smsGroupSend.service.SmsGroupSendService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.TupleUtil;
import com.baijia.tianxiao.util.TwoTuple;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.*;

/**
 * 
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 19, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Service
@Slf4j
public class SmsGroupSendServiceImpl implements SmsGroupSendService {

    @Autowired
    private SmsGroupSendRecordDao smsGroupSendRecordDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgStudentCourseDao orgStudetnCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgStudentApiService studentApiService;
    @Autowired
    private OrgAccountDao orgAccountDao;

    public static final String KEY_FORMAT = "%s:%s";

    // 对用户短信群发记录的缓存 , 如果存在数据的更新，入口最好控制下数据更新
    private LoadingCache<String, SmsGroupSendListDto> records =
        CacheBuilder.newBuilder().maximumSize(2000).build(new CacheLoader<String, SmsGroupSendListDto>() {
            public SmsGroupSendListDto load(String key) throws Exception {
                if (GenericsUtils.isNullOrEmpty(key)) {
                    return null;
                }
                TwoTuple<Long, Long> orgAndRecordIds = extractIds(key);
                log.info("orgId is : {} and recordId is : {} ", orgAndRecordIds.first, orgAndRecordIds.second);

                SmsGroupSendRecord byId =
                    smsGroupSendRecordDao.searchRecordWithOrgId(orgAndRecordIds.second, orgAndRecordIds.first);
                if (byId != null) {
                    List<SmsGroupSendListDto> buildSmsGroupSendListDto =
                        buildSmsGroupSendListDto(Lists.newArrayList(byId));
                    return buildSmsGroupSendListDto.get(0);
                }
                return null;
            }

            private com.baijia.tianxiao.util.TwoTuple<Long, Long> extractIds(String key) {
                String[] orgIdAndRecordId = key.split(":");
                String orgIdStr = orgIdAndRecordId[0];
                String recordIdStr = orgIdAndRecordId[1];
                Long recordId = Long.parseLong(recordIdStr);
                Long orgId = Long.parseLong(orgIdStr);
                return TupleUtil.tuple(orgId, recordId);
            }

            public Map<String, SmsGroupSendListDto> loadAll(Iterable<? extends String> keys) throws Exception {
                if (GenericsUtils.isNullOrEmpty(keys)) {
                    return GenericsUtils.emptyMap();
                }

                Map<Long, List<Long>> orgRecordIds = Maps.newHashMap();
                for (String key : keys) {
                    TwoTuple<Long, Long> extractIds = extractIds(key);
                    if (orgRecordIds.get(extractIds.first) == null) {
                        orgRecordIds.put(extractIds.first, Lists.newArrayList(Arrays.asList(extractIds.second)));
                    } else {
                        orgRecordIds.get(extractIds.first).add(extractIds.second);
                    }
                }

                Map<String, SmsGroupSendListDto> dtoMaps = Maps.newHashMap();
                for (final Long orgId : orgRecordIds.keySet()) {
                    HashSet<Long> newHashSet = Sets.newHashSet(orgRecordIds.get(orgId));
                    List<SmsGroupSendRecord> byIds = smsGroupSendRecordDao.searchRecordsWithOrgId(orgId, newHashSet);
                    List<SmsGroupSendListDto> buildSmsGroupSendListDto = buildSmsGroupSendListDto(byIds);
                    dtoMaps.putAll(CollectionUtils.extractMap(buildSmsGroupSendListDto,
                        new Extracter<String, SmsGroupSendListDto>() {
                            @Override
                            public String extract(SmsGroupSendListDto arg0) {
                                return String.format(KEY_FORMAT, orgId, arg0.getRecordId());
                            }
                        }));
                }
                return dtoMaps;
            }
        });

    /**
     * 获取到当前学员和课程的信息，不用于分页展示数据 </br>
     * 如果recordId 不为null ， 说明是从 【用短信发送】 接口过来的
     * 
     * @return
     */
    @Override
    public SmsGroupSendResp pullStuOrCourseInfos(SmsGroupSendRequest request) {
        log.info("request1 is : {} ", request);
        SmsGroupSendResp resp = new SmsGroupSendResp();
        SmsGroupSendRecord record = null;
        List<StudentDto> studentDtos = null;
        List<CourseDto> courseDtos = null;
        if (request.getRecordId() != null) {
            record = this.smsGroupSendRecordDao.searchRecordWithOrgId(request.getRecordId(), request.getOrgId());
            if (record == null) {
                throw new BussinessException(CommonErrorCode.INVALIDATE_CLIENTID, "当前机构没有该群发记录");
            }
            Long orgId = request.getOrgId();
            request = new SmsGroupSendRequest();
            request.setOrgId(orgId);
            request.setStudentIds(record.getAllReceiver());
            request.setNeedDistinct(true);
            // 查找所有需要显示的学员
            studentDtos = this.getAllStudents(request);
            int limit = Integer.parseInt(GenericsUtils.isNullOrEmpty(Config.LOCAL_BATCH_SEND_COUNT_LIMIT) ? "100"
                : Config.LOCAL_BATCH_SEND_COUNT_LIMIT);
            if (studentDtos.size() > limit) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "本地发送短信接收人过多，建议限制接收人的数量以避免发送时间过长");
            }
        } else {
            // 取少量数据用于短信编辑页面进行数据展示
            PageDto pageDto = new PageDto();
            pageDto.setPageNum(1);
            pageDto.setPageSize(10);
            request.setPageDto(pageDto);
            studentDtos = this.searchStudents(request);
            courseDtos = this.searchCourses(request);
        }
        resp.setCourses(courseDtos);
        resp.setStudents(studentDtos);
        return resp;
    }

    @Override
    public List<StudentDto> getAllStudents(SmsGroupSendRequest request) {
        List<StudentDto> studentDtos = this.searchStudents(request);
        List<StudentDto> courseStus = this.searchStudentsFromCourse(request);
        studentDtos.addAll(courseStus);
        return studentDtos;
    }

    /**
     * @param listAllSmsGroupRecords
     * @return
     */
    protected List<SmsGroupSendListDto> buildSmsGroupSendListDto(List<SmsGroupSendRecord> listAllSmsGroupRecords) {
        if (GenericsUtils.isNullOrEmpty(listAllSmsGroupRecords)) {
            return GenericsUtils.emptyList();
        }
        Long orgId = listAllSmsGroupRecords.get(0).getOrgId();
        List<SmsGroupSendListDto> dtos = Lists.newArrayList();
        for (SmsGroupSendRecord record : listAllSmsGroupRecords) {
            log.info("record is : {} ", record);
            String receivers = record.getAllReceiver();
            SmsGroupSendRequest request = new SmsGroupSendRequest();
            request.setStudentIds(receivers);
            request.setOrgId(orgId);
            List<StudentDto> allNames = this.searchStudents(request);
            SmsGroupSendListDto newInstance = SmsGroupSendListDto.newInstance(record, allNames);
            dtos.add(newInstance);
        }
        return dtos;
    }

    /**
     * @param request
     * @return
     * @Desc 从课程表中查找到相关学员
     * @Inuse
     */
    private List<StudentDto> searchStudentsFromCourse(SmsGroupSendRequest request) {
        List<Long> courseIds = request.getCourseIdList();
        Long orgId = request.getOrgId();

        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (accountById == null) {
            throw new BussinessException(CommonErrorCode.NO_LOGIN, "非法访问");
        }

        final List<Long> noDelCourseIds = Lists.newArrayList();
        final List<OrgCourse> orgCourseList =
            this.orgCourseDao.getOrgCourseList(Arrays.asList(accountById.getNumber()), null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);

        for (OrgCourse orgCourse : orgCourseList) {
            if (orgCourse.getIsDel() == 0) {
                noDelCourseIds.add(orgCourse.getId());
            }
        }
        log.info("noDelCourseIds : {} ", noDelCourseIds);

        Set<Long> filterIds = Sets.newHashSet(courseIds);

        List<OrgStudentCourse> allStudetnIds = this.orgStudetnCourseDao.searchStudentWithCourseIds(orgId, filterIds,
            noDelCourseIds, request.isAllCourse());

        List<Long> studentIds = Lists.newArrayList();
        for (OrgStudentCourse orgStudent : allStudetnIds) {
            studentIds.add(orgStudent.getUserId());
        }
        log.info("studentIds is : {} ", studentIds);

        List<OrgStudent> orgStudents = this.orgStudentDao.getStudentByUserIds(orgId, studentIds, "id", "name", "userId",
            "nickName", "mobile", "avatar");
        log.info("studentPO are : {} ", orgStudents);
        return buildStudentDto(orgStudents, orgId, request.isNeedDistinct());
    }

    /**
     * 
     * @param request
     * @return
     * @Inuse
     */
    private List<CourseDto> searchCourses(SmsGroupSendRequest request) {
        List<Long> courseIds = request.getCourseIdList();
        Long orgId = request.getOrgId();
        Set<Long> filterIds = Sets.newHashSet(courseIds);
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (accountById == null) {
            log.info("can not find orgAccount with orgId : {} ", accountById);
            throw new BussinessException(CommonErrorCode.NO_LOGIN, "当前机构不存在");
        }

        List<OrgCourse> allCourses = this.orgCourseDao.searchCourses(accountById.getNumber().longValue(), filterIds,
            request.isAllCourse(),null,null,null, request.getPageDto());
        if (GenericsUtils.isNullOrEmpty(allCourses)) {
            return GenericsUtils.emptyList();
        }

        List<CourseDto> courseDtos = Lists.newArrayList();
        if (GenericsUtils.notNullAndEmpty(allCourses)) {
            for (OrgCourse orgCourse : allCourses) {
                CourseDto dto = CourseDto.buildDto(orgCourse);
                courseDtos.add(dto);
            }
        }
        return courseDtos;
    }

    /**
     * @return
     * @Desc 从学员表中获取所有的学员
     * @Inuse
     */
    private List<StudentDto> searchStudents(SmsGroupSendRequest request) {
        List<Long> studentIds = request.getStudentIdList();
        Long orgId = request.getOrgId();
        Set<Long> filterIds = new HashSet<>(studentIds);
        List<OrgStudent> searchStudent =
            this.orgStudentDao.searchStudent(orgId, filterIds, request.isAllStudent(), request.getPageDto());

        if (GenericsUtils.isNullOrEmpty(searchStudent)) {
            return GenericsUtils.emptyList();
        }

        return buildStudentDto(searchStudent, orgId, request.isNeedDistinct());
    }

    /**
     * @param searchStudent
     * @return 转换后的学员信息
     */
    private List<StudentDto> buildStudentDto(List<OrgStudent> searchStudent, Long orgId, boolean needDistinct) {
        if (GenericsUtils.isNullOrEmpty(searchStudent)) {
            return GenericsUtils.emptyList();
        }

        List<StudentDto> studentDtos = Lists.newArrayList();
        Set<String> mobiles = Sets.newHashSet();
        for (OrgStudent student : searchStudent) {
            String mobile = student.getStudentMobile();
            if (!needDistinct
                || (GenericsUtils.notNullAndEmpty(mobile) && !mobile.contains("****") && mobiles.add(mobile))) {
                StudentDto studentDto = new StudentDto();
                studentDto.setId(student.getId());
                Long userId = student.getUserId();
                String name = student.getName();
                name = GenericsUtils.isNullOrEmpty(name) ? student.getNickName() : name;
                studentDto.setName(name);
                studentDto.setMobile(mobile);
                studentDto.setUserId(userId);
                studentDtos.add(studentDto);
            }
        }

        Map<Long, String> studentAvatarUrlMap = studentApiService.batchGetStudentAvatarUrl(searchStudent);

        for (StudentDto dto : studentDtos) {
            String avatarUrl = studentAvatarUrlMap.get(dto.getId());
            if (avatarUrl != null) {
                dto.setAvatarUrl(avatarUrl);
            }
        }

        return studentDtos;
    }

    /**
     * 获取所有的短信群发记录
     */
    @Override
    public List<SmsGroupSendListDto> listSendRecord(final Long orgId, Long lastRecordId, PageDto pageDto) {
        List<SmsGroupSendRecord> listAllSmsGroupRecords =
            this.smsGroupSendRecordDao.listAllSmsGroupRecords(orgId, lastRecordId, pageDto, "id");
        if (GenericsUtils.isNullOrEmpty(listAllSmsGroupRecords)) {
            return GenericsUtils.emptyList();
        }
        Set<String> allRecordIds = Sets.newLinkedHashSet(
            CollectionUtils.extractList(listAllSmsGroupRecords, new Extracter<String, SmsGroupSendRecord>() {
                @Override
                public String extract(SmsGroupSendRecord arg0) {
                    return String.format(KEY_FORMAT, orgId, arg0.getId());
                }
            }));
        List<String> immutableKeys = Lists.newArrayList(allRecordIds);
        List<SmsGroupSendListDto> ret = Lists.newArrayList();
        ImmutableMap<String, SmsGroupSendListDto> allPresent = records.getAllPresent(allRecordIds);
        ret.addAll(allPresent.values());
        ImmutableSet<String> keySet = allPresent.keySet();
        allRecordIds.removeAll(keySet);
        try {
            if (GenericsUtils.notNullAndEmpty(allRecordIds)) {
                log.info("allRecordIds are : {} ", allRecordIds);
                ImmutableMap<String, SmsGroupSendListDto> all = records.getAll(allRecordIds);
                if (all != null) {
                    ret.addAll(all.values());
                }
            }
        } catch (Exception e) {
            log.error("can not get all from cache , and will get it from for-each ", e);
            for (String record : allRecordIds) {
                try {
                    ret.add(records.get(record));
                } catch (Exception e1) {
                    log.error("", e1);
                }
            }
        }
        Map<String, SmsGroupSendListDto> retMap =
            CollectionUtils.extractMap(ret, new CollectionUtils.Extracter<String, SmsGroupSendListDto>() {
                @Override
                public String extract(SmsGroupSendListDto arg0) {
                    return String.format(KEY_FORMAT, orgId, arg0.getRecordId());
                }
            });
        ret.clear();
        for (String key : immutableKeys) {
            ret.add(retMap.get(key));
        }
        return SmsGroupSendListDto.buildTurncatureResp(ret);
    }

    @Override
    public boolean markSendStatus(Long recordId, Long orgId, String failureStuIds) {
        log.info("will markSendStatus for orgId : {}  recordId: {} ", recordId, orgId);
        try {
            SmsGroupSendRecord searchRecordWithOrgId =
                this.smsGroupSendRecordDao.searchRecordWithOrgId(recordId, orgId);
            if (searchRecordWithOrgId == null) {
                log.info("can not find the record with orgId:{} and recordId:{} ", orgId, recordId);
                return false;
            }
            searchRecordWithOrgId.setSendStatus(SendStatus.SEND_OK.getCode());
            searchRecordWithOrgId.setSendTime(new Timestamp(System.currentTimeMillis()));
            this.records.invalidate(String.format(KEY_FORMAT, orgId, recordId));
            this.smsGroupSendRecordDao.saveOrUpdate(searchRecordWithOrgId);
            return true;
        } catch (Exception e) {
            log.error("can not markSendStatus cause by : {} ", e);
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.marketing.smsGroupSend.service.SmsGroupSendService#getSmsGroupSendRecordDetail(java.lang.
     * Integer, java.lang.Long)
     */
    @Override
    public SmsGroupSendListDto getSmsGroupSendRecordDetail(Integer orgId, Long recordId) {
        SmsGroupSendListDto sarchRecordWithOrgId = null;
        try {
            sarchRecordWithOrgId = this.records.get(String.format(KEY_FORMAT, orgId, recordId));
            if (sarchRecordWithOrgId == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "当前机构没有改群发记录");
            }
        } catch (Exception e) {
            log.error("can not getSmsGroupSendRecordDetail from cache or db cause by : ", e);
        }
        return sarchRecordWithOrgId;
    }

}
