package com.baijia.tianxiao.sal.marketing.draw.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.activity.dao.draw.PrizeInfoDao;
import com.baijia.tianxiao.dal.activity.po.draw.PrizeInfo;
import com.baijia.tianxiao.sal.marketing.draw.dto.PrizeInfoDto;
import com.baijia.tianxiao.sal.marketing.draw.service.DrawPrizesService;
import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 5:42:01 PM
 * @desc :
 */
@Service
public class DrawPrizesServiceImpl implements DrawPrizesService {

    @Autowired
    private PrizeInfoDao prizeInfoDao;

    @Override
    @Transactional("yunyingTransactionManager")
    public void addPrizeInfo(List<PrizeInfo> prizeInfos) {
        if (GenericsUtils.isNullOrEmpty(prizeInfos)) {
            return;
        }
        this.prizeInfoDao.batchAddPrizeInfos(prizeInfos);
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public void addPrizes(Long activityId, List<PrizeInfoDto> prizeInfoDtos) {
        if (GenericsUtils.isNullOrEmpty(prizeInfoDtos)) {
            return;
        }
        List<PrizeInfo> prizeInfos = toPrizeInfos(activityId, prizeInfoDtos);
        prizeInfoDao.batchAddPrizeInfos(prizeInfos);
    }

    private List<PrizeInfo> toPrizeInfos(Long activityId, List<PrizeInfoDto> prizeInfoDtos) {
        if (GenericsUtils.isNullOrEmpty(prizeInfoDtos)) {
            return Collections.emptyList();
        }
        List<PrizeInfo> prizeInfos = new ArrayList<>();
        for (PrizeInfoDto pid : prizeInfoDtos) {
            PrizeInfo buildPo = pid.buildPo();
            buildPo.setActivityId(activityId);
            prizeInfos.add(buildPo);

        }
        return prizeInfos;
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public void updatePrizes(Long activityId, List<PrizeInfo> prizeInfoDtos) {
        this.prizeInfoDao.deletePrizesByActivityId(activityId);
        this.addPrizeInfo(prizeInfoDtos);
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public void updatePrizesByDtos(Long activityId, List<PrizeInfoDto> prizeInfoDtos) {
        this.prizeInfoDao.deletePrizesByActivityId(activityId);
        this.addPrizes(activityId, prizeInfoDtos);
    }

    @Override
    public List<PrizeInfoDto> getPrizeInfoDtosByActivityId(Long activityId) {
        List<PrizeInfo> prizeInfos = this.prizeInfoDao.getPrizeInfosByActivityId(activityId);
        List<PrizeInfoDto> prizeInfoDtos = new ArrayList<>();
        if (GenericsUtils.isNullOrEmpty(prizeInfos)) {
            return Collections.emptyList();
        }
        for (PrizeInfo pi : prizeInfos) {
            PrizeInfoDto buildDto = PrizeInfoDto.buildDto(pi);
            prizeInfoDtos.add(buildDto);
        }
        return prizeInfoDtos;
    }

    @Override
    public List<PrizeInfo> getPrizeInfosByActivityId(Long activityId) {
        List<PrizeInfo> prizeInfos = this.prizeInfoDao.getPrizeInfosByActivityId(activityId);
        return prizeInfos;
    }

    @Override
    public PrizeInfo getPrizeById(Long drawId) {
        return this.prizeInfoDao.getPrizeInfosById(drawId);
    }

}
