package com.baijia.tianxiao.sal.marketing.draw.service;

import java.util.List;

import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityBase;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityDetail;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawActivityRequest;
import com.baijia.tianxiao.sal.marketing.draw.dto.DrawCacheDto;

/**
 * @author Rezar
 * @createDate :Jan 25, 2016 11:12:06 AM
 * @desc : 抽奖活动相关业务代码接口
 */
public interface DrawService {

    /**
     * 修改一个抽奖活动
     *
     * @param request
     * @return
     */
    public DrawActivityDetail modifyActivity(DrawActivityRequest request);

    /**
     * 获取某个机构所有抽奖活动的列表
     *
     * @param request
     * @return
     */
    public List<DrawActivityBase> getActivityList(DrawActivityRequest request);

    /**
     * 修改某个抽奖活动的状态
     *
     * @param request
     * @return
     */
    public boolean modifyStatus(DrawActivityRequest request);

    /**
     * 获取到一个抽奖活动的详细情况
     *
     * @return
     */
    public DrawActivityDetail getActivityDetail(DrawActivityRequest request);

    public DrawCacheDto getDrawCacheDtoFromDbById(long activityId);

}
