/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.marketing.commons.utils;

import com.baijia.tianxiao.sal.marketing.commons.enums.ConstantEnums;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.mail.Session;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年4月27日
 * @desc
 */
@Slf4j
public class ExcelMailSender {

    public static void sendMail(final String email, final String subject, final String content, final File[] files) {
        MailSendExecutor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    Mail mail = new Mail();
                    String from = ConstantEnums.TIANXIAO_MAILBOX_FROM.value();
                    String host = ConstantEnums.TIANXIAO_MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.TIANXIAO_MAILBOX_USERNAME.value();
                    String password = ConstantEnums.TIANXIAO_MAILBOX_PASSWORD.value();
                    mail.setFrom(from);
                    mail.setContent(content);
                    mail.addToAddress(email);
                    mail.setSubject(subject);
                    log.info("mail is : " + ToStringBuilder.reflectionToString(mail));
                    if(GenericsUtils.notNullAndEmpty(files)){
                        try {
                            for (File file : files) {
                                if (file.exists()) {
                                    AttachBean fileAttach = new AttachBean();
                                    fileAttach.setCid(file.getName());
                                    fileAttach.setFile(file);
                                    fileAttach.setFileName(file.getName());
                                    mail.addAttach(fileAttach);
                                }
                            }
                        } catch (Exception e) {
                            log.error("error :", e);
                        }
                    }
                    Session session = null;
                    if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                        session = MailUtils.createSession(host, username, password);
                    } else {
                        session = MailUtils.createSession(host);
                    }
                    MailUtils.send(session, mail);
                    log.info("send successful");
                    System.out.println("send successful");
                } catch (Exception ex) {
                    log.error("can not send email cause by {}", ex);
                } finally {
                    if(GenericsUtils.notNullAndEmpty(files)){
                        for (File file : files) {
                            if (file != null) {
                                file.delete();
                            }
                        }
                    }
                }
            }
        });
    }
    
    public static void sendMail(final String email, final String subject, final String content, final String fileName,
        final List<Map<String, String>> rows) {
        log.info("begin to send mail ");
        MailSendExecutor.execute(new Runnable() {
            @Override
            public void run() {
                File reportFile = null;
                try {
                    System.out.println("begin to send mail !");
                    Mail mail = new Mail();
                    String from = ConstantEnums.MAILBOX_FROM.value();
                    String host = ConstantEnums.MAILBOX_SMTPSERVIER.value();
                    String username = ConstantEnums.MAILBOX_USERNAME.value();
                    String password = ConstantEnums.MAILBOX_PASSWORD.value();
                    mail.setFrom(from);
                    mail.setContent(content);
                    mail.addToAddress(email);
                    mail.setSubject(subject);
                    try {
                        String filename = fileName + "_" + DateUtil.getStrByDate(new Date()) + ".xls";
                        reportFile = ExcelHelper.exportToExcelLocalFileFromMap(rows, filename);
                        if (reportFile == null) {
                            return;
                        }
                        log.info("PARTAKE FILE  path is : {}", reportFile.getAbsolutePath());
                        if (reportFile.exists()) {
                            AttachBean fileAttach = new AttachBean();
                            fileAttach.setCid(reportFile.getName());
                            fileAttach.setFile(reportFile);
                            fileAttach.setFileName(reportFile.getName());
                            mail.addAttach(fileAttach);
                        }
                    } catch (Exception e) {
                        log.error("error :", e);
                    }
                    Session session = null;
                    if (GenericsUtils.notNullAndEmpty(username) && GenericsUtils.notNullAndEmpty(password)) {
                        session = MailUtils.createSession(host, username, password);
                    } else {
                        session = MailUtils.createSession(host);
                    }
                    MailUtils.send(session, mail);
                    log.info("send successful");
                    System.out.println("send successful");
                } catch (Exception ex) {
                    log.error("can not send email cause by {}", ex);
                } finally {
                    if (reportFile != null) {
                        reportFile.delete();
                    }
                }
            }
        });
    }

}
