
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.marketing.commons.utils;

import java.util.regex.Pattern;

import com.baijia.tianxiao.util.GenericsUtils;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Aug 25, 2016
 * @Desc 判断中文
 */
public class CharUtils {

    /**
     * @introduce 中日韩统一表意文字（CJK Unified Ideographs），<br/>
     *            目的是要把分别来自中文、日文、韩文、越文中，本质、意义相同、形状一样或稍异的表意文字 <br/>
     *            （主要为汉字，但也有仿汉字如日本国字、韩国独有汉字、越南的喃字）于ISO <br/>
     *            10646及Unicode标准内赋予相同编码。<br/>
     *            CJK 是中文（Chinese）、日文（Japanese）、韩文（Korean）三国文字的缩写。顾名思义，它能够支持这三种文字 <br/>
     */

    /**
     * 根据Unicode编码，判断中文汉字和【符号】
     * 
     * @param c
     * @return
     */
    public static boolean isChineseChar(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
            || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
            || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
            || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B
            || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
            || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS
            || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return false;
    }

    /**
     * 判断中文汉字和符号(是否包含)
     * 
     * @param strName
     * @return
     */
    public static boolean isContainChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; i++) {
            char c = ch[i];
            if (isChineseChar(c)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 只能判断部分CJK字符
     * 
     * @param str
     * @return
     */
    public static boolean isChineseByREG(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str.trim()).find();
    }

    /**
     * 只能判断部分CJK字符<br/>
     * TODO 正则需要好好复习
     * 
     * @param str
     * @return
     */
    @Deprecated
    public static boolean isChineseByName(String str) {
        if (str == null) {
            return false;
        }
        // 大小写不同：\\p 表示包含，\\P 表示不包含
        // \\p{Cn} 的意思为 Unicode 中未被定义字符的编码，\\P{Cn} 就表示 Unicode中已经被定义字符的编码
        String reg = "\\p{InCJK Unified Ideographs}&&\\P{Cn}";
        Pattern pattern = Pattern.compile(reg);
        return pattern.matcher(str.trim()).find();
    }

    /**
     * 
     * 判断某个字符串是否为全英文字符
     * 
     * @param content
     * @return
     * @seeThat 匹配的英文字符我只包括了键盘上可见的字符,其余不常见的可自行补上
     */
    public static boolean isAllUS(String content) {
        if (GenericsUtils.isNullOrEmpty(content)) {
            return true;
        }
        content = content.trim();
        return content.equals(content.replaceAll("[^-a-zA-Z0-9,./\\;'\\]\\[|\\}\\{\":?><~`@#$%^&*()_€π+=\\s]+", ""))
            ? true : false;
    }

    public static void main(String[] args) {
        String content = "fdsaf fdsafdsjk ,afjdskfads";
        System.out.println(isAllUS(content));
    }

}
