package com.baijia.tianxiao.sal.marketing.commons.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baijia.tianxiao.sal.marketing.activity.dto.AreaDto;
import com.baijia.tianxiao.sal.marketing.activity.dto.AreaSerachRequest;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.gson.Gson;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * @author Rezar
 * @createDate :Jan 14, 2016 5:17:09 PM
 * @desc :
 */
public class AreaSearchUtils {

    private static Logger logger = LoggerFactory.getLogger(AreaSearchUtils.class);

    public static List<AreaDto> searchAreas(AreaSerachRequest request) {

        String url = "http://tapi.genshuixue.com/area/list";
        Map<String, String> params = new HashMap<>();
        params.put("p_id", String.valueOf(request.getpId()));
        params.put("level", String.valueOf(request.getLevel()));

        String charset = "utf-8";
        try {
            ArrayList<Header> headers = new ArrayList<>();
            Header head1 = new BasicHeader("content_Type", "application/x-www-form-urlencoded");
            headers.add(head1);
            String doJsonPost = HttpClientUtils.doPost(url, params, charset, headers);
            JSONObject fromObject = JSONObject.fromObject(doJsonPost);
            Integer code = fromObject.getInt("code");
            if (code != null && code == 1) {
                JSONObject resultObj = fromObject.getJSONObject("result");
                if (resultObj == null) {
                    return Collections.emptyList();
                }
                JSONArray jsonArray = resultObj.getJSONArray("list");
                int length = jsonArray.size();
                List<AreaDto> areaDtos = new ArrayList<>(length);
                Gson gson = new Gson();
                for (int i = 0; i < length; i++) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String json = jsonObject.toString();
                    areaDtos.add(gson.fromJson(json, AreaDto.class));
                }
                return areaDtos;
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("can not find any sub area with pid : {} in level {}", request.getpId(), request.getLevel());
        }
        return Collections.emptyList();
    }

    public static void main(String[] args) {
        AreaSerachRequest request = new AreaSerachRequest();
        List<AreaDto> searchAreas = searchAreas(request);
        System.out.println(searchAreas);
    }

}
