package com.baijia.tianxiao.sal.marketing.commons.service.impl;

import com.baijia.tianxiao.dal.activity.dao.ActivityAccessLogDao;
import com.baijia.tianxiao.dal.activity.dao.TxActivityCommonDao;
import com.baijia.tianxiao.dal.activity.po.ActivityAccessLog;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.TxActivityCommon;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import com.baijia.tianxiao.sal.marketing.commons.service.ActivityAccessLogService;
import com.baijia.tianxiao.sal.marketing.commons.service.TxActivityCommonService;
import com.baijia.tianxiao.util.date.DateUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by liuxp on 16/1/13.
 */
@Service
@Slf4j
public class ActivityAccessLogServiceImpl implements ActivityAccessLogService {

    @Autowired
    private ActivityAccessLogDao accessLogDao;
    @Autowired
    private TxActivityCommonService txActivityCommonService;
    @Autowired
    private TxActivityCommonDao txActivityCommonDao;

    @Override
    public List<DairyCountStatistics> getLastDayLog(Long activityId, List<String> dateList,TemplateTypeCategory category) {
        List<ActivityAccessLog> list = accessLogDao.selectActivityAccessLogByDate(dateList,activityId,category.getType());
        List<DairyCountStatistics> statisticsList = new ArrayList<>();
        if(list!=null && list.size()>0){
            for(ActivityAccessLog log:list)
                statisticsList.add(new DairyCountStatistics(log.getAccessDate(),log.getAccessCount()));
        }
        return statisticsList;
    }

    @Override
    public int getTotalAccessCount(Long activityId,TemplateTypeCategory category) {
        Map<Long,Integer> map = accessLogDao.selectTotalByActivityId(Arrays.asList(activityId),category.getType());
        return map.get(activityId)==null?0:map.get(activityId);
    }

    @Override
    @Transactional("yunyingTransactionManager")
    public void setTodayAccessCount(Long activityId,TemplateTypeCategory category) {
        String dateStr = DateUtil.getStrByDateFormate(new Date(),"yyyy-MM-dd");
        //数据库已经按照 date activityId, catetary添加了唯一索引
        List<ActivityAccessLog> accessLogs = accessLogDao.selectActivityAccessLogByDate(Arrays.asList(dateStr), activityId,category.getType());
        log.info("[ActivityAccessLog] accessLogs1 param:{}", accessLogs);
        if(accessLogs==null || accessLogs.isEmpty()){
            log.info("[ActivityAccessLog] accessLogs2 param:{}", accessLogs);
            ActivityAccessLog accessLog = new ActivityAccessLog();
            accessLog.setAccessCount(1);
            accessLog.setAccessDate(dateStr);
            accessLog.setActivityId(activityId);
            accessLog.setUpdateTime(new Date());
            accessLog.setCategory(category.getType());
            accessLogDao.insertActivityAccessLog(accessLog);
        }else {
            ActivityAccessLog accessLog = accessLogs.get(0);
            accessLog.setAccessCount(accessLog.getAccessCount() + 1);
            accessLogDao.update(accessLog);
//            accessLogDao.updateActivityAccessLog(activityId,dateStr);
        }
        
        //将数据同步到tx_activity_conf中
        int accessAccount = this.getTotalAccessCount(activityId, category);
        log.info("accessAccount:{}", accessAccount);
        TxActivityCommon conf = txActivityCommonDao.getTxActivityCommon(null, category.getTypeId(), activityId);
        conf.setAccessCount(accessAccount);
        txActivityCommonService.saveOrUpdateTxActivityCommon(conf, null, null, null, "accessCount");
    }

}
